/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonRequiredPropsReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JsonSchemaReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(Holder.REF_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(false));
        registrar.registerReferenceProvider(Holder.REC_REF_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(false));
        registrar.registerReferenceProvider(Holder.SCHEMA_PATTERN, (PsiReferenceProvider)new JsonPointerReferenceProvider(true));
        registrar.registerReferenceProvider(Holder.REQUIRED_PROP_PATTERN, (PsiReferenceProvider)new JsonRequiredPropsReferenceProvider());
    }

    private static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull String propertyName, final boolean schemaOnly, final boolean rootOnly) {
        if (propertyName == null) {
            JsonSchemaReferenceContributor.$$$reportNull$$$0(1);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JsonProperty property2;
                if (element instanceof JsonValue && (property2 = (JsonProperty)ObjectUtils.tryCast((Object)((JsonValue)element).getParent(), JsonProperty.class)) != null && property2.getValue() == element && propertyName.equals(property2.getName())) {
                    PsiFile file = property2.getContainingFile();
                    if (rootOnly && (!(file instanceof JsonFile) || ((JsonFile)file).getTopLevelValue() != property2.getParent())) {
                        return false;
                    }
                    return !schemaOnly || JsonSchemaService.isSchemaFile((PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)file));
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static PsiElementPattern.Capture<JsonStringLiteral> createRequiredPropPattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (!(element instanceof JsonStringLiteral)) {
                    return false;
                }
                PsiElement parent = ((JsonStringLiteral)element).getParent();
                if (!(parent instanceof JsonArray)) {
                    return false;
                }
                PsiElement property2 = parent.getParent();
                if (!(property2 instanceof JsonProperty)) {
                    return false;
                }
                return "required".equals(((JsonProperty)property2).getName()) && JsonSchemaService.isSchemaFile(((JsonStringLiteral)element).getContainingFile());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyValuePattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final PsiElementPattern.Capture<JsonValue> REF_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$ref", true, false);
        private static final PsiElementPattern.Capture<JsonValue> REC_REF_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$recursiveRef", true, false);
        private static final PsiElementPattern.Capture<JsonValue> SCHEMA_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$schema", false, true);
        private static final PsiElementPattern.Capture<JsonStringLiteral> REQUIRED_PROP_PATTERN = JsonSchemaReferenceContributor.createRequiredPropPattern();

        private Holder() {
        }
    }
}

