/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaTreeNode {
    private boolean myAny;
    private boolean myNothing;
    private int myExcludingGroupNumber = -1;
    @NotNull
    private SchemaResolveState myResolveState = SchemaResolveState.normal;
    @Nullable
    private final JsonSchemaObject mySchema;
    @NotNull
    private final JsonPointerPosition myPosition;
    @Nullable
    private final JsonSchemaTreeNode myParent;
    @NotNull
    private final List<JsonSchemaTreeNode> myChildren = new ArrayList<JsonSchemaTreeNode>();

    public JsonSchemaTreeNode(@Nullable JsonSchemaTreeNode parent, @Nullable JsonSchemaObject schema) {
        assert (schema != null || parent != null);
        this.myParent = parent;
        this.mySchema = schema;
        JsonPointerPosition steps = parent != null ? parent.getPosition().skip(1) : null;
        this.myPosition = steps == null ? new JsonPointerPosition() : steps;
    }

    public void anyChild() {
        JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
        node.myAny = true;
        this.myChildren.add(node);
    }

    public void nothingChild() {
        JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
        node.myNothing = true;
        this.myChildren.add(node);
    }

    public void createChildrenFromOperation(@NotNull JsonSchemaVariantsTreeBuilder.Operation operation) {
        if (operation == null) {
            JsonSchemaTreeNode.$$$reportNull$$$0(0);
        }
        if (!SchemaResolveState.normal.equals((Object)operation.myState)) {
            JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
            node.myResolveState = operation.myState;
            this.myChildren.add(node);
            return;
        }
        if (!operation.myAnyOfGroup.isEmpty()) {
            this.myChildren.addAll(this.convertToNodes(operation.myAnyOfGroup));
        }
        if (!operation.myOneOfGroup.isEmpty()) {
            int i = 0;
            while (i < operation.myOneOfGroup.size()) {
                List<JsonSchemaObject> group2 = operation.myOneOfGroup.get(i);
                List<JsonSchemaTreeNode> children = this.convertToNodes(group2);
                int number = i++;
                children.forEach(c -> {
                    c.myExcludingGroupNumber = number;
                });
                this.myChildren.addAll(children);
            }
        }
    }

    private List<JsonSchemaTreeNode> convertToNodes(List<JsonSchemaObject> children) {
        ArrayList<JsonSchemaTreeNode> nodes = new ArrayList<JsonSchemaTreeNode>(children.size());
        for (JsonSchemaObject child : children) {
            nodes.add(new JsonSchemaTreeNode(this, child));
        }
        return nodes;
    }

    @NotNull
    public SchemaResolveState getResolveState() {
        SchemaResolveState schemaResolveState = this.myResolveState;
        if (schemaResolveState == null) {
            JsonSchemaTreeNode.$$$reportNull$$$0(1);
        }
        return schemaResolveState;
    }

    public boolean isAny() {
        return this.myAny;
    }

    public boolean isNothing() {
        return this.myNothing;
    }

    public void setChild(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaTreeNode.$$$reportNull$$$0(2);
        }
        this.myChildren.add(new JsonSchemaTreeNode(this, schema));
    }

    @Nullable
    public JsonSchemaObject getSchema() {
        return this.mySchema;
    }

    @NotNull
    public JsonPointerPosition getPosition() {
        JsonPointerPosition jsonPointerPosition = this.myPosition;
        if (jsonPointerPosition == null) {
            JsonSchemaTreeNode.$$$reportNull$$$0(3);
        }
        return jsonPointerPosition;
    }

    @Nullable
    public JsonSchemaTreeNode getParent() {
        return this.myParent;
    }

    @NotNull
    public List<JsonSchemaTreeNode> getChildren() {
        List<JsonSchemaTreeNode> list = this.myChildren;
        if (list == null) {
            JsonSchemaTreeNode.$$$reportNull$$$0(4);
        }
        return list;
    }

    public int getExcludingGroupNumber() {
        return this.myExcludingGroupNumber;
    }

    public void setPosition(@NotNull JsonPointerPosition steps) {
        if (steps == null) {
            JsonSchemaTreeNode.$$$reportNull$$$0(5);
        }
        this.myPosition.updateFrom(steps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaTreeNode node = (JsonSchemaTreeNode)o;
        if (this.myAny != node.myAny) {
            return false;
        }
        if (this.myNothing != node.myNothing) {
            return false;
        }
        if (this.myResolveState != node.myResolveState) {
            return false;
        }
        if (!Objects.equals(this.mySchema, node.mySchema)) {
            return false;
        }
        return this.myPosition.equals(node.myPosition);
    }

    public int hashCode() {
        int result2 = this.myAny ? 1 : 0;
        result2 = 31 * result2 + (this.myNothing ? 1 : 0);
        result2 = 31 * result2 + this.myResolveState.hashCode();
        result2 = 31 * result2 + (this.mySchema != null ? this.mySchema.hashCode() : 0);
        result2 = 31 * result2 + this.myPosition.hashCode();
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NODE#" + this.hashCode() + "\n");
        sb.append(this.myPosition.toString());
        sb.append("\n");
        if (this.myExcludingGroupNumber >= 0) {
            sb.append("in excluding group\n");
        }
        if (this.myAny) {
            sb.append("any");
        } else if (this.myNothing) {
            sb.append("nothing");
        } else if (!SchemaResolveState.normal.equals((Object)this.myResolveState)) {
            sb.append(this.myResolveState.name());
        } else {
            assert (this.mySchema != null);
            sb.append("schema").append("\n");
            if (this.mySchema.getRef() != null) {
                sb.append("$ref: ").append(this.mySchema.getRef()).append("\n");
            } else if (!this.mySchema.getProperties().isEmpty()) {
                sb.append("properties: ");
                sb.append(String.join((CharSequence)", ", this.mySchema.getProperties().keySet())).append("\n");
            }
            if (!this.myChildren.isEmpty()) {
                sb.append("OR children of NODE#").append(this.hashCode()).append(":\n----------------\n").append(this.myChildren.stream().map(Object::toString).collect(Collectors.joining("\n"))).append("\n=================\n");
            }
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "steps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createChildrenFromOperation";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPosition";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

