/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.instrumentation.ClassWriterImpl;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntellijClassfileTransformer
implements ClassFileTransformer {
    private final boolean computeFrames = this.computeFrames();
    private final WeakHashMap<ClassLoader, Map<String, ClassReader>> classReaders = new WeakHashMap();
    private long ourTime;
    private int ourClassCount;

    protected AbstractIntellijClassfileTransformer() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                double allTime = 1.0 * (double)AbstractIntellijClassfileTransformer.this.ourTime / 1.0E9;
                ErrorReporter.logInfo("Class transformation time: " + allTime + "s for " + AbstractIntellijClassfileTransformer.this.ourClassCount + " classes or " + allTime / (double)AbstractIntellijClassfileTransformer.this.ourClassCount + "s per class");
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        long s = System.nanoTime();
        try {
            byte[] byArray = this.transformInner(loader, className, classFileBuffer);
            return byArray;
        }
        finally {
            ++this.ourClassCount;
            this.ourTime += System.nanoTime() - s;
        }
    }

    private byte[] transformInner(ClassLoader loader, String className, byte[] classFileBuffer) {
        if (this.isStopped()) {
            return null;
        }
        try {
            if (className == null) {
                return null;
            }
            className = ClassNameUtil.removeClassSuffix(className);
            if ((className = ClassNameUtil.convertToFQName(className)).startsWith("com.intellij.rt.") || className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("jdk.") || className.startsWith("org.jetbrains.coverage.gnu.trove.") || className.startsWith("org.jetbrains.coverage.org.objectweb.")) {
                return null;
            }
            if (this.shouldExclude(className)) {
                return null;
            }
            this.visitClassLoader(loader);
            InclusionPattern inclusionPattern = this.getInclusionPattern();
            if (inclusionPattern == null ? loader != null : inclusionPattern.accept(className)) {
                return this.instrument(classFileBuffer, className, loader, this.computeFrames);
            }
        }
        catch (Throwable e) {
            ErrorReporter.reportError("Error during class instrumentation: " + className, e);
        }
        return null;
    }

    public byte[] instrument(byte[] classfileBuffer, String className, ClassLoader loader, boolean computeFrames) {
        ClassWriterImpl cw;
        ClassReader cr = new ClassReader(classfileBuffer);
        if (computeFrames) {
            int version = AbstractIntellijClassfileTransformer.getClassFileVersion(cr);
            int flags = (version & 0xFFFF) >= 50 && version != 196653 ? 2 : 1;
            cw = new ClassWriterImpl(flags, loader, this.classReaders);
        } else {
            cw = new ClassWriterImpl(1, loader, this.classReaders);
        }
        ClassVisitor cv = this.createClassVisitor(className, loader, cr, cw);
        if (cv == null) {
            return null;
        }
        cr.accept(cv, 8);
        return cw.toByteArray();
    }

    protected abstract ClassVisitor createClassVisitor(String var1, ClassLoader var2, ClassReader var3, ClassVisitor var4);

    protected abstract boolean shouldExclude(String var1);

    protected InclusionPattern getInclusionPattern() {
        return null;
    }

    protected void visitClassLoader(ClassLoader classLoader) {
    }

    protected boolean isStopped() {
        return false;
    }

    private boolean computeFrames() {
        return System.getProperty("idea.coverage.no.frames") == null;
    }

    private static int getClassFileVersion(ClassReader reader) {
        return reader.readInt(4);
    }

    public static interface InclusionPattern {
        public boolean accept(String var1);
    }
}

