/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxColorProvider
implements ElementColorProvider {
    private static final String COLOR = "color";
    private static final String RGB = "rgb";
    private static final String GRAY = "gray";
    private static final String GRAY_RGB = "grayRgb";
    private static final String HSB = "hsb";
    private static final Set<String> FACTORY_METHODS = Set.of("color", "rgb", "gray", "grayRgb", "hsb");
    private static final String DECIMAL_FORMAT_PATTERN = "#.####";
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);

    public Color getColorFrom(@NotNull PsiElement element) {
        PsiElement gp;
        if (element == null) {
            JavaFxColorProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = element.getParent();
        PsiElement psiElement = gp = parent == null ? null : parent.getParent();
        if (gp instanceof PsiNewExpression) {
            PsiExpression[] args;
            PsiExpressionList argumentList;
            PsiNewExpression newExpression = (PsiNewExpression)gp;
            if (((PsiNewExpression)gp).getClassReference() == parent && JavaFxColorProvider.isColorClass(PsiTypesUtil.getPsiClass((PsiType)newExpression.getType())) && (argumentList = newExpression.getArgumentList()) != null && (args = argumentList.getExpressions()).length == 4) {
                Object[] values = JavaFxColorProvider.getArgumentValues(args);
                return JavaFxColorProvider.getScaledRgbColor(values[0], values[1], values[2], values[3]);
            }
        }
        while (parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiReferenceExpression) {
            parent = parent.getParent();
            gp = parent.getParent();
        }
        if (gp instanceof PsiMethodCallExpression) {
            PsiMethod method;
            PsiElement resolved;
            PsiReferenceExpression methodExpression;
            String methodName;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)gp;
            if (((PsiMethodCallExpression)gp).getMethodExpression().getReferenceNameElement() == element && FACTORY_METHODS.contains(methodName = (methodExpression = methodCall.getMethodExpression()).getReferenceName()) && (resolved = methodExpression.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).hasModifierProperty("static") && JavaFxColorProvider.isColorClass(method.getContainingClass())) {
                return JavaFxColorProvider.getColor(methodName, methodCall.getArgumentList());
            }
        }
        return null;
    }

    private static boolean isColorClass(@Nullable PsiClass aClass) {
        return aClass != null && "javafx.scene.paint.Color".equals(aClass.getQualifiedName());
    }

    @Nullable
    private static Color getColor(@Nullable String methodName, @NotNull PsiExpressionList argumentList) {
        if (argumentList == null) {
            JavaFxColorProvider.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            return null;
        }
        Object[] values = JavaFxColorProvider.getArgumentValues(argumentList.getExpressions());
        return switch (methodName) {
            case COLOR -> {
                switch (values.length) {
                    case 4: {
                        yield JavaFxColorProvider.getScaledRgbColor(values[0], values[1], values[2], values[3]);
                    }
                    case 3: {
                        yield JavaFxColorProvider.getScaledRgbColor(values[0], values[1], values[2], 1.0);
                    }
                }
                yield null;
            }
            case RGB -> {
                switch (values.length) {
                    case 4: {
                        yield JavaFxColorProvider.getRgbColor(values[0], values[1], values[2], values[3]);
                    }
                    case 3: {
                        yield JavaFxColorProvider.getRgbColor(values[0], values[1], values[2], 1.0);
                    }
                }
                yield null;
            }
            case GRAY -> {
                switch (values.length) {
                    case 2: {
                        yield JavaFxColorProvider.getScaledRgbColor(values[0], values[0], values[0], values[1]);
                    }
                    case 1: {
                        yield JavaFxColorProvider.getScaledRgbColor(values[0], values[0], values[0], 1.0);
                    }
                }
                yield null;
            }
            case GRAY_RGB -> {
                switch (values.length) {
                    case 2: {
                        yield JavaFxColorProvider.getRgbColor(values[0], values[0], values[0], values[1]);
                    }
                    case 1: {
                        yield JavaFxColorProvider.getRgbColor(values[0], values[0], values[0], 1.0);
                    }
                }
                yield null;
            }
            case HSB -> {
                switch (values.length) {
                    case 4: {
                        yield JavaFxColorProvider.getHsbColor(values[0], values[1], values[2], values[3]);
                    }
                    case 3: {
                        yield JavaFxColorProvider.getHsbColor(values[0], values[1], values[2], 1.0);
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    private static Object @NotNull [] getArgumentValues(PsiExpression @NotNull [] argumentExpressions) {
        if (argumentExpressions == null) {
            JavaFxColorProvider.$$$reportNull$$$0(2);
        }
        Object[] objectArray = ContainerUtil.map((Object[])argumentExpressions, expression -> JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)expression, (boolean)false), (Object[])ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        if (objectArray == null) {
            JavaFxColorProvider.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @Nullable
    private static Color getScaledRgbColor(@Nullable Object redValue, @Nullable Object greenValue, @Nullable Object blueValue, @Nullable Object alphaValue) {
        Integer red = JavaFxColorProvider.getScaledComponent(redValue);
        Integer green = JavaFxColorProvider.getScaledComponent(greenValue);
        Integer blue = JavaFxColorProvider.getScaledComponent(blueValue);
        Integer alpha = JavaFxColorProvider.getScaledComponent(alphaValue);
        if (red != null && green != null && blue != null && alpha != null) {
            return new Color(red, green, blue, alpha);
        }
        return null;
    }

    @Nullable
    private static Color getRgbColor(@Nullable Object redValue, @Nullable Object greenValue, @Nullable Object blueValue, @Nullable Object alphaValue) {
        Integer red = JavaFxColorProvider.getComponent(redValue);
        Integer green = JavaFxColorProvider.getComponent(greenValue);
        Integer blue = JavaFxColorProvider.getComponent(blueValue);
        Integer alpha = JavaFxColorProvider.getScaledComponent(alphaValue);
        if (red != null && green != null && blue != null && alpha != null) {
            return new Color(red, green, blue, alpha);
        }
        return null;
    }

    private static Integer getComponent(Object value) {
        int component;
        if (value instanceof Number && (component = ((Number)value).intValue()) >= 0 && component <= 255) {
            return component;
        }
        return null;
    }

    private static Integer getScaledComponent(Object value) {
        double doubleValue;
        int component;
        if (value instanceof Number && (component = (int)((doubleValue = ((Number)value).doubleValue()) * 255.0 + 0.5)) >= 0 && component <= 255) {
            return component;
        }
        return null;
    }

    private static Float getHsbComponent(Object value, boolean checkRange) {
        if (value instanceof Number) {
            float component = ((Number)value).floatValue();
            if (!checkRange || component >= 0.0f && component <= 1.0f) {
                return Float.valueOf(component);
            }
        }
        return null;
    }

    public void setColorTo(@NotNull PsiElement element, @NotNull Color color) {
        if (element == null) {
            JavaFxColorProvider.$$$reportNull$$$0(4);
        }
        if (color == null) {
            JavaFxColorProvider.$$$reportNull$$$0(5);
        }
        Runnable command = null;
        if (element instanceof PsiNewExpression) {
            PsiNewExpression expr = (PsiNewExpression)element;
            PsiExpressionList argumentList = expr.getArgumentList();
            assert (argumentList != null);
            command = () -> JavaFxColorProvider.replaceConstructorArgs(color, argumentList);
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (COLOR.equals(methodName) || GRAY.equals(methodName)) {
                command = () -> JavaFxColorProvider.replaceColor(methodCall, JavaFxColorProvider.getScaledRgbCallText(color));
            } else if (RGB.equals(methodName) || GRAY_RGB.equals(methodName)) {
                command = () -> JavaFxColorProvider.replaceColor(methodCall, JavaFxColorProvider.getRgbCallText(color));
            } else if (HSB.equals(methodName)) {
                command = () -> JavaFxColorProvider.replaceColor(methodCall, JavaFxColorProvider.getHsbCallText(color));
            }
        }
        if (command != null) {
            Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
            CommandProcessor.getInstance().executeCommand(element.getProject(), command, JavaBundle.message((String)"change.color.command.text", (Object[])new Object[0]), null, document);
        }
    }

    private static void replaceConstructorArgs(@NotNull Color color, PsiExpressionList argumentList) {
        if (color == null) {
            JavaFxColorProvider.$$$reportNull$$$0(6);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)argumentList.getProject());
        String text = "javafx.scene.paint.Color(" + JavaFxColorProvider.formatScaledComponent(color.getRed()) + "," + JavaFxColorProvider.formatScaledComponent(color.getGreen()) + "," + JavaFxColorProvider.formatScaledComponent(color.getBlue()) + "," + JavaFxColorProvider.formatScaledComponent(color.getAlpha()) + ")";
        PsiMethodCallExpression newCall = (PsiMethodCallExpression)factory.createExpressionFromText(text, (PsiElement)argumentList);
        argumentList.replace((PsiElement)newCall.getArgumentList());
    }

    private static void replaceColor(@NotNull PsiMethodCallExpression methodCall, @NotNull String callText) {
        if (methodCall == null) {
            JavaFxColorProvider.$$$reportNull$$$0(7);
        }
        if (callText == null) {
            JavaFxColorProvider.$$$reportNull$$$0(8);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)methodCall.getProject());
        PsiMethodCallExpression newCall = (PsiMethodCallExpression)factory.createExpressionFromText(callText, (PsiElement)methodCall);
        methodCall.getArgumentList().replace((PsiElement)newCall.getArgumentList());
        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
        assert (nameElement != null);
        PsiElement newNameElement = newCall.getMethodExpression().getReferenceNameElement();
        assert (newNameElement != null);
        nameElement.replace(newNameElement);
    }

    private static Color getHsbColor(Object hValue, Object sValue, Object bValue, Object alphaValue) {
        Float h = JavaFxColorProvider.getHsbComponent(hValue, false);
        Float s = JavaFxColorProvider.getHsbComponent(sValue, true);
        Float b = JavaFxColorProvider.getHsbComponent(bValue, true);
        Integer alpha = JavaFxColorProvider.getScaledComponent(alphaValue);
        if (h != null && s != null && b != null && alpha != null) {
            Color hsbColor = Color.getHSBColor(h.floatValue() / 360.0f, s.floatValue(), b.floatValue());
            return alpha == 255 ? hsbColor : new Color(hsbColor.getRed(), hsbColor.getGreen(), hsbColor.getBlue(), alpha);
        }
        return null;
    }

    @NotNull
    private static String getScaledRgbCallText(@NotNull Color color) {
        if (color == null) {
            JavaFxColorProvider.$$$reportNull$$$0(9);
        }
        return JavaFxColorProvider.getCallText(color, COLOR, GRAY, JavaFxColorProvider::formatScaledComponent);
    }

    @NotNull
    private static String getRgbCallText(@NotNull Color color) {
        if (color == null) {
            JavaFxColorProvider.$$$reportNull$$$0(10);
        }
        return JavaFxColorProvider.getCallText(color, RGB, GRAY_RGB, String::valueOf);
    }

    @NotNull
    private static String getCallText(@NotNull Color color, String colorMethodName, String grayMethodName, IntFunction<String> formatter) {
        String methodName;
        if (color == null) {
            JavaFxColorProvider.$$$reportNull$$$0(11);
        }
        StringJoiner args = new StringJoiner(",", "(", ")");
        if (color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
            methodName = grayMethodName;
            args.add(formatter.apply(color.getRed()));
        } else {
            methodName = colorMethodName;
            args.add(formatter.apply(color.getRed()));
            args.add(formatter.apply(color.getGreen()));
            args.add(formatter.apply(color.getBlue()));
        }
        if (color.getAlpha() != 255) {
            args.add(JavaFxColorProvider.formatScaledComponent(color.getAlpha()));
        }
        String string = methodName + args;
        if (string == null) {
            JavaFxColorProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String formatScaledComponent(int colorComponent) {
        DecimalFormat df = new DecimalFormat(DECIMAL_FORMAT_PATTERN, DECIMAL_FORMAT_SYMBOLS);
        String string = df.format((double)colorComponent / 255.0);
        if (string == null) {
            JavaFxColorProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static String getHsbCallText(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        DecimalFormat df = new DecimalFormat(DECIMAL_FORMAT_PATTERN, DECIMAL_FORMAT_SYMBOLS);
        StringJoiner args = new StringJoiner(",", "(", ")");
        args.add(df.format(hsb[0] * 360.0f));
        args.add(df.format(hsb[1]));
        args.add(df.format(hsb[2]));
        if (color.getAlpha() != 255) {
            args.add(JavaFxColorProvider.formatScaledComponent(color.getAlpha()));
        }
        return HSB + args;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentExpressions";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = COLOR;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatScaledComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getColorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValues";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColorTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceConstructorArgs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceColor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScaledRgbCallText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRgbCallText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCallText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 13 -> new IllegalStateException(string);
        };
    }
}

