/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;

public class JavaFxComponentIdReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlAttributeValue xmlAttributeValue;
        String value;
        if (element == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(1);
        }
        if (JavaFxPsiUtil.isIncorrectExpressionBinding(value = (xmlAttributeValue = (XmlAttributeValue)element).getValue())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlTag.class);
        Map<String, XmlAttributeValue> fileIds = JavaFxPsiUtil.collectFileIds(currentTag);
        if (JavaFxPsiUtil.isExpressionBinding(value)) {
            return JavaFxComponentIdReferenceProvider.getExpressionReferences(element, xmlAttributeValue, value, fileIds);
        }
        if (value.startsWith("$")) {
            return JavaFxComponentIdReferenceProvider.getSinglePropertyReferences(xmlAttributeValue, value, fileIds);
        }
        HashSet<String> acceptableIds = new HashSet<String>();
        if (currentTag != null) {
            XmlTag parentTag = currentTag.getParentTag();
            for (String id : fileIds.keySet()) {
                XmlAttributeValue resolvedAttrValue = fileIds.get(id);
                if (!JavaFxPsiUtil.isClassAcceptable(parentTag, JavaFxPsiUtil.getTagClass(resolvedAttrValue))) continue;
                acceptableIds.add(id);
            }
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, acceptableIds, value)};
        if (psiReferenceArray == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static PsiReference @NotNull [] getExpressionReferences(@NotNull PsiElement element, @NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value, @NotNull Map<String, XmlAttributeValue> fileIds) {
        if (element == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(4);
        }
        if (xmlAttributeValue == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(5);
        }
        if (value == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(6);
        }
        if (fileIds == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(7);
        }
        if ("${null}".equals(value)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(8);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String expressionBody = value.substring(2, value.length() - 1);
        List propertyNames = StringUtil.split((String)expressionBody, (String)".", (boolean)true, (boolean)false);
        if (JavaFxPropertyAttributeDescriptor.isIncompletePropertyChain(propertyNames)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(9);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (propertyNames.size() == 1) {
            return JavaFxComponentIdReferenceProvider.getSinglePropertyReferences(xmlAttributeValue, fileIds, expressionBody, 2);
        }
        PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(element.getContainingFile());
        String firstPropertyName = (String)propertyNames.get(0);
        int positionInExpression = 2;
        ArrayList<PsiReferenceBase> result = new ArrayList<PsiReferenceBase>();
        PsiReferenceBase firstReference = JavaFxComponentIdReferenceProvider.getIdReferenceBase(xmlAttributeValue, firstPropertyName, fileIds, Collections.emptyMap(), controllerClass);
        positionInExpression = JavaFxComponentIdReferenceProvider.adjustTextRange(firstPropertyName, firstReference, positionInExpression);
        PsiClass propertyOwnerClass = "controller".equals(firstPropertyName) ? controllerClass : JavaFxPsiUtil.getTagClass(fileIds.get(firstPropertyName));
        result.add(firstReference);
        List remainingPropertyNames = propertyNames.subList(1, propertyNames.size());
        for (String propertyName : remainingPropertyNames) {
            JavaFxExpressionReferenceBase reference = new JavaFxExpressionReferenceBase(xmlAttributeValue, propertyOwnerClass, propertyName);
            positionInExpression = JavaFxComponentIdReferenceProvider.adjustTextRange(propertyName, reference, positionInExpression);
            PsiType propertyType = JavaFxPsiUtil.getReadablePropertyType(reference.resolve());
            propertyOwnerClass = propertyType instanceof PsiClassType ? ((PsiClassType)propertyType).resolve() : null;
            result.add(reference);
        }
        PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    private static PsiReference @NotNull [] getSinglePropertyReferences(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull String value, @NotNull Map<String, XmlAttributeValue> fileIds) {
        if (xmlAttributeValue == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(11);
        }
        if (value == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(12);
        }
        if (fileIds == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(13);
        }
        if (FxmlConstants.isNullValue(value)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(14);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        return JavaFxComponentIdReferenceProvider.getSinglePropertyReferences(xmlAttributeValue, fileIds, value.substring(1), 1);
    }

    private static PsiReference @NotNull [] getSinglePropertyReferences(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull Map<String, XmlAttributeValue> fileIds, @NotNull String propertyName, int positionInExpression) {
        if (xmlAttributeValue == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(15);
        }
        if (fileIds == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(16);
        }
        if (propertyName == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(17);
        }
        PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(xmlAttributeValue.getContainingFile());
        Map<String, TypeMatch> typeMatches = JavaFxComponentIdReferenceProvider.getTypeMatches(xmlAttributeValue, fileIds);
        PsiReferenceBase reference = JavaFxComponentIdReferenceProvider.getIdReferenceBase(xmlAttributeValue, propertyName, fileIds, typeMatches, controllerClass);
        JavaFxComponentIdReferenceProvider.adjustTextRange(propertyName, reference, positionInExpression);
        PsiReference[] psiReferenceArray = new PsiReference[]{reference};
        if (psiReferenceArray == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(18);
        }
        return psiReferenceArray;
    }

    private static Map<String, TypeMatch> getTypeMatches(@NotNull XmlAttributeValue xmlAttributeValue, @NotNull Map<String, XmlAttributeValue> fileIds) {
        PsiClass targetPropertyClass;
        if (xmlAttributeValue == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(19);
        }
        if (fileIds == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(20);
        }
        boolean isConvertible = (targetPropertyClass = JavaFxPsiUtil.getWritablePropertyClass(xmlAttributeValue)) != null && JavaFxPsiUtil.hasConversionFromAnyType(targetPropertyClass);
        return fileIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            PsiClass valueClass = JavaFxPsiUtil.getTagClassById((XmlAttributeValue)e.getValue(), (String)e.getKey(), (PsiElement)xmlAttributeValue);
            return TypeMatch.getMatch(valueClass, targetPropertyClass, isConvertible);
        }));
    }

    private static int adjustTextRange(@NotNull String propertyName, @NotNull PsiReferenceBase reference, int positionInExpression) {
        if (propertyName == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(21);
        }
        if (reference == null) {
            JavaFxComponentIdReferenceProvider.$$$reportNull$$$0(22);
        }
        TextRange range = reference.getRangeInElement();
        int startOffset = range.getStartOffset() + positionInExpression;
        int endOffset = startOffset + propertyName.length();
        reference.setRangeInElement(new TextRange(startOffset, endOffset));
        return positionInExpression + propertyName.length() + 1;
    }

    @NotNull
    private static PsiReferenceBase getIdReferenceBase(XmlAttributeValue xmlAttributeValue, String referencesId, Map<String, XmlAttributeValue> fileIds, Map<String, TypeMatch> typeMatches, PsiClass controllerClass) {
        PsiField controllerField;
        if (controllerClass != null && !"controller".equals(referencesId) && (controllerField = controllerClass.findFieldByName(referencesId, false)) != null) {
            return new JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef(xmlAttributeValue, (PsiMember)controllerField, controllerClass);
        }
        return new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, typeMatches, referencesId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 9, 10, 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttributeValue";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIds";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionReferences";
                break;
            }
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSinglePropertyReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionReferences";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSinglePropertyReferences";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMatches";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "adjustTextRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 9, 10, 14, 18 -> new IllegalStateException(string);
        };
    }

    public static class JavaFxIdReferenceBase
    extends PsiReferenceBase<XmlAttributeValue> {
        private final Map<String, XmlAttributeValue> myFileIds;
        private final Set<String> myAcceptableIds;
        private final Map<String, TypeMatch> myTypeMatches;
        private final String myReferencesId;

        private JavaFxIdReferenceBase(XmlAttributeValue element, Map<String, XmlAttributeValue> fileIds, Set<String> acceptableIds, String referencesId) {
            super((PsiElement)element);
            this.myFileIds = fileIds;
            this.myAcceptableIds = acceptableIds;
            this.myReferencesId = referencesId;
            this.myTypeMatches = Collections.emptyMap();
        }

        public JavaFxIdReferenceBase(XmlAttributeValue xmlAttributeValue, Map<String, XmlAttributeValue> fileIds, Map<String, TypeMatch> typeMatches, String referencesId) {
            super((PsiElement)xmlAttributeValue);
            this.myFileIds = fileIds;
            this.myTypeMatches = typeMatches;
            this.myReferencesId = referencesId;
            this.myAcceptableIds = this.myFileIds.keySet();
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)this.myFileIds.get(this.myReferencesId);
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = this.myAcceptableIds.stream().map(id -> PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)id), (double)TypeMatch.getPriority(this.myTypeMatches.get(id)))).toArray(LookupElement[]::new);
            if (objectArray == null) {
                JavaFxIdReferenceBase.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public boolean isBuiltIn() {
            return "controller".equals(this.myReferencesId) || this.myReferencesId.endsWith("Controller");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxIdReferenceBase", "getVariants"));
        }
    }

    private static class JavaFxExpressionReferenceBase
    extends JavaFxPropertyReference<XmlAttributeValue> {
        private final String myFieldName;

        JavaFxExpressionReferenceBase(@NotNull XmlAttributeValue xmlAttributeValue, PsiClass tagClass, @NotNull String fieldName) {
            if (xmlAttributeValue == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(1);
            }
            super(xmlAttributeValue, tagClass);
            this.myFieldName = fieldName;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)JavaFxPsiUtil.getReadableProperties(this.myPsiClass).get(this.myFieldName);
        }

        public Object @NotNull [] getVariants() {
            XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)this.getElement();
            PsiElement declaration = JavaFxPsiUtil.getAttributeDeclaration(xmlAttributeValue);
            PsiType propertyType = JavaFxPsiUtil.getWritablePropertyType(this.myPsiClass, declaration);
            if (propertyType != null) {
                Object[] objectArray = this.collectProperties(propertyType, xmlAttributeValue.getProject());
                if (objectArray == null) {
                    JavaFxExpressionReferenceBase.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        private Object[] collectProperties(@NotNull PsiType propertyType, @NotNull Project project) {
            if (propertyType == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(4);
            }
            if (project == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(5);
            }
            PsiType resolvedType = JavaFxPsiUtil.getWritablePropertyType(propertyType, project);
            ArrayList<LookupElementBuilder> objs = new ArrayList<LookupElementBuilder>();
            Collection<PsiMember> readableProperties = JavaFxPsiUtil.getReadableProperties(this.myPsiClass).values();
            for (PsiMember readableMember : readableProperties) {
                String propertyName;
                PsiType readableType = JavaFxPsiUtil.getReadablePropertyType((PsiElement)readableMember);
                if (readableType == null || !TypeConversionUtil.isAssignable((PsiType)propertyType, (PsiType)readableType) && (resolvedType == null || !TypeConversionUtil.isAssignable((PsiType)resolvedType, (PsiType)readableType)) || (propertyName = PropertyUtilBase.getPropertyName((PsiMember)readableMember)) == null) continue;
                objs.add(LookupElementBuilder.create((Object)readableMember, (String)propertyName));
            }
            return ArrayUtil.toObjectArray(objs);
        }

        @Override
        @NotNull
        public String getPropertyName() {
            String string = this.myFieldName;
            if (string == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(6);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                JavaFxExpressionReferenceBase.$$$reportNull$$$0(7);
            }
            String newPropertyName = JavaFxPsiUtil.getPropertyName(newElementName, this.resolve() instanceof PsiMethod);
            return super.handleElementRename(newPropertyName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlAttributeValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectProperties";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static enum TypeMatch {
        ASSIGNABLE(3.0),
        CONVERTIBLE(2.0),
        UNDEFINED(1.0),
        INCOMPATIBLE(0.0);

        private final double myPriority;

        private TypeMatch(double priority) {
            this.myPriority = priority;
        }

        public static double getPriority(TypeMatch match) {
            return match != null ? match.myPriority : 0.0;
        }

        @NotNull
        public static TypeMatch getMatch(PsiClass valueClass, PsiClass targetPropertyClass, boolean isConvertible) {
            if (valueClass == null || targetPropertyClass == null) {
                TypeMatch typeMatch = UNDEFINED;
                if (typeMatch == null) {
                    TypeMatch.$$$reportNull$$$0(0);
                }
                return typeMatch;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)valueClass, (PsiClass)targetPropertyClass, (boolean)true)) {
                TypeMatch typeMatch = ASSIGNABLE;
                if (typeMatch == null) {
                    TypeMatch.$$$reportNull$$$0(1);
                }
                return typeMatch;
            }
            if (isConvertible) {
                TypeMatch typeMatch = CONVERTIBLE;
                if (typeMatch == null) {
                    TypeMatch.$$$reportNull$$$0(2);
                }
                return typeMatch;
            }
            TypeMatch typeMatch = INCOMPATIBLE;
            if (typeMatch == null) {
                TypeMatch.$$$reportNull$$$0(3);
            }
            return typeMatch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$TypeMatch", "getMatch"));
        }
    }
}

