/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.optional.imageio.BasicShape;
import org.apache.tools.ant.types.optional.imageio.ColorMapper;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;

public class Arc
extends BasicShape
implements DrawOperation {
    private int start = 0;
    private int stop = 0;
    private ArcType type = ArcType.getDefault();

    public void setStart(int start) {
        this.start = start;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public void setType(ArcType arcType) {
        this.type = arcType;
    }

    @Override
    public BufferedImage executeDrawOperation() {
        BufferedImage bi = new BufferedImage(this.width + this.strokeWidth * 2, this.height + this.strokeWidth * 2, 7);
        Graphics2D graphics = bi.createGraphics();
        if (!"transparent".equalsIgnoreCase(this.stroke)) {
            BasicStroke bStroke = new BasicStroke(this.strokeWidth);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            graphics.draw(new Arc2D.Double(this.strokeWidth, this.strokeWidth, this.width, this.height, this.start, this.stop, this.type.getIndex()));
        }
        if (!"transparent".equalsIgnoreCase(this.fill)) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            graphics.fill(new Arc2D.Double(this.strokeWidth, this.strokeWidth, this.width, this.height, this.start, this.stop, this.type.getIndex()));
        }
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                BufferedImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img, null, 0, 0);
                continue;
            }
            if (!(instr instanceof TransformOperation)) continue;
            bi = ((TransformOperation)instr).executeTransformOperation(bi);
            graphics = bi.createGraphics();
        }
        return bi;
    }

    public static class ArcType
    extends EnumeratedAttribute {
        private static final List<String> VALUES = new ArrayList<String>();

        public ArcType() {
        }

        public ArcType(String value) {
            this.setValue(value);
        }

        public static ArcType getDefault() {
            return new ArcType(VALUES.get(0));
        }

        @Override
        public String[] getValues() {
            return VALUES.toArray(new String[0]);
        }

        static {
            VALUES.add(0, "open");
            VALUES.add(1, "chord");
            VALUES.add(2, "pie");
        }
    }
}

