/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.FinalizableValue;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public interface ConfigurationInternal
extends ResolveContext,
DeprecatableConfiguration,
FinalizableValue,
Configuration {
    @Override
    public AttributeContainerInternal getAttributes();

    public void runDependencyActions();

    public void markAsObserved(InternalState var1);

    public void addMutationValidator(MutationValidator var1);

    public void removeMutationValidator(MutationValidator var1);

    public void collectVariants(VariantVisitor var1);

    public void beforeLocking(Action<? super ConfigurationInternal> var1);

    public boolean isCanBeMutated();

    public List<? extends GradleException> preventFromFurtherMutationLenient();

    public Set<ExcludeRule> getAllExcludeRules();

    @Nullable
    public ConfigurationInternal getConsistentResolutionSource();

    public ResolveException maybeAddContext(ResolveException var1);

    default public boolean isDeclarableByExtension() {
        return ConfigurationInternal.isDeclarableByExtension(this);
    }

    public ConfigurationRole getRoleAtCreation();

    public static boolean isDeclarableByExtension(ConfigurationInternal configuration) {
        if (configuration.isCanBeDeclared()) {
            return true;
        }
        return configuration.getExtendsFrom().stream().map(ConfigurationInternal.class::cast).anyMatch(ci -> ci.isDeclarableByExtension());
    }

    public static interface VariantVisitor {
        public void visitArtifacts(Collection<? extends PublishArtifact> var1);

        public void visitOwnVariant(DisplayName var1, ImmutableAttributes var2, Collection<? extends Capability> var3, Collection<? extends PublishArtifact> var4);

        public void visitChildVariant(String var1, DisplayName var2, ImmutableAttributes var3, Collection<? extends Capability> var4, Collection<? extends PublishArtifact> var5);
    }

    public static enum InternalState {
        UNRESOLVED,
        BUILD_DEPENDENCIES_RESOLVED,
        GRAPH_RESOLVED,
        ARTIFACTS_RESOLVED;

    }
}

