/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyAdder;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;

public class DefaultDependencyAdder
implements DependencyAdder {
    private final DependencyFactoryInternal dependencyFactory;
    private final Configuration configuration;

    @Inject
    public DefaultDependencyAdder(DependencyFactoryInternal dependencyFactory, Configuration configuration) {
        this.dependencyFactory = dependencyFactory;
        this.configuration = configuration;
    }

    private <D extends Dependency> D finalizeDependency(D dependency) {
        return (D)this.dependencyFactory.createDependency(dependency);
    }

    private <D extends Dependency> void doAddEager(D dependency, @Nullable Action<? super D> config) {
        dependency = this.finalizeDependency(dependency);
        if (config != null) {
            config.execute(dependency);
        }
        this.configuration.getDependencies().add(dependency);
    }

    private <D extends Dependency> void doAddLazy(Provider<D> dependency, @Nullable Action<? super D> config) {
        Provider<Dependency> provider = dependency.map(dep -> {
            if (!(dep instanceof Dependency)) {
                throw new InvalidUserCodeException("Providers of non-Dependency types (" + dep.getClass().getName() + ") are not supported. Create a Dependency using DependencyFactory first.");
            }
            return this.finalizeDependency((Dependency)dep);
        });
        if (config != null) {
            provider = provider.map(d -> {
                config.execute((Object)d);
                return d;
            });
        }
        this.configuration.getDependencies().addLater(provider);
    }

    private <D extends Dependency> List<Dependency> createDependencyList(Iterable<? extends D> bundle, @Nullable Action<? super D> config) {
        ArrayList<Dependency> newList = new ArrayList<Dependency>(bundle instanceof Collection ? ((Collection)bundle).size() : 0);
        for (Dependency dep : bundle) {
            Dependency converted = this.finalizeDependency(dep);
            if (config != null) {
                config.execute(converted);
            }
            newList.add(converted);
        }
        return newList;
    }

    private <D extends Dependency> void doAddBundleEager(Iterable<? extends D> bundle, @Nullable Action<? super D> config) {
        List<Dependency> dependencies = this.createDependencyList(bundle, config);
        this.configuration.getDependencies().addAll(dependencies);
    }

    private <D extends Dependency> void doAddBundleLazy(Provider<? extends Iterable<? extends D>> dependency, @Nullable Action<? super D> config) {
        Provider<List> provider = dependency.map(bundle -> this.createDependencyList((Iterable)bundle, config));
        this.configuration.getDependencies().addAllLater(provider);
    }

    @Override
    public void add(CharSequence dependencyNotation) {
        this.doAddEager(this.dependencyFactory.create(dependencyNotation), null);
    }

    @Override
    public void add(CharSequence dependencyNotation, Action<? super ExternalModuleDependency> configuration) {
        this.doAddEager(this.dependencyFactory.create(dependencyNotation), configuration);
    }

    @Override
    public void add(FileCollection files) {
        this.doAddEager(this.dependencyFactory.create(files), null);
    }

    @Override
    public void add(FileCollection files, Action<? super FileCollectionDependency> configuration) {
        this.doAddEager(this.dependencyFactory.create(files), configuration);
    }

    @Override
    public void add(ProviderConvertible<? extends MinimalExternalModuleDependency> externalModule) {
        this.doAddLazy(externalModule.asProvider(), null);
    }

    @Override
    public void add(ProviderConvertible<? extends MinimalExternalModuleDependency> externalModule, Action<? super ExternalModuleDependency> configuration) {
        this.doAddLazy(externalModule.asProvider(), configuration);
    }

    @Override
    public void add(Dependency dependency) {
        this.doAddEager(dependency, null);
    }

    @Override
    public <D extends Dependency> void add(D dependency, Action<? super D> configuration) {
        this.doAddEager(dependency, configuration);
    }

    @Override
    public void add(Provider<? extends Dependency> dependency) {
        this.doAddLazy(dependency, null);
    }

    @Override
    public <D extends Dependency> void add(Provider<? extends D> dependency, Action<? super D> configuration) {
        this.doAddLazy(dependency, configuration);
    }

    @Override
    public <D extends Dependency> void bundle(Iterable<? extends D> bundle) {
        this.doAddBundleEager(bundle, null);
    }

    @Override
    public <D extends Dependency> void bundle(Iterable<? extends D> bundle, Action<? super D> configuration) {
        this.doAddBundleEager(bundle, configuration);
    }

    @Override
    public <D extends Dependency> void bundle(Provider<? extends Iterable<? extends D>> bundle) {
        this.doAddBundleLazy(bundle, null);
    }

    @Override
    public <D extends Dependency> void bundle(Provider<? extends Iterable<? extends D>> bundle, Action<? super D> configuration) {
        this.doAddBundleLazy(bundle, configuration);
    }

    @Override
    public <D extends Dependency> void bundle(ProviderConvertible<? extends Iterable<? extends D>> bundle) {
        this.doAddBundleLazy(bundle.asProvider(), null);
    }

    @Override
    public <D extends Dependency> void bundle(ProviderConvertible<? extends Iterable<? extends D>> bundle, Action<? super D> configuration) {
        this.doAddBundleLazy(bundle.asProvider(), configuration);
    }

    public String toString() {
        return DependencyAdder.class.getSimpleName() + " for " + this.configuration.getName();
    }
}

