/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.artifacts.transform.TransformationDependency;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.api.internal.tasks.WorkDependencyResolver;
import org.gradle.api.internal.tasks.WorkNodeAction;

@NonNullApi
public abstract class AbstractTaskDependency
implements TaskDependencyContainerInternal {
    @Nullable
    private final TaskDependencyUsageTracker dependencyUsageTracker;
    private static final WorkDependencyResolver<Task> IGNORE_ARTIFACT_TRANSFORM_RESOLVER = new WorkDependencyResolver<Task>(){

        @Override
        public boolean resolve(Task task, Object node, Action<? super Task> resolveAction) {
            return node instanceof TransformationDependency || node instanceof WorkNodeAction;
        }
    };
    private Supplier<String> toStringProvider = null;

    public AbstractTaskDependency(@Nullable TaskDependencyUsageTracker dependencyUsageTracker) {
        this.dependencyUsageTracker = dependencyUsageTracker;
    }

    public void setToStringProvider(Supplier<String> toStringProvider) {
        this.toStringProvider = toStringProvider;
    }

    public String toString() {
        return this.toStringProvider != null ? this.toStringProvider.get() : super.toString();
    }

    @Override
    public Set<? extends Task> getDependencies(@Nullable Task task) {
        Set<? extends Task> result2 = this.getDependenciesForInternalUse(task);
        if (this.dependencyUsageTracker != null) {
            this.dependencyUsageTracker.onTaskDependencyUsage(result2);
        }
        return result2;
    }

    @Override
    public Set<? extends Task> getDependenciesForInternalUse(@Nullable Task task) {
        CachingTaskDependencyResolveContext context = new CachingTaskDependencyResolveContext(Arrays.asList(WorkDependencyResolver.TASK_AS_TASK, IGNORE_ARTIFACT_TRANSFORM_RESOLVER));
        return context.getDependencies(task, this);
    }
}

