/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.logging.DefaultTestLogging;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.api.tasks.testing.logging.TestStackTraceFilter;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;

public class DefaultTestLoggingContainer
implements TestLoggingContainer {
    private final Map<LogLevel, TestLogging> perLevelTestLogging = Maps.newEnumMap(LogLevel.class);

    public DefaultTestLoggingContainer(Instantiator instantiator2) {
        for (LogLevel level : LogLevel.values()) {
            this.perLevelTestLogging.put(level, instantiator2.newInstance(DefaultTestLogging.class, new Object[0]));
        }
        this.setEvents((Set<TestLogEvent>)EnumSet.of(TestLogEvent.FAILED));
        this.setExceptionFormat(TestExceptionFormat.SHORT);
        this.getInfo().setEvents((Set<TestLogEvent>)EnumSet.of(TestLogEvent.FAILED, TestLogEvent.SKIPPED, TestLogEvent.STANDARD_OUT, TestLogEvent.STANDARD_ERROR));
        this.getInfo().setStackTraceFilters((Set<TestStackTraceFilter>)EnumSet.of(TestStackTraceFilter.TRUNCATE));
        this.getDebug().setEvents((Set<TestLogEvent>)EnumSet.allOf(TestLogEvent.class));
        this.getDebug().setMinGranularity(0);
        this.getDebug().setStackTraceFilters((Set<TestStackTraceFilter>)EnumSet.noneOf(TestStackTraceFilter.class));
    }

    @Override
    public TestLogging getDebug() {
        return this.perLevelTestLogging.get((Object)LogLevel.DEBUG);
    }

    @Override
    public void setDebug(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.DEBUG, logging);
    }

    @Override
    public void debug(Action<TestLogging> action) {
        action.execute(this.getDebug());
    }

    @Override
    public TestLogging getInfo() {
        return this.perLevelTestLogging.get((Object)LogLevel.INFO);
    }

    @Override
    public void setInfo(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.INFO, logging);
    }

    @Override
    public void info(Action<TestLogging> action) {
        action.execute(this.getInfo());
    }

    @Override
    public TestLogging getLifecycle() {
        return this.perLevelTestLogging.get((Object)LogLevel.LIFECYCLE);
    }

    @Override
    public void setLifecycle(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.LIFECYCLE, logging);
    }

    @Override
    public void lifecycle(Action<TestLogging> action) {
        action.execute(this.getLifecycle());
    }

    @Override
    public TestLogging getWarn() {
        return this.perLevelTestLogging.get((Object)LogLevel.WARN);
    }

    @Override
    public void setWarn(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.WARN, logging);
    }

    @Override
    public void warn(Action<TestLogging> action) {
        action.execute(this.getWarn());
    }

    @Override
    public TestLogging getQuiet() {
        return this.perLevelTestLogging.get((Object)LogLevel.QUIET);
    }

    @Override
    public void setQuiet(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.QUIET, logging);
    }

    @Override
    public void quiet(Action<TestLogging> action) {
        action.execute(this.getQuiet());
    }

    @Override
    public TestLogging getError() {
        return this.perLevelTestLogging.get((Object)LogLevel.ERROR);
    }

    @Override
    public void setError(TestLogging logging) {
        this.perLevelTestLogging.put(LogLevel.ERROR, logging);
    }

    @Override
    public void error(Action<TestLogging> action) {
        action.execute(this.getError());
    }

    @Override
    public Set<TestLogEvent> getEvents() {
        return this.getDefaultTestLogging().getEvents();
    }

    @Override
    public void setEvents(Set<TestLogEvent> events) {
        this.getDefaultTestLogging().setEvents(events);
    }

    @Override
    public void setEvents(Iterable<?> events) {
        this.getDefaultTestLogging().setEvents(events);
    }

    @Override
    public void events(Object ... events) {
        this.getDefaultTestLogging().events(events);
    }

    @Override
    public int getMinGranularity() {
        return this.getDefaultTestLogging().getMinGranularity();
    }

    @Override
    public void setMinGranularity(int granularity) {
        this.getDefaultTestLogging().setMinGranularity(granularity);
    }

    @Override
    public int getMaxGranularity() {
        return this.getDefaultTestLogging().getMaxGranularity();
    }

    @Override
    public void setMaxGranularity(int granularity) {
        this.getDefaultTestLogging().setMaxGranularity(granularity);
    }

    @Override
    public int getDisplayGranularity() {
        return this.getDefaultTestLogging().getDisplayGranularity();
    }

    @Override
    public void setDisplayGranularity(int granularity) {
        this.getDefaultTestLogging().setDisplayGranularity(granularity);
    }

    @Override
    public boolean getShowExceptions() {
        return this.getDefaultTestLogging().getShowExceptions();
    }

    @Override
    public void setShowExceptions(boolean flag) {
        this.getDefaultTestLogging().setShowExceptions(flag);
    }

    @Override
    public boolean getShowCauses() {
        return this.getDefaultTestLogging().getShowCauses();
    }

    @Override
    public void setShowCauses(boolean flag) {
        this.getDefaultTestLogging().setShowCauses(flag);
    }

    @Override
    public boolean getShowStackTraces() {
        return this.getDefaultTestLogging().getShowStackTraces();
    }

    @Override
    public void setShowStackTraces(boolean flag) {
        this.getDefaultTestLogging().setShowStackTraces(flag);
    }

    @Override
    public TestExceptionFormat getExceptionFormat() {
        return this.getDefaultTestLogging().getExceptionFormat();
    }

    @Override
    public void setExceptionFormat(TestExceptionFormat exceptionFormat) {
        this.setExceptionFormat((Object)exceptionFormat);
    }

    @Override
    public void setExceptionFormat(Object exceptionFormat) {
        this.getDefaultTestLogging().setExceptionFormat(exceptionFormat);
    }

    @Override
    public Set<TestStackTraceFilter> getStackTraceFilters() {
        return this.getDefaultTestLogging().getStackTraceFilters();
    }

    @Override
    public void setStackTraceFilters(Set<TestStackTraceFilter> stackTraces) {
        this.getDefaultTestLogging().setStackTraceFilters(stackTraces);
    }

    @Override
    public void setStackTraceFilters(Iterable<?> stackTraces) {
        this.getDefaultTestLogging().setStackTraceFilters(stackTraces);
    }

    @Override
    public void stackTraceFilters(Object ... stackTraces) {
        this.getDefaultTestLogging().stackTraceFilters(stackTraces);
    }

    @Override
    public boolean getShowStandardStreams() {
        return this.getDefaultTestLogging().getShowStandardStreams();
    }

    @Override
    public TestLoggingContainer setShowStandardStreams(boolean flag) {
        this.getDefaultTestLogging().setShowStandardStreams(flag);
        return this;
    }

    @Override
    public TestLogging get(LogLevel level) {
        return this.perLevelTestLogging.get((Object)level);
    }

    private TestLogging getDefaultTestLogging() {
        return this.getLifecycle();
    }
}

