/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Pattern;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkOperationBackOffAndRetry;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Metadata;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.xml.XmlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMavenPublisher
implements MavenPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenPublisher.class);
    private static final String POM_FILE_ENCODING = "UTF-8";
    private static final String SNAPSHOT_VERSION = "SNAPSHOT";
    private static final Pattern VERSION_FILE_PATTERN = Pattern.compile("^(.*)-([0-9]{8}.[0-9]{6})-([0-9]+)$");
    private final Factory<File> temporaryDirFactory;
    private final XmlTransformer xmlTransformer = new XmlTransformer();

    AbstractMavenPublisher(Factory<File> temporaryDirFactory) {
        this.temporaryDirFactory = temporaryDirFactory;
    }

    protected void publish(MavenNormalizedPublication publication, ExternalResourceRepository repository, URI rootUri, boolean localRepo) {
        String groupId = publication.getGroupId();
        String artifactId = publication.getArtifactId();
        String version = publication.getVersion();
        ModuleArtifactPublisher artifactPublisher = new ModuleArtifactPublisher(repository, localRepo, rootUri, groupId, artifactId, version);
        if (this.isSnapshot(version)) {
            ExternalResourceName snapshotMetadataPath = artifactPublisher.getSnapshotMetadataLocation();
            Metadata snapshotMetadata = this.createSnapshotMetadata(publication, groupId, artifactId, version, repository, snapshotMetadataPath);
            artifactPublisher.publish(snapshotMetadataPath, this.writeMetadataToTmpFile(snapshotMetadata, "snapshot-maven-metadata.xml"));
            if (!localRepo) {
                artifactPublisher.artifactVersion = ((SnapshotVersion)snapshotMetadata.getVersioning().getSnapshotVersions().get(0)).getVersion();
            }
        }
        if (publication.getMainArtifact() != null) {
            artifactPublisher.publish(null, publication.getMainArtifact().getExtension(), publication.getMainArtifact().getFile());
        }
        artifactPublisher.publish(null, "pom", publication.getPomArtifact().getFile());
        for (MavenArtifact artifact : publication.getAdditionalArtifacts()) {
            artifactPublisher.publish(artifact.getClassifier(), artifact.getExtension(), artifact.getFile());
        }
        ExternalResourceName externalResource = artifactPublisher.getMetadataLocation();
        Metadata metadata = this.createMetadata(groupId, artifactId, version, repository, externalResource);
        artifactPublisher.publish(externalResource, this.writeMetadataToTmpFile(metadata, "module-maven-metadata.xml"));
    }

    private Metadata createMetadata(String groupId, String artifactId, String version, ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        Versioning versioning = this.getExistingVersioning(repository, metadataResource);
        if (!versioning.getVersions().contains(version)) {
            versioning.addVersion(version);
        }
        versioning.setLatest(version);
        if (!this.isSnapshot(version)) {
            versioning.setRelease(version);
        }
        versioning.updateTimestamp();
        Metadata metadata = new Metadata();
        metadata.setGroupId(groupId);
        metadata.setArtifactId(artifactId);
        metadata.setVersioning(versioning);
        return metadata;
    }

    private Versioning getExistingVersioning(ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        Metadata recessive;
        ExternalResourceReadResult<Metadata> existing = this.readExistingMetadata(repository, metadataResource);
        if (existing != null && (recessive = existing.getResult()).getVersioning() != null) {
            return recessive.getVersioning();
        }
        return new Versioning();
    }

    private File writeMetadataToTmpFile(Metadata metadata, String fileName) {
        File metadataFile = new File(this.temporaryDirFactory.create(), fileName);
        this.xmlTransformer.transform(metadataFile, POM_FILE_ENCODING, writer2 -> {
            try {
                new MetadataXpp3Writer().write(writer2, metadata);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return metadataFile;
    }

    private boolean isSnapshot(String version) {
        if (version != null) {
            if (version.regionMatches(true, version.length() - SNAPSHOT_VERSION.length(), SNAPSHOT_VERSION, 0, SNAPSHOT_VERSION.length())) {
                return true;
            }
            return VERSION_FILE_PATTERN.matcher(version).matches();
        }
        return false;
    }

    ExternalResourceReadResult<Metadata> readExistingMetadata(ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        return repository.resource(metadataResource).withContentIfPresent(inputStream -> {
            try {
                return new MetadataXpp3Reader().read(inputStream, false);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        });
    }

    protected abstract Metadata createSnapshotMetadata(MavenNormalizedPublication var1, String var2, String var3, String var4, ExternalResourceRepository var5, ExternalResourceName var6);

    private static class ModuleArtifactPublisher {
        private final NetworkOperationBackOffAndRetry networkOperationRunner = new NetworkOperationBackOffAndRetry();
        private final ExternalResourceRepository repository;
        private final boolean localRepo;
        private final URI rootUri;
        private final String groupPath;
        private final String artifactId;
        private final String moduleVersion;
        private String artifactVersion;

        ModuleArtifactPublisher(ExternalResourceRepository repository, boolean localRepo, URI rootUri, String groupId, String artifactId, String moduleVersion) {
            this.repository = repository.withProgressLogging();
            this.localRepo = localRepo;
            this.rootUri = rootUri;
            this.groupPath = groupId.replace('.', '/');
            this.artifactId = artifactId;
            this.moduleVersion = moduleVersion;
            this.artifactVersion = moduleVersion;
        }

        ExternalResourceName getMetadataLocation() {
            String path = this.groupPath + '/' + this.artifactId + '/' + this.getMetadataFileName();
            return new ExternalResourceName(this.rootUri, path);
        }

        ExternalResourceName getSnapshotMetadataLocation() {
            String path = this.groupPath + '/' + this.artifactId + '/' + this.moduleVersion + '/' + this.getMetadataFileName();
            return new ExternalResourceName(this.rootUri, path);
        }

        private String getMetadataFileName() {
            if (this.localRepo) {
                return "maven-metadata-local.xml";
            }
            return "maven-metadata.xml";
        }

        void publish(String classifier, String extension, File content) {
            StringBuilder path = new StringBuilder(128);
            path.append(this.groupPath).append('/');
            path.append(this.artifactId).append('/');
            path.append(this.moduleVersion).append('/');
            path.append(this.artifactId).append('-').append(this.artifactVersion);
            if (classifier != null) {
                path.append('-').append(classifier);
            }
            if (extension.length() > 0) {
                path.append('.').append(extension);
            }
            ExternalResourceName externalResource = new ExternalResourceName(this.rootUri, path.toString());
            this.publish(externalResource, content);
        }

        void publish(ExternalResourceName externalResource, File content) {
            if (!this.localRepo) {
                LOGGER.info("Uploading {} to {}", (Object)externalResource.getShortDisplayName(), (Object)externalResource.getPath());
            }
            this.putResource(externalResource, new FileReadableContent(content));
            if (!this.localRepo) {
                this.publishChecksums(externalResource, content);
            }
        }

        private void publishChecksums(ExternalResourceName destination, File content) {
            this.publishChecksum(destination, content, Hashing.sha1());
            this.publishChecksum(destination, content, Hashing.md5());
            if (!ExternalResourceResolver.disableExtraChecksums()) {
                this.publishPossiblyUnsupportedChecksum(destination, content, Hashing.sha256());
                this.publishPossiblyUnsupportedChecksum(destination, content, Hashing.sha512());
            }
        }

        private void publishPossiblyUnsupportedChecksum(ExternalResourceName destination, File content, HashFunction hashFunction) {
            try {
                this.publishChecksum(destination, content, hashFunction);
            }
            catch (Exception ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + hashFunction + ". This will not fail the build.", (Throwable)ex);
                }
                LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + hashFunction + ". This will not fail the build.");
            }
        }

        private void publishChecksum(ExternalResourceName destination, File content, HashFunction hashFunction) {
            byte[] checksum = this.createChecksumFile(content, hashFunction);
            this.putResource(destination.append("." + hashFunction.getAlgorithm().toLowerCase(Locale.ROOT).replaceAll("-", "")), new ByteArrayReadableContent(checksum));
        }

        private byte[] createChecksumFile(File src, HashFunction hashFunction) {
            HashCode hash;
            try {
                hash = hashFunction.hashFile(src);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String formattedHashString = hash.toZeroPaddedString(hashFunction.getHexDigits());
            return formattedHashString.getBytes(StandardCharsets.US_ASCII);
        }

        private void putResource(final ExternalResourceName externalResource, final ReadableContent readableContent) {
            this.networkOperationRunner.withBackoffAndRetry(new Runnable(){

                @Override
                public void run() {
                    repository.resource(externalResource).put(readableContent);
                }

                public String toString() {
                    return "PUT " + externalResource.getDisplayName();
                }
            });
        }
    }
}

