/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.ReportSpec;

public abstract class ReportingExtension {
    public static final String NAME = "reporting";
    public static final String DEFAULT_REPORTS_DIR_NAME = "reports";
    private final ProjectInternal project;
    private final DirectoryProperty baseDirectory;
    private final ExtensiblePolymorphicDomainObjectContainer<ReportSpec> reports;

    @Inject
    public ReportingExtension(Project project) {
        this.project = (ProjectInternal)project;
        this.baseDirectory = project.getObjects().directoryProperty();
        this.reports = project.getObjects().polymorphicDomainObjectContainer(ReportSpec.class);
        this.baseDirectory.set(project.getLayout().getBuildDirectory().dir(DEFAULT_REPORTS_DIR_NAME));
    }

    public File getBaseDir() {
        return this.baseDirectory.getAsFile().get();
    }

    public void setBaseDir(File baseDir) {
        this.baseDirectory.set(baseDir);
    }

    public void setBaseDir(final Object baseDir) {
        this.baseDirectory.set(this.project.provider(new Callable<Directory>(){

            @Override
            public Directory call() throws Exception {
                DirectoryProperty result2 = ReportingExtension.this.project.getObjects().directoryProperty();
                result2.set(ReportingExtension.this.project.file(baseDir));
                return (Directory)result2.get();
            }
        }));
    }

    public DirectoryProperty getBaseDirectory() {
        return this.baseDirectory;
    }

    public File file(String path) {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.getBaseDir()).resolve(path);
    }

    public String getApiDocTitle() {
        Object version = this.project.getVersion();
        if ("unspecified".equals(version)) {
            return this.project.getName() + " API";
        }
        return this.project.getName() + " " + version + " API";
    }

    @Incubating
    public ExtensiblePolymorphicDomainObjectContainer<ReportSpec> getReports() {
        return this.reports;
    }
}

