/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.InvertedRenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;

public class UnresolvedDependencyEdge
implements DependencyEdge {
    private final UnresolvedDependencyResult dependency;
    private final ComponentIdentifier actual;

    public UnresolvedDependencyEdge(UnresolvedDependencyResult dependency) {
        this.dependency = dependency;
        if (dependency.getAttempted() instanceof ModuleComponentSelector) {
            ModuleComponentSelector attempted = (ModuleComponentSelector)dependency.getAttempted();
            this.actual = DefaultModuleComponentIdentifier.newId(attempted.getModuleIdentifier(), attempted.getVersion());
        } else if (dependency.getAttempted() instanceof DefaultProjectComponentSelector) {
            DefaultProjectComponentSelector attempted = (DefaultProjectComponentSelector)dependency.getAttempted();
            this.actual = new DefaultProjectComponentIdentifier(attempted.getBuildIdentifier(), attempted.getIdentityPath(), attempted.projectPath(), attempted.getProjectName());
        } else {
            this.actual = () -> dependency.getAttempted().getDisplayName();
        }
    }

    public Throwable getFailure() {
        return this.dependency.getFailure();
    }

    @Override
    public boolean isResolvable() {
        return false;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependency.getRequested();
    }

    @Override
    public ComponentIdentifier getActual() {
        return this.actual;
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.dependency.getAttemptedReason();
    }

    @Override
    public List<ResolvedVariantResult> getSelectedVariants() {
        return Collections.emptyList();
    }

    @Override
    public List<ResolvedVariantResult> getAllVariants() {
        return Collections.emptyList();
    }

    @Override
    public ComponentIdentifier getFrom() {
        return this.dependency.getFrom().getId();
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return Collections.singleton(new InvertedRenderableModuleResult(this.dependency.getFrom()));
    }
}

