/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.UncheckedIOException;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class GitIgnoreGenerator
implements BuildContentGenerator {
    @Override
    public void generate(InitSettings settings) {
        File file = settings.getTarget().file(".gitignore").getAsFile();
        Set<String> gitignoresToAppend = GitIgnoreGenerator.getGitignoresToAppend(file);
        if (!gitignoresToAppend.isEmpty()) {
            boolean shouldAppendNewLine = file.exists();
            try (PrintWriter writer2 = new PrintWriter(new FileWriter(file, true));){
                Spliterator<String> it;
                if (shouldAppendNewLine) {
                    writer2.println();
                }
                if ((it = gitignoresToAppend.spliterator()).tryAdvance(e -> GitIgnoreGenerator.withComment(e).forEach(writer2::println))) {
                    StreamSupport.stream(it, false).forEach(e -> GitIgnoreGenerator.withSeparator(GitIgnoreGenerator.withComment(e)).forEach(writer2::println));
                }
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    private static Set<String> getGitignoresToAppend(File gitignoreFile) {
        LinkedHashSet result2 = Sets.newLinkedHashSet(Arrays.asList(".gradle", "build"));
        if (gitignoreFile.exists()) {
            try (BufferedReader reader2 = new BufferedReader(new FileReader(gitignoreFile));){
                result2.removeAll(reader2.lines().filter(it -> result2.contains(it)).collect(Collectors.toSet()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return result2;
    }

    private static List<String> withComment(String entry) {
        ArrayList result2 = Lists.newArrayList();
        if (entry.startsWith(".gradle")) {
            result2.add("# Ignore Gradle project-specific cache directory");
        } else if (entry.startsWith("build")) {
            result2.add("# Ignore Gradle build output directory");
        }
        result2.add(entry);
        return result2;
    }

    private static List<String> withSeparator(List<String> entry) {
        ArrayList result2 = Lists.newArrayList((Object[])new String[]{""});
        result2.addAll(entry);
        return result2;
    }
}

