/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.initialization.properties.MutableGradleProperties;

public class DefaultGradleProperties
implements MutableGradleProperties {
    private final Map<String, Object> defaultProperties;
    private final Map<String, Object> overrideProperties;
    private final Map<String, Object> gradleProperties;

    public DefaultGradleProperties(Map<String, Object> defaultProperties, Map<String, Object> overrideProperties) {
        this.defaultProperties = defaultProperties;
        this.overrideProperties = overrideProperties;
        this.gradleProperties = this.mergePropertiesWith(Collections.emptyMap());
    }

    @Override
    @Nullable
    public Object find(String propertyName) {
        return this.gradleProperties.get(propertyName);
    }

    @Override
    public Map<String, Object> mergeProperties(Map<String, Object> properties) {
        return properties.isEmpty() ? this.gradleProperties : this.mergePropertiesWith(properties);
    }

    @Override
    public void updateOverrideProperties(Map<String, Object> properties) {
        this.overrideProperties.putAll(properties);
        this.gradleProperties.clear();
        this.gradleProperties.putAll(this.mergePropertiesWith(Collections.emptyMap()));
    }

    @Override
    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.gradleProperties);
    }

    private Map<String, Object> mergePropertiesWith(Map<String, Object> properties) {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        result2.putAll(this.defaultProperties);
        result2.putAll(properties);
        result2.putAll(this.overrideProperties);
        return result2;
    }
}

