/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model;

import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

@Incubating
public class ReadOnlyModelViewException
extends GradleException {
    public ReadOnlyModelViewException(String message2) {
        super(message2);
    }

    public ReadOnlyModelViewException(ModelPath path, ModelType<?> type, ModelRuleDescriptor ruleDescriptor) {
        super(ReadOnlyModelViewException.createMessage("read only", path, type, ruleDescriptor));
    }

    protected static String createMessage(String viewType, ModelPath path, ModelType<?> type, ModelRuleDescriptor ruleDescriptor) {
        StringBuilder result2 = new StringBuilder();
        result2.append("Attempt to modify a ").append(viewType).append(" view of model element '");
        result2.append(path);
        result2.append("'");
        if (!type.equals(ModelType.UNTYPED)) {
            result2.append(" of type '");
            result2.append(type.getDisplayName());
            result2.append("'");
        }
        result2.append(" given to rule ");
        ruleDescriptor.describeTo(result2);
        return result2.toString();
    }
}

