/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

@ThreadSafe
public class IncompatibleTypeReferenceReporter {
    private static final String INDENT = "  ";
    private final String creator;
    private final String path;
    private final String type;
    private final String description;
    private final boolean writable;
    private final Iterable<String> candidateTypes;

    public IncompatibleTypeReferenceReporter(String creator, String path, String type, String description, boolean writable, Iterable<String> candidateTypes) {
        this.creator = creator;
        this.path = path;
        this.type = type;
        this.description = description;
        this.writable = writable;
        this.candidateTypes = candidateTypes;
    }

    public static IncompatibleTypeReferenceReporter of(MutableModelNode node, ModelType<?> type, String description, boolean writable) {
        ModelPath path = node.getPath();
        ModelRuleDescriptor creatorDescriptor = node.getDescriptor();
        return new IncompatibleTypeReferenceReporter(creatorDescriptor.toString(), path.toString(), type.toString(), description, writable, node.getTypeDescriptions());
    }

    public String asString() {
        StringWriter string2 = new StringWriter();
        this.writeTo(new PrintWriter(string2));
        return string2.toString();
    }

    public void writeTo(PrintWriter writer2) {
        writer2.print("Model reference to element '");
        writer2.print(this.path);
        writer2.print("' with type ");
        writer2.print(this.type);
        if (this.description != null) {
            writer2.print(" (");
            writer2.print(this.description);
            writer2.print(")");
        }
        writer2.println(" is invalid due to incompatible types.");
        writer2.print("This element was created by ");
        writer2.print(this.creator);
        writer2.print(" and can be ");
        writer2.print(this.writable ? "mutated" : "read");
        writer2.println(" as the following types:");
        boolean first = true;
        for (String candidateType : this.candidateTypes) {
            if (!first) {
                writer2.println();
            }
            writer2.print(INDENT);
            writer2.print("- ");
            writer2.print(candidateType);
            first = false;
        }
    }
}

