/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.platform.base.Variant;
import org.gradle.platform.base.internal.VariantAspect;

public class VariantAspectExtractionStrategy
implements ModelSchemaAspectExtractionStrategy {
    @Override
    @Nullable
    public ModelSchemaAspectExtractionResult extract(ModelSchemaExtractionContext<?> extractionContext, List<ModelPropertyExtractionResult<?>> propertyResults) {
        ImmutableSet.Builder dimensionsBuilder = ImmutableSet.builder();
        for (ModelPropertyExtractionResult<?> propertyResult : propertyResults) {
            ModelProperty<?> property2 = propertyResult.getProperty();
            for (PropertyAccessorExtractionContext accessor : propertyResult.getAccessors()) {
                if (!accessor.isAnnotationPresent(Variant.class)) continue;
                if (accessor.getAccessorType() == PropertyAccessorType.SETTER) {
                    throw this.invalidProperty(extractionContext, property2, "@Variant annotation is only allowed on getter methods");
                }
                Class<?> propertyType = property2.getType().getRawClass();
                if (!String.class.equals(propertyType) && !Named.class.isAssignableFrom(propertyType)) {
                    throw this.invalidProperty(extractionContext, property2, String.format("@Variant annotation only allowed for properties of type String and %s, but property has type %s", Named.class.getName(), propertyType.getName()));
                }
                dimensionsBuilder.add(property2);
            }
        }
        ImmutableSet dimensions = dimensionsBuilder.build();
        if (dimensions.isEmpty()) {
            return null;
        }
        return new ModelSchemaAspectExtractionResult(new VariantAspect((Set<ModelProperty<?>>)dimensions));
    }

    protected InvalidManagedModelElementTypeException invalidProperty(ModelSchemaExtractionContext<?> extractionContext, ModelProperty<?> property2, String message2) {
        return new InvalidManagedModelElementTypeException(extractionContext, String.format("%s (invalid property: %s)", message2, property2.getName()));
    }
}

