/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.continuous;

import java.io.File;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkInputListener;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.tooling.internal.provider.continuous.BuildInputHierarchy;

public class AccumulateBuildInputsListener
implements WorkInputListener {
    private final BuildInputHierarchy buildInputHierarchy;

    public AccumulateBuildInputsListener(BuildInputHierarchy buildInputHierarchy) {
        this.buildInputHierarchy = buildInputHierarchy;
    }

    @Override
    public void onExecute(UnitOfWork work, final EnumSet<InputBehavior> relevantBehaviors) {
        final LinkedHashSet<String> taskInputs = new LinkedHashSet<String>();
        final LinkedHashSet filteredFileTreeTaskInputs = new LinkedHashSet();
        work.visitRegularInputs(new UnitOfWork.InputVisitor(){

            @Override
            public void visitInputFileProperty(String propertyName, InputBehavior behavior, UnitOfWork.InputFileValueSupplier value) {
                if (relevantBehaviors.contains((Object)behavior)) {
                    ((FileCollectionInternal)value.getFiles()).visitStructure(new FileCollectionStructureVisitor(){

                        @Override
                        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                            contents.forEach(location -> taskInputs.add(location.getAbsolutePath()));
                        }

                        @Override
                        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                            if (patterns.isEmpty()) {
                                taskInputs.add(root.getAbsolutePath());
                            } else {
                                filteredFileTreeTaskInputs.add(new FilteredTree(root.getAbsolutePath(), patterns));
                            }
                        }

                        @Override
                        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                            taskInputs.add(file.getAbsolutePath());
                        }
                    });
                }
            }
        });
        this.buildInputHierarchy.recordInputs(taskInputs);
        filteredFileTreeTaskInputs.forEach(fileTree -> this.buildInputHierarchy.recordFilteredInput(fileTree.getRoot(), fileTree.getPatterns().getAsSpec()));
    }

    private static class FilteredTree {
        private final String root;
        private final PatternSet patterns;

        private FilteredTree(String root, PatternSet patterns) {
            this.root = root;
            this.patterns = patterns;
        }

        public String getRoot() {
            return this.root;
        }

        public PatternSet getPatterns() {
            return this.patterns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilteredTree that = (FilteredTree)o;
            return this.root.equals(that.root) && this.patterns.equals(that.patterns);
        }

        public int hashCode() {
            return Objects.hash(this.root, this.patterns);
        }
    }
}

