/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.io.IOException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public interface EncryptionAlgorithm {
    public static final EncryptionAlgorithm NONE = new EncryptionAlgorithm(){

        @Override
        public String getTransformation() {
            return "none";
        }

        @Override
        public String getAlgorithm() {
            return "none";
        }

        @Override
        public Session newSession(SecretKey key) {
            throw new IllegalStateException("Encryption not enabled");
        }
    };

    public String getTransformation();

    public String getAlgorithm();

    public Session newSession(SecretKey var1);

    public static class EncryptionException
    extends RuntimeException {
        public EncryptionException(String message2, Throwable cause) {
            super(message2, cause);
        }

        public EncryptionException(Throwable cause) {
            super(null, cause);
        }
    }

    public static interface Session {
        public SecretKey getKey();

        public EncryptionAlgorithm getAlgorithm();

        public Cipher encryptingCipher(IVCollector var1);

        public Cipher decryptingCipher(IVLoader var1);
    }

    public static interface IVCollector {
        public void collect(byte[] var1) throws IOException;
    }

    public static interface IVLoader {
        public void load(byte[] var1) throws IOException;
    }
}

