/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.util.containers.FList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.CaptureMatchData;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.jetbrains.plugins.textmate.regex.TextMateRange;

public final class TextMateLexer {
    private static final int MAX_LOOPS_COUNT = 10;
    private List<TextMateLexerState> lastSuccessState;
    private int lastSuccessStateOccursCount;
    private int myCurrentOffset;
    private CharSequence myText;
    @NotNull
    private TextMateScope myCurrentScope;
    private FList<TextMateLexerState> myStates;
    private final CharSequence myLanguageScopeName;
    private final int myLineLimit;
    private final boolean myStripWhitespaces;
    private final Runnable myCheckCancelledCallback;
    private final TextMateLexerState myLanguageInitialState;

    public TextMateLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit) {
        if (languageDescriptor == null) {
            TextMateLexer.$$$reportNull$$$0(0);
        }
        this(languageDescriptor, lineLimit, false);
    }

    public TextMateLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit, boolean stripWhitespaces) {
        if (languageDescriptor == null) {
            TextMateLexer.$$$reportNull$$$0(1);
        }
        this.myCurrentOffset = 0;
        this.myText = "";
        this.myCurrentScope = TextMateScope.EMPTY;
        this.myStates = FList.emptyList();
        this.myLanguageScopeName = languageDescriptor.getScopeName();
        this.myLanguageInitialState = TextMateLexerState.notMatched(languageDescriptor.getRootSyntaxNode());
        this.myLineLimit = lineLimit;
        this.myStripWhitespaces = stripWhitespaces;
        this.myCheckCancelledCallback = SyntaxMatchUtils.getCheckCancelledCallback();
    }

    public void init(CharSequence text, int startOffset) {
        this.myText = text;
        this.myCurrentOffset = startOffset;
        this.myStates = FList.emptyList().prepend((Object)this.myLanguageInitialState);
        this.myCurrentScope = new TextMateScope(this.myLanguageScopeName, null);
        this.setLastSuccessState(null);
    }

    public int getCurrentOffset() {
        return this.myCurrentOffset;
    }

    public void advanceLine(@NotNull Queue<Token> output) {
        int endLineOffset;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(2);
        }
        int startLineOffset = this.myCurrentOffset;
        for (endLineOffset = this.myCurrentOffset; endLineOffset < this.myText.length(); ++endLineOffset) {
            if (this.myText.charAt(endLineOffset) != '\n') continue;
            ++endLineOffset;
            break;
        }
        CharSequence lineCharSequence = this.myText.subSequence(startLineOffset, endLineOffset);
        if (this.myLineLimit >= 0 && lineCharSequence.length() > this.myLineLimit) {
            this.parseLine(lineCharSequence.subSequence(0, this.myLineLimit), output);
            this.addToken(output, endLineOffset);
        } else {
            this.parseLine(lineCharSequence, output);
        }
    }

    private void parseLine(@NotNull CharSequence lineCharSequence, @NotNull Queue<Token> output) {
        StringWithId string;
        String line;
        int anchorByteOffset;
        boolean matchBeginOfString;
        int lineByteOffset;
        int linePosition;
        int startLinePosition;
        block18: {
            MatchData matchWhile;
            if (lineCharSequence == null) {
                TextMateLexer.$$$reportNull$$$0(3);
            }
            if (output == null) {
                TextMateLexer.$$$reportNull$$$0(4);
            }
            startLinePosition = this.myCurrentOffset;
            linePosition = 0;
            lineByteOffset = 0;
            matchBeginOfString = startLinePosition == 0;
            anchorByteOffset = -1;
            line = lineCharSequence.length() > 0 && lineCharSequence.charAt(lineCharSequence.length() - 1) == '\n' ? lineCharSequence.toString() : lineCharSequence + "\n";
            string = new StringWithId(line);
            while (true) {
                TextMateLexerState lexerState = (TextMateLexerState)this.myStates.getHead();
                if (lexerState.syntaxRule.getStringAttribute(Constants.StringKey.WHILE) == null) break block18;
                matchWhile = SyntaxMatchUtils.matchStringRegex(Constants.StringKey.WHILE, string, lineByteOffset, anchorByteOffset, matchBeginOfString, lexerState);
                if (matchWhile.matched()) break;
                this.closeScopeSelector(output, linePosition + startLinePosition);
                this.closeScopeSelector(output, linePosition + startLinePosition);
                this.myStates = this.myStates.getTail();
            }
            anchorByteOffset = matchWhile.byteOffset().end;
        }
        HashSet<TextMateLexerState> localStates = new HashSet<TextMateLexerState>();
        while (true) {
            int endPosition;
            TextMateLexerState lastState = (TextMateLexerState)this.myStates.getHead();
            SyntaxNodeDescriptor lastRule = lastState.syntaxRule;
            TextMateLexerState currentState = SyntaxMatchUtils.matchFirst(lastRule, string, lineByteOffset, anchorByteOffset, matchBeginOfString, TextMateWeigh.Priority.NORMAL, this.myCurrentScope);
            SyntaxNodeDescriptor currentRule = currentState.syntaxRule;
            MatchData currentMatch = currentState.matchData;
            MatchData endMatch = SyntaxMatchUtils.matchStringRegex(Constants.StringKey.END, string, lineByteOffset, anchorByteOffset, matchBeginOfString, lastState);
            if (endMatch.matched() && (!currentMatch.matched() || currentMatch.byteOffset().start >= endMatch.byteOffset().start || lastState.equals(currentState))) {
                TextMateLexerState poppedState = (TextMateLexerState)this.myStates.getHead();
                if (poppedState.matchData.matched() && !poppedState.matchedEOL) {
                    anchorByteOffset = poppedState.matchData.byteOffset().end;
                }
                this.myStates = this.myStates.getTail();
                TextMateRange endRange = endMatch.charRange(line, string.bytes);
                int startPosition = endPosition = endRange.start;
                this.closeScopeSelector(output, startPosition + startLinePosition);
                if (lastRule.getCaptures(Constants.CaptureKey.END_CAPTURES) == null && lastRule.getCaptures(Constants.CaptureKey.CAPTURES) == null && lastRule.getCaptures(Constants.CaptureKey.BEGIN_CAPTURES) == null || this.parseCaptures(output, Constants.CaptureKey.END_CAPTURES, lastRule, endMatch, string, line, startLinePosition) || this.parseCaptures(output, Constants.CaptureKey.CAPTURES, lastRule, endMatch, string, line, startLinePosition)) {
                    endPosition = endRange.end;
                }
                this.closeScopeSelector(output, endPosition + startLinePosition);
                if (linePosition == endPosition && TextMateLexer.containsLexerState(localStates, poppedState) && poppedState.enterByteOffset == lineByteOffset) {
                    this.addToken(output, line.length() + startLinePosition);
                    break;
                }
                localStates.remove(poppedState);
            } else if (currentMatch.matched()) {
                anchorByteOffset = currentMatch.byteOffset().end;
                TextMateRange currentRange = currentMatch.charRange(line, string.bytes);
                int startPosition = currentRange.start;
                endPosition = currentRange.end;
                if (currentRule.getStringAttribute(Constants.StringKey.BEGIN) != null) {
                    this.myStates = this.myStates.prepend((Object)currentState);
                    String name = SyntaxMatchUtils.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, name, startPosition + startLinePosition);
                    this.parseCaptures(output, Constants.CaptureKey.BEGIN_CAPTURES, currentRule, currentMatch, string, line, startLinePosition);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, startLinePosition);
                    String contentName = SyntaxMatchUtils.getStringAttribute(Constants.StringKey.CONTENT_NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, contentName, endPosition + startLinePosition);
                } else if (currentRule.getStringAttribute(Constants.StringKey.MATCH) != null) {
                    String name = SyntaxMatchUtils.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, name, startPosition + startLinePosition);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, startLinePosition);
                    this.closeScopeSelector(output, endPosition + startLinePosition);
                }
                if (linePosition == endPosition && TextMateLexer.containsLexerState(localStates, currentState)) {
                    this.addToken(output, line.length() + startLinePosition);
                    break;
                }
                localStates.add(currentState);
            } else {
                this.addToken(output, line.length() + startLinePosition);
                break;
            }
            FList<TextMateLexerState> currentStateSnapshot = this.myStates;
            if (this.lastSuccessState != null && currentStateSnapshot.equals(this.lastSuccessState)) {
                ++this.lastSuccessStateOccursCount;
                if (this.lastSuccessStateOccursCount > 10) {
                    this.addToken(output, line.length() + startLinePosition);
                    break;
                }
            }
            if (linePosition != endPosition) {
                linePosition = endPosition;
                lineByteOffset = RegexUtil.byteOffsetByCharOffset(line, linePosition);
            }
            if (this.myCheckCancelledCallback == null) continue;
            this.myCheckCancelledCallback.run();
        }
    }

    private static boolean containsLexerState(Set<TextMateLexerState> states, TextMateLexerState state) {
        for (TextMateLexerState s : states) {
            if (s.enterByteOffset != state.enterByteOffset || !s.syntaxRule.equals(state.syntaxRule)) continue;
            return true;
        }
        return false;
    }

    private void setLastSuccessState(@Nullable List<TextMateLexerState> state) {
        this.lastSuccessState = state;
        this.lastSuccessStateOccursCount = 0;
    }

    private boolean parseCaptures(@NotNull Queue<Token> output, Constants.CaptureKey capturesKey, SyntaxNodeDescriptor rule, MatchData matchData, StringWithId string, String line, int startLineOffset) {
        Int2ObjectMap<CharSequence> captures;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(5);
        }
        if ((captures = rule.getCaptures(capturesKey)) != null) {
            List<CaptureMatchData> matches = SyntaxMatchUtils.matchCaptures(captures, matchData, string, line);
            List<CaptureMatchData> nonEmptyMatches = matches.stream().filter(m -> m.selectorName.length() > 0 && !m.range.isEmpty()).toList();
            LinkedList<CaptureMatchData> starts = new LinkedList<CaptureMatchData>(nonEmptyMatches);
            Collections.sort(starts, CaptureMatchData.START_OFFSET_ORDERING);
            LinkedList<CaptureMatchData> ends = new LinkedList<CaptureMatchData>(nonEmptyMatches);
            Collections.sort(ends, CaptureMatchData.END_OFFSET_ORDERING);
            while (!starts.isEmpty() || !ends.isEmpty()) {
                CharSequence name;
                CaptureMatchData start;
                CaptureMatchData end;
                if (starts.isEmpty()) {
                    end = ends.removeLast();
                    this.closeScopeSelector(output, end.range.end + startLineOffset);
                    continue;
                }
                if (ends.isEmpty()) {
                    start = starts.removeLast();
                    name = rule.hasBackReference(capturesKey, start.group) ? SyntaxMatchUtils.replaceGroupsWithMatchData(start.selectorName, string, matchData, '$') : start.selectorName;
                    this.openScopeSelector(output, name, start.range.start + startLineOffset);
                    continue;
                }
                if (ends.getLast().group < starts.getLast().group) {
                    end = ends.removeLast();
                    this.closeScopeSelector(output, end.range.end + startLineOffset);
                    continue;
                }
                start = starts.removeLast();
                name = rule.hasBackReference(capturesKey, start.group) ? SyntaxMatchUtils.replaceGroupsWithMatchData(start.selectorName, string, matchData, '$') : start.selectorName;
                this.openScopeSelector(output, name, start.range.start + startLineOffset);
            }
            return !matches.isEmpty();
        }
        return false;
    }

    private void openScopeSelector(@NotNull Queue<Token> output, @Nullable CharSequence name, int position) {
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(6);
        }
        this.addToken(output, position);
        this.myCurrentScope = this.myCurrentScope.add(name);
    }

    private void closeScopeSelector(@NotNull Queue<Token> output, int position) {
        CharSequence lastOpenedName;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(7);
        }
        if ((lastOpenedName = this.myCurrentScope.getScopeName()) != null && lastOpenedName.length() > 0) {
            this.addToken(output, position);
        }
        this.myCurrentScope = this.myCurrentScope.getParentOrSelf();
    }

    private void addToken(@NotNull Queue<Token> output, int position) {
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(8);
        }
        if ((position = Math.min(position, this.myText.length())) > this.myCurrentOffset) {
            int wsEnd;
            boolean newState = this.myCurrentScope.getParent() == null;
            int wsStart = this.myCurrentOffset;
            while (this.myStripWhitespaces && position > this.myCurrentOffset && Character.isWhitespace(this.myText.charAt(this.myCurrentOffset))) {
                ++this.myCurrentOffset;
            }
            if (wsStart < this.myCurrentOffset) {
                output.offer(new Token(TextMateScope.WHITESPACE, wsStart, this.myCurrentOffset, newState));
                newState = false;
            }
            for (wsEnd = position; this.myStripWhitespaces && wsEnd > this.myCurrentOffset && Character.isWhitespace(this.myText.charAt(wsEnd - 1)); --wsEnd) {
            }
            if (this.myCurrentOffset < wsEnd) {
                output.offer(new Token(this.myCurrentScope, this.myCurrentOffset, wsEnd, newState));
            }
            if (wsEnd < position) {
                output.offer(new Token(TextMateScope.WHITESPACE, wsEnd, position, newState));
            }
            this.myCurrentOffset = position;
            this.setLastSuccessState((List<TextMateLexerState>)this.myStates);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageDescriptor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCharSequence";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCaptures";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "openScopeSelector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "closeScopeSelector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Token {
        public final TextMateScope scope;
        public final int startOffset;
        public final int endOffset;
        public final boolean restartable;

        private Token(TextMateScope scope, int startOffset, int endOffset, boolean restartable) {
            this.scope = scope;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.restartable = restartable;
        }
    }
}

