/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlRequiredAltAttributeInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> htmlTagsWithRequiredAltAttribute = Set.of("area", "img", "input", "applet");
    private static final String ALT = "alt";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredAltAttributeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredAltAttributeInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        if (tag.getAttribute(ALT) != null) {
            return;
        }
        if (XmlExtension.getExtension((PsiFile)tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, ALT)) {
            return;
        }
        if (XmlCustomElementDescriptor.isCustomElement((XmlTag)tag)) {
            return;
        }
        if (!htmlTagsWithRequiredAltAttribute.contains(tag.getName())) {
            return;
        }
        if (tag.getName().equalsIgnoreCase("input")) {
            XmlAttribute buttonWithImageType = tag.getAttribute("type");
            if (buttonWithImageType != null && buttonWithImageType.getValue() != null) {
                if (!buttonWithImageType.getValue().equalsIgnoreCase("image")) {
                    return;
                }
            } else {
                return;
            }
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (isOnTheFly) {
            fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, ALT, new String[0]));
        }
        InspectionUtils.RegisterProblem(tag, holder, fixes, HtmlToolsBundle.message("html.inspections.check.required.alt", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @NotNull
    public String getShortName() {
        return "HtmlRequiredAltAttribute";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredAltAttributeInspection";
        objectArray[2] = "checkTag";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

