/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public final class ResourcesTargetType
extends ModuleBasedBuildTargetType<ResourcesTarget> {
    public static final ResourcesTargetType PRODUCTION = new ResourcesTargetType("resources-production", false);
    public static final ResourcesTargetType TEST = new ResourcesTargetType("resources-test", true);
    public static final List<ResourcesTargetType> ALL_TYPES = List.of(PRODUCTION, TEST);
    private final boolean myTests;

    private ResourcesTargetType(String typeId, boolean tests) {
        super(typeId, true);
        this.myTests = tests;
    }

    @Override
    @NotNull
    public List<ResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            ResourcesTargetType.$$$reportNull$$$0(0);
        }
        List modules = model.getProject().getModules();
        ArrayList<ResourcesTarget> targets = new ArrayList<ResourcesTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ResourcesTarget(module, this));
        }
        ArrayList<ResourcesTarget> arrayList = targets;
        if (arrayList == null) {
            ResourcesTargetType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        if (model == null) {
            ResourcesTargetType.$$$reportNull$$$0(2);
        }
        return new Loader(model);
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static ResourcesTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/ResourcesTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/ResourcesTargetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Loader
    extends BuildTargetLoader<ResourcesTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        @Nullable
        public ResourcesTarget createTarget(@NotNull String targetId) {
            JpsModule module;
            if (targetId == null) {
                Loader.$$$reportNull$$$0(0);
            }
            return (module = this.myModules.get(targetId)) != null ? new ResourcesTarget(module, ResourcesTargetType.this) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/builders/java/ResourcesTargetType$Loader", "createTarget"));
        }
    }
}

