/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.builders.artifacts.impl.ArtifactOutToSourceStorageProvider;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.ArtifactSorter;
import org.jetbrains.jps.incremental.artifacts.impl.JarsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.service.JpsServiceManager;

public class IncArtifactBuilder
extends TargetBuilder<ArtifactRootDescriptor, ArtifactBuildTarget> {
    private static final Logger LOG = Logger.getInstance(IncArtifactBuilder.class);
    public static final String BUILDER_ID = "artifacts-builder";

    public IncArtifactBuilder() {
        super(Collections.singletonList(ArtifactBuildTargetType.INSTANCE));
    }

    @Override
    public void build(@NotNull ArtifactBuildTarget target, @NotNull DirtyFilesHolder<ArtifactRootDescriptor, ArtifactBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException {
        if (target == null) {
            IncArtifactBuilder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            IncArtifactBuilder.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            IncArtifactBuilder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            IncArtifactBuilder.$$$reportNull$$$0(3);
        }
        try {
            new IncArtifactBuilderHelper(target, outputConsumer, context).build(holder);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = IncArtifactBuilder.getBuilderName();
        if (string == null) {
            IncArtifactBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    public static String getBuilderName() {
        return JpsBuildBundle.message("builder.name.artifacts.builder", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/IncArtifactBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/IncArtifactBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IncArtifactBuilderHelper {
        @NotNull
        private final ArtifactBuildTarget target;
        @NotNull
        private final JpsArtifact artifact;
        @NotNull
        private final BuildOutputConsumer outputConsumer;
        @NotNull
        private final CompileContext context;
        private final ProjectDescriptor pd;
        private final ArtifactOutputToSourceMapping outSrcMapping;
        private final Int2ObjectMap<Set<String>> filesToProcess;
        private final Set<JarInfo> changedJars;

        private IncArtifactBuilderHelper(@NotNull ArtifactBuildTarget target, @NotNull BuildOutputConsumer consumer, @NotNull CompileContext context) throws IOException {
            if (target == null) {
                IncArtifactBuilderHelper.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                IncArtifactBuilderHelper.$$$reportNull$$$0(1);
            }
            if (context == null) {
                IncArtifactBuilderHelper.$$$reportNull$$$0(2);
            }
            this.filesToProcess = new Int2ObjectOpenHashMap();
            this.changedJars = new HashSet<JarInfo>();
            this.target = target;
            this.artifact = target.getArtifact();
            this.outputConsumer = consumer;
            this.context = context;
            this.pd = context.getProjectDescriptor();
            this.outSrcMapping = this.pd.dataManager.getStorage(target, ArtifactOutToSourceStorageProvider.INSTANCE);
        }

        public void build(DirtyFilesHolder<ArtifactRootDescriptor, ArtifactBuildTarget> holder) throws ProjectBuildException, IOException {
            if (this.startBuild()) {
                this.createAndRunArtifactTasks(ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING);
                this.processDirtyFiles(holder);
                this.collectMissingFiles();
                this.processFiles();
                this.collectMissingJars();
                this.buildJars();
                this.createAndRunArtifactTasks(ArtifactBuildTaskProvider.ArtifactBuildPhase.FINISHING_BUILD);
                this.createAndRunArtifactTasks(ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING);
            }
        }

        private boolean startBuild() {
            String outputFilePath = this.artifact.getOutputFilePath();
            if (StringUtil.isEmpty((String)outputFilePath)) {
                this.context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.build.0.artifact.output.path.is.not.specified", this.artifact.getName())));
                return false;
            }
            ArtifactSorter sorter = new ArtifactSorter(this.pd.getModel());
            Map<JpsArtifact, JpsArtifact> selfIncludingNameMap = sorter.getArtifactToSelfIncludingNameMap();
            JpsArtifact selfIncluding = selfIncludingNameMap.get(this.artifact);
            if (selfIncluding != null) {
                this.context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.build.0.artifact.it.includes.itself", this.artifact.getName(), selfIncluding.getName(), selfIncluding.equals(this.artifact) ? 0 : 1)));
                return false;
            }
            String messageText = JpsBuildBundle.message("progress.message.building.artifact.0", this.artifact.getName());
            this.context.processMessage(new ProgressMessage(messageText));
            LOG.debug(messageText);
            return true;
        }

        private void processDirtyFiles(DirtyFilesHolder<ArtifactRootDescriptor, ArtifactBuildTarget> holder) throws ProjectBuildException, IOException {
            this.context.checkCanceled();
            if (!holder.hasRemovedFiles() && !holder.hasDirtyFiles()) {
                return;
            }
            final Collection<String> deletedFiles = holder.getRemovedFiles(this.target);
            final SourceToOutputMapping srcOutMapping = this.pd.dataManager.getSourceToOutputMap(this.target);
            final MultiMap filesToDelete = new MultiMap();
            Set deletedOutputPaths = CollectionFactory.createFilePathSet();
            for (String sourcePath : deletedFiles) {
                Collection<String> outputPaths = srcOutMapping.getOutputs(sourcePath);
                if (outputPaths == null) continue;
                for (String outputPath : outputPaths) {
                    if (!deletedOutputPaths.add(outputPath)) continue;
                    this.collectSourcesCorrespondingToOutput(outputPath, sourcePath, deletedFiles, this.outSrcMapping, (MultiMap<String, String>)filesToDelete);
                }
            }
            final Set changedOutputPaths = CollectionFactory.createFilePathSet();
            holder.processDirtyFiles(new FileProcessor<ArtifactRootDescriptor, ArtifactBuildTarget>(){

                @Override
                public boolean apply(@NotNull ArtifactBuildTarget target, @NotNull File file, @NotNull ArtifactRootDescriptor root) throws IOException {
                    if (target == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (root == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    int rootIndex = root.getRootIndex();
                    String sourcePath = FileUtil.toSystemIndependentName((String)file.getPath());
                    this.addFileToProcess(rootIndex, sourcePath, deletedFiles);
                    Collection<String> outputPaths = srcOutMapping.getOutputs(sourcePath);
                    if (outputPaths != null) {
                        for (String outputPath : outputPaths) {
                            if (!changedOutputPaths.add(outputPath)) continue;
                            this.collectSourcesCorrespondingToOutput(outputPath, sourcePath, deletedFiles, outSrcMapping, (MultiMap<String, String>)filesToDelete);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "target";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "root";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/jps/incremental/artifacts/IncArtifactBuilder$IncArtifactBuilderHelper$1";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(this.context, holder);
            for (String outputPath : changedOutputPaths) {
                this.outSrcMapping.remove(outputPath);
            }
            this.deleteOutdatedFiles((MultiMap<String, String>)filesToDelete, srcOutMapping, this.outSrcMapping);
        }

        private void collectMissingFiles() throws ProjectBuildException, IOException {
            this.context.checkCanceled();
            ProjectDescriptor pd = this.context.getProjectDescriptor();
            for (ArtifactRootDescriptor descriptor : pd.getBuildRootIndex().getTargetRoots(this.target, this.context)) {
                String outputPath;
                List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources;
                ExplodedDestinationInfo explodedDestinationInfo;
                DestinationInfo destination = descriptor.getDestinationInfo();
                if (!(destination instanceof ExplodedDestinationInfo) || new File((explodedDestinationInfo = (ExplodedDestinationInfo)destination).getOutputFilePath()).exists() || (sources = this.outSrcMapping.getState(outputPath = explodedDestinationInfo.getOutputFilePath())) == null) continue;
                for (ArtifactOutputToSourceMapping.SourcePathAndRootIndex source : sources) {
                    this.addFileToProcess(source.getRootIndex(), source.getPath(), List.of());
                    this.outSrcMapping.remove(outputPath);
                }
            }
        }

        private void collectMissingJars() throws ProjectBuildException {
            this.context.checkCanceled();
            ProjectDescriptor pd = this.context.getProjectDescriptor();
            for (ArtifactRootDescriptor descriptor : pd.getBuildRootIndex().getTargetRoots(this.target, this.context)) {
                JarDestinationInfo jarDestinationInfo;
                DestinationInfo destination = descriptor.getDestinationInfo();
                if (!(destination instanceof JarDestinationInfo) || new File((jarDestinationInfo = (JarDestinationInfo)destination).getOutputFilePath()).exists()) continue;
                this.changedJars.add(jarDestinationInfo.getJarInfo());
            }
        }

        private void processFiles() throws ProjectBuildException, IOException {
            if (this.filesToProcess.isEmpty()) {
                return;
            }
            this.context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.building.artifact.0.copying.files", this.artifact.getName())));
            for (ArtifactRootDescriptor descriptor : this.pd.getBuildRootIndex().getTargetRoots(this.target, this.context)) {
                this.context.checkCanceled();
                Set sourcePaths = (Set)this.filesToProcess.get(descriptor.getRootIndex());
                if (sourcePaths == null) continue;
                for (String sourcePath : sourcePaths) {
                    if (!descriptor.getFilter().shouldBeCopied(sourcePath, this.pd)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("File " + sourcePath + " will be skipped because it isn't accepted by filter");
                        continue;
                    }
                    DestinationInfo destination = descriptor.getDestinationInfo();
                    if (destination instanceof ExplodedDestinationInfo) {
                        descriptor.copyFromRoot(sourcePath, descriptor.getRootIndex(), destination.getOutputPath(), this.context, this.outputConsumer, this.outSrcMapping);
                        continue;
                    }
                    List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources = this.outSrcMapping.getState(destination.getOutputFilePath());
                    if (sources != null && (sources.size() <= 0 || sources.get(0).getRootIndex() != descriptor.getRootIndex())) continue;
                    this.outSrcMapping.update(destination.getOutputFilePath(), Collections.emptyList());
                    this.changedJars.add(((JarDestinationInfo)destination).getJarInfo());
                }
            }
        }

        private void buildJars() throws ProjectBuildException, IOException {
            this.context.checkCanceled();
            JarsBuilder builder = new JarsBuilder(this.changedJars, this.context, this.outputConsumer, this.outSrcMapping);
            builder.buildJars();
        }

        private void collectSourcesCorrespondingToOutput(String outputPath, String sourcePath, Collection<String> deletedFiles, ArtifactOutputToSourceMapping outSrcMapping, MultiMap<String, String> filesToDelete) throws IOException {
            filesToDelete.putValue((Object)outputPath, (Object)sourcePath);
            List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources = outSrcMapping.getState(outputPath);
            if (sources != null) {
                for (ArtifactOutputToSourceMapping.SourcePathAndRootIndex source : sources) {
                    this.addFileToProcess(source.getRootIndex(), source.getPath(), deletedFiles);
                }
            }
        }

        private List<BuildTask> createArtifactTasks(ArtifactBuildTaskProvider.ArtifactBuildPhase phase) {
            ArrayList<BuildTask> result = new ArrayList<BuildTask>();
            for (ArtifactBuildTaskProvider provider : JpsServiceManager.getInstance().getExtensions(ArtifactBuildTaskProvider.class)) {
                result.addAll(provider.createArtifactBuildTasks(this.artifact, phase));
            }
            return result;
        }

        private void runArtifactTasks(List<BuildTask> tasks, ArtifactBuildTaskProvider.ArtifactBuildPhase phase) throws ProjectBuildException {
            if (!tasks.isEmpty()) {
                this.context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.running.0.tasks.for.1.artifact", phase.ordinal(), this.artifact.getName())));
                for (BuildTask task : tasks) {
                    this.context.checkCanceled();
                    task.build(this.context);
                }
            }
        }

        private void createAndRunArtifactTasks(ArtifactBuildTaskProvider.ArtifactBuildPhase phase) throws ProjectBuildException {
            this.runArtifactTasks(this.createArtifactTasks(phase), phase);
        }

        private void addFileToProcess(int rootIndex, String path, Collection<String> deletedFiles) {
            if (deletedFiles.contains(path)) {
                return;
            }
            Set paths = (Set)this.filesToProcess.get(rootIndex);
            if (paths == null) {
                paths = CollectionFactory.createFilePathSet();
                this.filesToProcess.put(rootIndex, (Object)paths);
            }
            paths.add(path);
        }

        private void deleteOutdatedFiles(MultiMap<String, String> filesToDelete, SourceToOutputMapping srcOutMapping, ArtifactOutputToSourceMapping outSrcMapping) throws IOException {
            ProjectBuilderLogger logger;
            if (filesToDelete.isEmpty()) {
                return;
            }
            this.context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.deleting.outdated.files", new Object[0])));
            int notDeletedFilesCount = 0;
            Set notDeletedPaths = CollectionFactory.createFilePathSet();
            Set deletedPaths = CollectionFactory.createFilePathSet();
            for (String filePath : filesToDelete.keySet()) {
                if (notDeletedPaths.contains(filePath)) continue;
                boolean deleted = deletedPaths.contains(filePath);
                if (!deleted) {
                    deleted = FileUtil.delete((File)new File(filePath));
                }
                if (deleted) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Outdated output file deleted: " + filePath);
                    }
                    outSrcMapping.remove(filePath);
                    deletedPaths.add(filePath);
                    for (String sourcePath : filesToDelete.get((Object)filePath)) {
                        srcOutMapping.removeOutput(sourcePath, filePath);
                    }
                    continue;
                }
                notDeletedPaths.add(filePath);
                if (notDeletedFilesCount++ > 50) {
                    this.context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.deletion.of.outdated.files.stopped", new Object[0])));
                    break;
                }
                this.context.processMessage(new CompilerMessage(IncArtifactBuilder.getBuilderName(), BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.cannot.delete.file.0", filePath)));
            }
            if ((logger = this.context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
                logger.logDeletedFiles(deletedPaths);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/incremental/artifacts/IncArtifactBuilder$IncArtifactBuilderHelper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

