/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 S2\u00020\u0001:\u0002STB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H'J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0013H&J1\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019\"\n\b\u0001\u0010\u001a*\u0004\u0018\u00010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a0\u001d\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 \"\u0004\b\u0000\u0010\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\"\u00a2\u0006\u0002\u0010#J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 \"\u0004\b\u0000\u0010\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00190%H\u0007J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0007J\u001f\u0010/\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001900\u00a2\u0006\u0002\u00101J\u000e\u0010/\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H&J \u00103\u001a\u00020\u0013\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a04J\b\u00105\u001a\u000206H'J\u001d\u00107\u001a\u00020\u00132\u000b\u00108\u001a\u000709\u00a2\u0006\u0002\b:2\u0006\u0010;\u001a\u00020.H&J\u0015\u0010<\u001a\u00020\u00132\u000b\u0010=\u001a\u000709\u00a2\u0006\u0002\b:H&J\u0010\u0010>\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H&J\u0018\u0010>\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.2\u0006\u0010?\u001a\u00020@H&J\u001d\u0010A\u001a\u00020\u00132\u000b\u0010B\u001a\u000709\u00a2\u0006\u0002\bC2\u0006\u0010D\u001a\u00020.H&J<\u0010A\u001a\u00020\u00132\u000b\u0010B\u001a\u000709\u00a2\u0006\u0002\bC2\u001c\u0010D\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130F\u0012\u0006\u0012\u0004\u0018\u00010\u00010EH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ0\u0010H\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u0019002\r\u0010I\u001a\t\u0018\u000109\u00a2\u0006\u0002\b:\u00a2\u0006\u0002\u0010JJ\u0010\u0010K\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H'J\b\u0010L\u001a\u00020\u0013H&J\u000e\u0010M\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.J\u0018\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J \u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020(2\u0006\u0010R\u001a\u00020.2\u0006\u0010)\u001a\u00020*H&R\"\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006U"}, d2={"Lcom/intellij/openapi/project/DumbService;", "", "()V", "<set-?>", "", "isAlternativeResolveEnabled", "()Z", "setAlternativeResolveEnabled", "(Z)V", "isDumb", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "cancelAllTasksAndWait", "", "cancelTask", "task", "Lcom/intellij/openapi/project/DumbModeTask;", "completeJustSubmittedTasks", "computeWithAlternativeResolveEnabled", "T", "E", "", "runnable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "filterByDumbAwareness", "", "array", "", "([Ljava/lang/Object;)Ljava/util/List;", "collection", "", "makeDumbAware", "componentToDisable", "Ljavax/swing/JComponent;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "queueTask", "repeatUntilPassesInSmartMode", "r", "Ljava/lang/Runnable;", "runReadActionInSmartMode", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "runWhenSmart", "runWithAlternativeResolveEnabled", "Lcom/intellij/util/ThrowableRunnable;", "runWithWaitForSmartModeDisabled", "Lcom/intellij/openapi/application/AccessToken;", "showDumbModeActionBalloon", "balloonText", "", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "runWhenSmartAndBalloonStillShowing", "showDumbModeNotification", "message", "smartInvokeLater", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "suspendIndexingAndRun", "activityName", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "activity", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryRunReadActionInSmartMode", "notification", "(Lcom/intellij/openapi/util/Computable;Ljava/lang/String;)Ljava/lang/Object;", "unsafeRunWhenSmart", "waitForSmartMode", "withAlternativeResolveEnabled", "wrapGently", "dumbUnawareContent", "wrapWithSpoiler", "dumbAwareContent", "updateRunnable", "Companion", "DumbModeListener", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nDumbService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumbService.kt\ncom/intellij/openapi/project/DumbService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n1#2:433\n*E\n"})
public abstract class DumbService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class, Topic.BroadcastDirection.NONE);

    @NotNull
    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public final <T> T runReadActionInSmartMode(@NotNull Computable<T> r) {
        Intrinsics.checkNotNullParameter(r, "r");
        Ref result2 = new Ref();
        this.runReadActionInSmartMode(() -> DumbService.runReadActionInSmartMode$lambda$0(result2, r));
        return (T)result2.get();
    }

    @Nullable
    public final <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @Nullable String notification) {
        T t;
        Intrinsics.checkNotNullParameter(task, "task");
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            T t2;
            try {
                t2 = task.compute();
            }
            catch (IndexNotReadyException e) {
                String string2 = notification;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    this.showDumbModeNotification(it);
                }
                t2 = null;
            }
            t = t2;
        } else {
            t = this.runReadActionInSmartMode(task);
        }
        return t;
    }

    public final void runReadActionInSmartMode(@NotNull Runnable r) {
        Boolean success;
        Intrinsics.checkNotNullParameter(r, "r");
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
            success = (Boolean)ReadAction.compute(() -> DumbService.runReadActionInSmartMode$lambda$2(this, r));
            Intrinsics.checkNotNullExpressionValue(success, "success");
        } while (!success.booleanValue());
    }

    @Deprecated(message="This method provides no guarantees and should be avoided, please use [#runReadActionInSmartMode] instead.")
    @ApiStatus.ScheduledForRemoval
    public final void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter(r, "r");
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    @NotNull
    public final <T> List<T> filterByDumbAwareness(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return this.filterByDumbAwareness((Collection)CollectionsKt.listOf(Arrays.copyOf(array, array.length)));
    }

    @Contract(pure=true)
    @NotNull
    public final <T> List<T> filterByDumbAwareness(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        if (this.isDumb()) {
            List result2 = new ArrayList(collection.size());
            for (T element : collection) {
                if (!Companion.isDumbAware(element)) continue;
                result2.add(element);
            }
            return result2;
        }
        return collection instanceof List ? (List)collection : (List)new ArrayList<T>(collection);
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    @ApiStatus.Internal
    public abstract void cancelAllTasksAndWait();

    public abstract void completeJustSubmittedTasks();

    @NotNull
    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    @NotNull
    public abstract JComponent wrapWithSpoiler(@NotNull JComponent var1, @NotNull Runnable var2, @NotNull Disposable var3);

    public final void makeDumbAware(@NotNull JComponent componentToDisable, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(componentToDisable, "componentToDisable");
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        componentToDisable.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(componentToDisable){
            final /* synthetic */ JComponent $componentToDisable;
            {
                this.$componentToDisable = $componentToDisable;
            }

            public void enteredDumbMode() {
                this.$componentToDisable.setEnabled(false);
            }

            public void exitDumbMode() {
                this.$componentToDisable.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull String var1);

    public abstract void showDumbModeActionBalloon(@NotNull String var1, @NotNull Runnable var2);

    @NotNull
    public abstract Project getProject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        boolean isDumb = this.isDumb();
        if (isDumb) {
            this.setAlternativeResolveEnabled(true);
        }
        try {
            runnable.run();
        }
        finally {
            if (isDumb) {
                this.setAlternativeResolveEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T, E extends Throwable> T computeWithAlternativeResolveEnabled(@NotNull ThrowableComputable<T, E> runnable) {
        Object object;
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        boolean isDumb = this.isDumb();
        if (isDumb) {
            this.setAlternativeResolveEnabled(true);
        }
        try {
            object = runnable.compute();
        }
        finally {
            if (isDumb) {
                this.setAlternativeResolveEnabled(false);
            }
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends Throwable> void runWithAlternativeResolveEnabled(@NotNull ThrowableRunnable<E> runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        boolean isDumb = this.isDumb();
        if (isDumb) {
            this.setAlternativeResolveEnabled(true);
        }
        try {
            runnable.run();
        }
        finally {
            if (isDumb) {
                this.setAlternativeResolveEnabled(false);
            }
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    @Deprecated(message="Use [#runWithAlternativeResolveEnabled(ThrowableRunnable)] or [#computeWithAlternativeResolveEnabled(ThrowableComputable)]\n    or [#withAlternativeResolveEnabled(Runnable)] instead")
    public abstract void setAlternativeResolveEnabled(boolean var1);

    public abstract void suspendIndexingAndRun(@NotNull String var1, @NotNull Runnable var2);

    @ApiStatus.Experimental
    @Nullable
    public abstract Object suspendIndexingAndRun(@NotNull String var1, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> var2, @NotNull Continuation<? super Unit> var3);

    @ApiStatus.Internal
    @NotNull
    public abstract AccessToken runWithWaitForSmartModeDisabled();

    @ApiStatus.Internal
    public abstract void unsafeRunWhenSmart(@NotNull Runnable var1);

    private static final void runReadActionInSmartMode$lambda$0(Ref $result, Computable $r) {
        Intrinsics.checkNotNullParameter($result, "$result");
        Intrinsics.checkNotNullParameter($r, "$r");
        $result.set($r.compute());
    }

    private static final Boolean runReadActionInSmartMode$lambda$2(DumbService this$0, Runnable $r) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($r, "$r");
        if (this$0.getProject().isDisposed()) {
            throw new ProcessCanceledException();
        }
        if (this$0.isDumb()) {
            return false;
        }
        $r.run();
        return true;
    }

    @JvmStatic
    public static final boolean isDumb(@NotNull Project project) {
        return Companion.isDumb(project);
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ExtensionPointName<T> extensionPoint) {
        return Companion.getDumbAwareExtensions(project, extensionPoint);
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ProjectExtensionPointName<T> extensionPoint) {
        return Companion.getDumbAwareExtensions(project, extensionPoint);
    }

    @JvmStatic
    @NotNull
    public static final DumbService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Contract(value="null -> false", pure=true)
    public static final boolean isDumbAware(@Nullable Object o) {
        return Companion.isDumbAware(o);
    }

    @JvmStatic
    @Deprecated(message="Obsolete, does nothing, just executes the passed runnable.", replaceWith=@ReplaceWith(expression="runnable.run()", imports={}))
    @ApiStatus.ScheduledForRemoval
    public static final void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
        Companion.allowStartingDumbModeInside(permission, runnable);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/project/DumbService$Companion;", "", "()V", "DUMB_MODE", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/project/DumbService$DumbModeListener;", "allowStartingDumbModeInside", "", "permission", "Lcom/intellij/openapi/project/DumbModePermission;", "runnable", "Ljava/lang/Runnable;", "getDumbAwareExtensions", "", "T", "project", "Lcom/intellij/openapi/project/Project;", "extensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/extensions/ProjectExtensionPointName;", "getInstance", "Lcom/intellij/openapi/project/DumbService;", "isDumb", "", "isDumbAware", "o", "intellij.platform.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isDumb(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            return this.getInstance(project).isDumb();
        }

        @JvmStatic
        @NotNull
        public final <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ExtensionPointName<T> extensionPoint) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(extensionPoint, "extensionPoint");
            ExtensionPoint point = extensionPoint.getPoint();
            int size = point.size();
            if (size == 0) {
                return CollectionsKt.emptyList();
            }
            if (!this.getInstance(project).isDumb()) {
                List list = point.getExtensionList();
                Intrinsics.checkNotNullExpressionValue(list, "point.extensionList");
                return list;
            }
            List result2 = new ArrayList(size);
            Intrinsics.checkNotNull(point, "null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionPointImpl<T of com.intellij.openapi.project.DumbService.Companion.getDumbAwareExtensions>");
            for (Object element : (ExtensionPointImpl)point) {
                if (!this.isDumbAware(element)) continue;
                Object e = element;
                Intrinsics.checkNotNull(e);
                result2.add(e);
            }
            return result2;
        }

        @JvmStatic
        @NotNull
        public final <T> List<T> getDumbAwareExtensions(@NotNull Project project, @NotNull ProjectExtensionPointName<T> extensionPoint) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(extensionPoint, "extensionPoint");
            DumbService dumbService = this.getInstance(project);
            return dumbService.filterByDumbAwareness(extensionPoint.getExtensions((AreaInstance)project));
        }

        @JvmStatic
        @NotNull
        public final DumbService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            Object object = project.getService(DumbService.class);
            Intrinsics.checkNotNullExpressionValue(object, "project.getService(DumbService::class.java)");
            return (DumbService)object;
        }

        @JvmStatic
        @Contract(value="null -> false", pure=true)
        public final boolean isDumbAware(@Nullable Object o) {
            return o instanceof PossiblyDumbAware ? ((PossiblyDumbAware)o).isDumbAware() : o instanceof DumbAware;
        }

        @JvmStatic
        @Deprecated(message="Obsolete, does nothing, just executes the passed runnable.", replaceWith=@ReplaceWith(expression="runnable.run()", imports={}))
        @ApiStatus.ScheduledForRemoval
        public final void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)permission, "permission");
            Intrinsics.checkNotNullParameter(runnable, "runnable");
            runnable.run();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/project/DumbService$DumbModeListener;", "", "enteredDumbMode", "", "exitDumbMode", "intellij.platform.core"})
    public static interface DumbModeListener {
        default public void enteredDumbMode() {
        }

        default public void exitDumbMode() {
        }
    }
}

