/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLAttribute;

public class XMLElement
implements IXMLElement,
Serializable {
    static final long serialVersionUID = -2383376380548624920L;
    public static final int NO_LINE = -1;
    private IXMLElement parent;
    private Vector attributes = new Vector();
    private Vector children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String string2) {
        this(string2, null, null, -1);
    }

    public XMLElement(String string2, String string3, int n) {
        this(string2, null, string3, n);
    }

    public XMLElement(String string2, String string3) {
        this(string2, string3, null, -1);
    }

    public XMLElement(String string2, String string3, String string4, int n) {
        int n2;
        this.fullName = string2;
        this.name = string3 == null ? string2 : ((n2 = string2.indexOf(58)) >= 0 ? string2.substring(n2 + 1) : string2);
        this.namespace = string3;
        this.content = null;
        this.lineNr = n;
        this.systemID = string4;
        this.parent = null;
    }

    public IXMLElement createPCDataElement() {
        return new XMLElement();
    }

    public IXMLElement createElement(String string2) {
        return new XMLElement(string2);
    }

    public IXMLElement createElement(String string2, String string3, int n) {
        return new XMLElement(string2, string3, n);
    }

    public IXMLElement createElement(String string2, String string3) {
        return new XMLElement(string2, string3);
    }

    public IXMLElement createElement(String string2, String string3, String string4, int n) {
        return new XMLElement(string2, string3, string4, n);
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    public IXMLElement getParent() {
        return this.parent;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setName(String string2) {
        this.name = string2;
        this.fullName = string2;
        this.namespace = null;
    }

    public void setName(String string2, String string3) {
        int n = string2.indexOf(58);
        this.name = string3 == null || n < 0 ? string2 : string2.substring(n + 1);
        this.fullName = string2;
        this.namespace = string3;
    }

    public void addChild(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2;
        if (iXMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (iXMLElement.getName() == null && !this.children.isEmpty() && (iXMLElement2 = (IXMLElement)this.children.lastElement()).getName() == null) {
            iXMLElement2.setContent(iXMLElement2.getContent() + iXMLElement.getContent());
            return;
        }
        ((XMLElement)iXMLElement).parent = this;
        this.children.addElement(iXMLElement);
    }

    public void insertChild(IXMLElement iXMLElement, int n) {
        IXMLElement iXMLElement2;
        if (iXMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (iXMLElement.getName() == null && !this.children.isEmpty() && (iXMLElement2 = (IXMLElement)this.children.lastElement()).getName() == null) {
            iXMLElement2.setContent(iXMLElement2.getContent() + iXMLElement.getContent());
            return;
        }
        ((XMLElement)iXMLElement).parent = this;
        this.children.insertElementAt(iXMLElement, n);
    }

    public void removeChild(IXMLElement iXMLElement) {
        if (iXMLElement == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(iXMLElement);
    }

    public void removeChildAtIndex(int n) {
        this.children.removeElementAt(n);
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public Vector getChildren() {
        return this.children;
    }

    public IXMLElement getChildAtIndex(int n) throws ArrayIndexOutOfBoundsException {
        return (IXMLElement)this.children.elementAt(n);
    }

    public IXMLElement getFirstChildNamed(String string2) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            IXMLElement iXMLElement = (IXMLElement)enumeration.nextElement();
            String string3 = iXMLElement.getFullName();
            if (string3 == null || !string3.equals(string2)) continue;
            return iXMLElement;
        }
        return null;
    }

    public IXMLElement getFirstChildNamed(String string2, String string3) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            IXMLElement iXMLElement = (IXMLElement)enumeration.nextElement();
            String string4 = iXMLElement.getName();
            boolean bl = string4 != null && string4.equals(string2);
            string4 = iXMLElement.getNamespace();
            bl = string4 == null ? (bl &= string2 == null) : (bl &= string4.equals(string3));
            if (!bl) continue;
            return iXMLElement;
        }
        return null;
    }

    public Vector getChildrenNamed(String string2) {
        Vector<IXMLElement> vector = new Vector<IXMLElement>(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            IXMLElement iXMLElement = (IXMLElement)enumeration.nextElement();
            String string3 = iXMLElement.getFullName();
            if (string3 == null || !string3.equals(string2)) continue;
            vector.addElement(iXMLElement);
        }
        return vector;
    }

    public Vector getChildrenNamed(String string2, String string3) {
        Vector<IXMLElement> vector = new Vector<IXMLElement>(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            IXMLElement iXMLElement = (IXMLElement)enumeration.nextElement();
            String string4 = iXMLElement.getName();
            boolean bl = string4 != null && string4.equals(string2);
            string4 = iXMLElement.getNamespace();
            bl = string4 == null ? (bl &= string2 == null) : (bl &= string4.equals(string3));
            if (!bl) continue;
            vector.addElement(iXMLElement);
        }
        return vector;
    }

    private XMLAttribute findAttribute(String string2) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
            if (!xMLAttribute.getFullName().equals(string2)) continue;
            return xMLAttribute;
        }
        return null;
    }

    private XMLAttribute findAttribute(String string2, String string3) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
            boolean bl = xMLAttribute.getName().equals(string2);
            bl = string3 == null ? (bl &= xMLAttribute.getNamespace() == null) : (bl &= string3.equals(xMLAttribute.getNamespace()));
            if (!bl) continue;
            return xMLAttribute;
        }
        return null;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttribute(String string2) {
        return this.getAttribute(string2, null);
    }

    public String getAttribute(String string2, String string3) {
        XMLAttribute xMLAttribute = this.findAttribute(string2);
        if (xMLAttribute == null) {
            return string3;
        }
        return xMLAttribute.getValue();
    }

    public String getAttribute(String string2, String string3, String string4) {
        XMLAttribute xMLAttribute = this.findAttribute(string2, string3);
        if (xMLAttribute == null) {
            return string4;
        }
        return xMLAttribute.getValue();
    }

    public int getAttribute(String string2, int n) {
        String string3 = this.getAttribute(string2, Integer.toString(n));
        return Integer.parseInt(string3);
    }

    public int getAttribute(String string2, String string3, int n) {
        String string4 = this.getAttribute(string2, string3, Integer.toString(n));
        return Integer.parseInt(string4);
    }

    public String getAttributeType(String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string2);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getType();
    }

    public String getAttributeNamespace(String string2) {
        XMLAttribute xMLAttribute = this.findAttribute(string2);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getNamespace();
    }

    public String getAttributeType(String string2, String string3) {
        XMLAttribute xMLAttribute = this.findAttribute(string2, string3);
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.getType();
    }

    public void setAttribute(String string2, String string3) {
        XMLAttribute xMLAttribute = this.findAttribute(string2);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string2, string2, null, string3, "CDATA");
            this.attributes.addElement(xMLAttribute);
        } else {
            xMLAttribute.setValue(string3);
        }
    }

    public void setAttribute(String string2, String string3, String string4) {
        int n = string2.indexOf(58);
        String string5 = string2.substring(n + 1);
        XMLAttribute xMLAttribute = this.findAttribute(string5, string3);
        if (xMLAttribute == null) {
            xMLAttribute = new XMLAttribute(string2, string5, string3, string4, "CDATA");
            this.attributes.addElement(xMLAttribute);
        } else {
            xMLAttribute.setValue(string4);
        }
    }

    public void removeAttribute(String string2) {
        int n = 0;
        while (n < this.attributes.size()) {
            XMLAttribute xMLAttribute = (XMLAttribute)this.attributes.elementAt(n);
            if (xMLAttribute.getFullName().equals(string2)) {
                this.attributes.removeElementAt(n);
                return;
            }
            ++n;
        }
    }

    public void removeAttribute(String string2, String string3) {
        int n = 0;
        while (n < this.attributes.size()) {
            XMLAttribute xMLAttribute = (XMLAttribute)this.attributes.elementAt(n);
            boolean bl = xMLAttribute.getName().equals(string2);
            bl = string3 == null ? (bl &= xMLAttribute.getNamespace() == null) : (bl &= xMLAttribute.getNamespace().equals(string3));
            if (bl) {
                this.attributes.removeElementAt(n);
                return;
            }
            ++n;
        }
    }

    public Enumeration enumerateAttributeNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
            vector.addElement(xMLAttribute.getFullName());
        }
        return vector.elements();
    }

    public boolean hasAttribute(String string2) {
        return this.findAttribute(string2) != null;
    }

    public boolean hasAttribute(String string2, String string3) {
        return this.findAttribute(string2, string3) != null;
    }

    public Properties getAttributes() {
        Properties properties2 = new Properties();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
            ((Hashtable)properties2).put(xMLAttribute.getFullName(), xMLAttribute.getValue());
        }
        return properties2;
    }

    public Properties getAttributesInNamespace(String string2) {
        Properties properties2 = new Properties();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
            if (string2 == null) {
                if (xMLAttribute.getNamespace() != null) continue;
                ((Hashtable)properties2).put(xMLAttribute.getName(), xMLAttribute.getValue());
                continue;
            }
            if (!string2.equals(xMLAttribute.getNamespace())) continue;
            ((Hashtable)properties2).put(xMLAttribute.getName(), xMLAttribute.getValue());
        }
        return properties2;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string2) {
        this.content = string2;
    }

    public boolean equals(Object object) {
        try {
            return this.equalsXMLElement((IXMLElement)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equalsXMLElement(IXMLElement iXMLElement) {
        Object object;
        Object object2;
        if (!this.name.equals(iXMLElement.getName())) {
            return false;
        }
        if (this.attributes.size() != iXMLElement.getAttributeCount()) {
            return false;
        }
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            XMLAttribute xMLAttribute = (XMLAttribute)enumeration.nextElement();
            if (!iXMLElement.hasAttribute(xMLAttribute.getName(), xMLAttribute.getNamespace())) {
                return false;
            }
            object2 = iXMLElement.getAttribute(xMLAttribute.getName(), xMLAttribute.getNamespace(), null);
            if (!xMLAttribute.getValue().equals(object2)) {
                return false;
            }
            object = iXMLElement.getAttributeType(xMLAttribute.getName(), xMLAttribute.getNamespace());
            if (xMLAttribute.getType().equals(object)) continue;
            return false;
        }
        if (this.children.size() != iXMLElement.getChildrenCount()) {
            return false;
        }
        int n = 0;
        while (n < this.children.size()) {
            object2 = this.getChildAtIndex(n);
            if (!object2.equalsXMLElement((IXMLElement)(object = iXMLElement.getChildAtIndex(n)))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

