/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GdslFileType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class NewScriptAction
extends JavaCreateTemplateInPackageAction<GroovyFile>
implements DumbAware {
    public NewScriptAction() {
        super(GroovyBundle.message("new.script.action.text", new Object[0]), GroovyBundle.message("new.script.action.description", new Object[0]), JetgroovyIcons.Groovy.GroovyFile, false);
    }

    protected void buildDialog(Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(GroovyBundle.message("new.script.dialog.title", new Object[0])).addKind(GroovyBundle.message("new.script.list.item.script", new Object[0]), JetgroovyIcons.Groovy.GroovyFile, "Groovy Script.groovy").addKind(GroovyBundle.message("new.script.list.item.script.dsl", new Object[0]), JetgroovyIcons.Groovy.GroovyFile, "Groovy DSL Script.gdsl");
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibrariesUtil.hasGroovySdk((Module)PlatformCoreDataKeys.MODULE.getData(dataContext));
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            NewScriptAction.$$$reportNull$$$0(0);
        }
        return GroovyBundle.message("new.script.action.text", new Object[0]);
    }

    protected PsiElement getNavigationElement(@NotNull GroovyFile createdFile) {
        if (createdFile == null) {
            NewScriptAction.$$$reportNull$$$0(1);
        }
        return createdFile.getLastChild();
    }

    @NotNull
    protected GroovyFile doCreate(PsiDirectory directory, String newName, String templateName) throws IncorrectOperationException {
        String fileName = newName + "." + NewScriptAction.extractExtension(templateName);
        PsiFile file = GroovyTemplatesFactory.createFromTemplate(directory, newName, fileName, templateName, true, new String[0]);
        if (file instanceof GroovyFile) {
            GroovyFile groovyFile = (GroovyFile)file;
            if (groovyFile == null) {
                NewScriptAction.$$$reportNull$$$0(2);
            }
            return groovyFile;
        }
        String description = file.getFileType().getDescription();
        throw new IncorrectOperationException(GroovyBundle.message("groovy.file.extension.is.not.mapped.to.groovy.file.type", description));
    }

    private static String extractExtension(String templateName) {
        if ("Groovy DSL Script.gdsl".equals(templateName)) {
            return GdslFileType.INSTANCE.getDefaultExtension();
        }
        return "groovy";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/actions/NewScriptAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/actions/NewScriptAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

