/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class ChangeExtendsImplementsQuickFix
implements IntentionAction {
    @Nullable
    private final GrExtendsClause myExtendsClause;
    @Nullable
    private final GrImplementsClause myImplementsClause;
    @NotNull
    private final GrTypeDefinition myClass;

    public ChangeExtendsImplementsQuickFix(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
        this.myExtendsClause = aClass.getExtendsClause();
        this.myImplementsClause = aClass.getImplementsClause();
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(1);
        }
        GrTypeDefinition copy = (GrTypeDefinition)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myClass, (PsiFile)target);
        return new ChangeExtendsImplementsQuickFix(copy);
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("change.implements.and.extends.classes", new Object[0]);
        if (string == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(4);
        }
        return this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ChangeExtendsImplementsQuickFix.$$$reportNull$$$0(5);
        }
        LinkedHashSet<String> classes2 = new LinkedHashSet<String>();
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> unknownClasses = new LinkedHashSet<String>();
        LinkedHashSet<String> unknownInterfaces = new LinkedHashSet<String>();
        if (this.myExtendsClause != null) {
            ChangeExtendsImplementsQuickFix.collectRefs(this.myExtendsClause.getReferenceElementsGroovy(), classes2, interfaces, this.myClass.isInterface() ? unknownInterfaces : unknownClasses);
            this.myExtendsClause.delete();
        }
        if (this.myImplementsClause != null) {
            ChangeExtendsImplementsQuickFix.collectRefs(this.myImplementsClause.getReferenceElementsGroovy(), classes2, interfaces, unknownInterfaces);
            this.myImplementsClause.delete();
        }
        if (this.myClass.isInterface()) {
            interfaces.addAll(classes2);
            unknownInterfaces.addAll(unknownClasses);
            this.addNewClause(interfaces, unknownInterfaces, project, true);
        } else {
            this.addNewClause(classes2, unknownClasses, project, true);
            this.addNewClause(interfaces, unknownInterfaces, project, false);
        }
    }

    private static void collectRefs(GrCodeReferenceElement[] refs, Collection<? super String> classes2, Collection<? super String> interfaces, Collection<? super String> unknown) {
        for (GrCodeReferenceElement ref2 : refs) {
            PsiElement extendsElement = ref2.resolve();
            String canonicalText = ref2.getCanonicalText();
            if (extendsElement instanceof PsiClass) {
                if (((PsiClass)extendsElement).isInterface()) {
                    interfaces.add(canonicalText);
                    continue;
                }
                classes2.add(canonicalText);
                continue;
            }
            unknown.add(canonicalText);
        }
    }

    private void addNewClause(Collection<String> elements, Collection<String> additional, Project project, boolean isExtends) throws IncorrectOperationException {
        GrReferenceList clause;
        if (elements.isEmpty() && additional.isEmpty()) {
            return;
        }
        @NlsSafe StringBuilder classText = new StringBuilder();
        classText.append("class A ");
        classText.append(isExtends ? "extends " : "implements ");
        for (String str : elements) {
            classText.append(str);
            classText.append(", ");
        }
        for (String str : additional) {
            classText.append(str);
            classText.append(", ");
        }
        classText.delete(classText.length() - 2, classText.length());
        classText.append(" {}");
        GrTypeDefinition definition = GroovyPsiElementFactory.getInstance(project).createTypeDefinition(classText.toString());
        GrReferenceList grReferenceList = clause = isExtends ? definition.getExtendsClause() : definition.getImplementsClause();
        assert (clause != null);
        PsiElement addedClause = this.myClass.addBefore(clause, this.myClass.getBody());
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedClause);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

