/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.base;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LazyKt;
import kotlin.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

public abstract class Intention
implements IntentionAction {
    @FileModifier.SafeFieldForPreview
    private final Lazy<PsiElementPredicate> predicate = LazyKt.lazyPub(this::getElementPredicate);

    protected Intention() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            Intention.$$$reportNull$$$0(0);
        }
        if ((element = this.findMatchingElement(file, editor)) == null) {
            return;
        }
        assert (element.isValid()) : element;
        this.processIntention(element, project, editor);
    }

    protected abstract void processIntention(@NotNull PsiElement var1, @NotNull Project var2, Editor var3) throws IncorrectOperationException;

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    protected static void replaceExpressionWithNegatedExpressionString(@NotNull String newExpression, @NotNull GrExpression expression) throws IncorrectOperationException {
        Object expString;
        if (newExpression == null) {
            Intention.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            Intention.$$$reportNull$$$0(2);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression expressionToReplace = expression;
        if (BoolUtils.isNegated(expression)) {
            expressionToReplace = BoolUtils.findNegation(expression);
            expString = newExpression;
        } else {
            expString = "!(" + newExpression + ")";
        }
        GrExpression newCall = factory.createExpressionFromText((String)expString, expression.getContext());
        assert (expressionToReplace != null);
        expressionToReplace.replaceWithExpression(newCall, true);
    }

    @Nullable
    PsiElement findMatchingElement(PsiFile file, Editor editor) {
        PsiElement element;
        if (!file.getViewProvider().getLanguages().contains((Object)GroovyLanguage.INSTANCE)) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            if (0 <= start && start <= end) {
                TextRange selectionRange = new TextRange(start, end);
                for (PsiElement element2 = PsiImplUtil.findElementInRange(file, start, end, PsiElement.class); element2 != null && element2.getTextRange() != null && selectionRange.contains(element2.getTextRange()); element2 = element2.getParent()) {
                    if (!((PsiElementPredicate)this.predicate.getValue()).satisfiedBy(element2)) continue;
                    return element2;
                }
            }
        }
        int position = editor.getCaretModel().getOffset();
        for (element = file.findElementAt(position); element != null; element = element.getParent()) {
            if (((PsiElementPredicate)this.predicate.getValue()).satisfiedBy(element)) {
                return element;
            }
            if (this.isStopElement(element)) break;
        }
        for (element = file.findElementAt(position - 1); element != null; element = element.getParent()) {
            if (((PsiElementPredicate)this.predicate.getValue()).satisfiedBy(element)) {
                return element;
            }
            if (!this.isStopElement(element)) continue;
            return null;
        }
        return null;
    }

    protected boolean isStopElement(PsiElement element) {
        return element instanceof PsiFile;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            Intention.$$$reportNull$$$0(3);
        }
        return this.findMatchingElement(file, editor) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private String getPrefix() {
        Class<?> aClass = this.getClass();
        String name = aClass.getSimpleName();
        StringBuilder buffer = new StringBuilder(name.length() + 10);
        buffer.append(Character.toLowerCase(name.charAt(0)));
        for (int i2 = 1; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (Character.isUpperCase(c)) {
                buffer.append('.');
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @NotNull
    @IntentionName
    public String getText() {
        String string = GroovyIntentionsBundle.message(this.getPrefix() + ".name", new Object[0]);
        if (string == null) {
            Intention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message(this.getPrefix() + ".family.name", new Object[0]);
        if (string == null) {
            Intention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/base/Intention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/base/Intention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithNegatedExpressionString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

