/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ParagraphMarkerBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00018B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000bJ \u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\u00172\n\u0010*\u001a\u00060\u0010R\u00020\u0011H\u0002J\u0018\u0010+\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0002J\"\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010*\u001a\u00060\u0010R\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010/\u001a\u00020\"J\u0014\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u0000010\nH$J$\u00102\u001a\u00020\"2\n\u0010*\u001a\u00060\u0010R\u00020\u00112\u0006\u00103\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H$J\u0014\u00104\u001a\u00020\u00122\n\u0010*\u001a\u00060\u0010R\u00020\u0011H\u0002J\u0018\u00105\u001a\b\u0018\u00010\u0010R\u00020\u00112\n\u0010*\u001a\u00060\u0010R\u00020\u0011J\b\u00106\u001a\u00020\"H\u0002J\u0014\u00107\u001a\u00020\"2\n\u0010*\u001a\u00060\u0010R\u00020\u0011H$R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0018\u0012\b\u0012\u00060\u0010R\u00020\u0011\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00028\u0000X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010 \u00a8\u00069"}, d2={"Lorg/intellij/markdown/parser/MarkerProcessor;", "T", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "startConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "NO_BLOCKS", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "getNO_BLOCKS", "()Ljava/util/List;", "interruptsParagraph", "Lkotlin/Function2;", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "", "markersStack", "", "getMarkersStack", "nextInterestingPosForExistingMarkers", "", "getStartConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "stateInfo", "getStateInfo", "()Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "topBlockConstraints", "getTopBlockConstraints", "setTopBlockConstraints", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "addNewMarkerBlock", "", "newMarkerBlock", "applyProcessingResult", "index", "markerBlock", "processingResult", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "calculateNextPosForExistingMarkers", "pos", "closeChildren", "childrenAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "createNewMarkerBlocks", "flushMarkers", "getMarkerBlockProviders", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "populateConstraintsTokens", "constraints", "processMarkers", "processPosition", "relaxTopConstraints", "updateStateInfo", "StateInfo", "markdown"})
public abstract class MarkerProcessor<T extends StateInfo> {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final MarkdownConstraints startConstraints;
    @NotNull
    private final List<MarkerBlock> NO_BLOCKS;
    @NotNull
    private final List<MarkerBlock> markersStack;
    @NotNull
    private MarkdownConstraints topBlockConstraints;
    private int nextInterestingPosForExistingMarkers;
    @NotNull
    private final Function2<LookaheadText.Position, MarkdownConstraints, Boolean> interruptsParagraph;

    public MarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints startConstraints) {
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)startConstraints, (String)"startConstraints");
        this.productionHolder = productionHolder;
        this.startConstraints = startConstraints;
        this.NO_BLOCKS = CollectionsKt.emptyList();
        this.markersStack = new ArrayList();
        this.topBlockConstraints = this.startConstraints;
        this.nextInterestingPosForExistingMarkers = -1;
        this.interruptsParagraph = (Function2)new Function2<LookaheadText.Position, MarkdownConstraints, Boolean>(this){
            final /* synthetic */ MarkerProcessor<T> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull LookaheadText.Position position, @NotNull MarkdownConstraints constraints) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
                boolean result2 = false;
                for (MarkerBlockProvider<T> provider : this.this$0.getMarkerBlockProviders()) {
                    if (!provider.interruptsParagraph(position, constraints)) continue;
                    result2 = true;
                    break;
                }
                return result2;
            }
        };
    }

    @NotNull
    protected final MarkdownConstraints getStartConstraints() {
        return this.startConstraints;
    }

    @NotNull
    protected final List<MarkerBlock> getNO_BLOCKS() {
        return this.NO_BLOCKS;
    }

    @NotNull
    protected final List<MarkerBlock> getMarkersStack() {
        return this.markersStack;
    }

    @NotNull
    protected final MarkdownConstraints getTopBlockConstraints() {
        return this.topBlockConstraints;
    }

    protected final void setTopBlockConstraints(@NotNull MarkdownConstraints markdownConstraints) {
        Intrinsics.checkNotNullParameter((Object)markdownConstraints, (String)"<set-?>");
        this.topBlockConstraints = markdownConstraints;
    }

    @NotNull
    protected abstract T getStateInfo();

    @NotNull
    protected abstract List<MarkerBlockProvider<T>> getMarkerBlockProviders();

    protected abstract void updateStateInfo(@NotNull LookaheadText.Position var1);

    protected abstract void populateConstraintsTokens(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2, @NotNull ProductionHolder var3);

    @NotNull
    public List<MarkerBlock> createNewMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Compat compat = Compat.INSTANCE;
        boolean bl = MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints());
        boolean $i$f$assert = false;
        if (!bl) {
            String string;
            String string2 = string = "";
            throw new MarkdownParsingException(string2);
        }
        for (MarkerBlockProvider markerBlockProvider : this.getMarkerBlockProviders()) {
            List<MarkerBlock> list = markerBlockProvider.createMarkerBlocks(pos, productionHolder, this.getStateInfo());
            Collection collection = list;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            return list;
        }
        if (pos.getOffsetInCurrentLine() >= MarkdownConstraintsKt.getCharsEaten(((StateInfo)this.getStateInfo()).getNextConstraints(), pos.getCurrentLine()) && pos.charsToNonWhitespace() != null) {
            return CollectionsKt.listOf((Object)new ParagraphMarkerBlock(((StateInfo)this.getStateInfo()).getCurrentConstraints(), productionHolder.mark(), this.interruptsParagraph));
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final LookaheadText.Position processPosition(@NotNull LookaheadText.Position pos) {
        int delta;
        MarkerBlock markerBlock;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.updateStateInfo(pos);
        boolean shouldRecalcNextPos = false;
        if (pos.getOffset() >= this.nextInterestingPosForExistingMarkers) {
            this.processMarkers(pos);
            shouldRecalcNextPos = true;
        }
        if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints()) && !((markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack)) == null ? false : !markerBlock.allowsSubBlocks())) {
            List<MarkerBlock> newMarkerBlocks = this.createNewMarkerBlocks(pos, this.productionHolder);
            for (MarkerBlock newMarkerBlock : newMarkerBlocks) {
                this.addNewMarkerBlock(newMarkerBlock);
                shouldRecalcNextPos = true;
            }
        }
        if (shouldRecalcNextPos) {
            this.nextInterestingPosForExistingMarkers = this.calculateNextPosForExistingMarkers(pos);
        }
        if ((pos.getOffsetInCurrentLine() == -1 || MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) && (delta = MarkdownConstraintsKt.getCharsEaten(((StateInfo)this.getStateInfo()).getNextConstraints(), pos.getCurrentLine()) - pos.getOffsetInCurrentLine()) > 0) {
            if (pos.getOffsetInCurrentLine() != -1 && ((StateInfo)this.getStateInfo()).getNextConstraints().getIndent() <= this.topBlockConstraints.getIndent()) {
                this.populateConstraintsTokens(pos, ((StateInfo)this.getStateInfo()).getNextConstraints(), this.productionHolder);
            }
            return pos.nextPosition(delta);
        }
        return pos.nextPosition(this.nextInterestingPosForExistingMarkers - pos.getOffset());
    }

    private final int calculateNextPosForExistingMarkers(LookaheadText.Position pos) {
        MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        Integer n = markerBlock == null ? null : Integer.valueOf(markerBlock.getNextInterestingOffset(pos));
        int result2 = n == null ? pos.getNextLineOrEofOffset() : n.intValue();
        return result2 == -1 ? Integer.MAX_VALUE : result2;
    }

    public final void addNewMarkerBlock(@NotNull MarkerBlock newMarkerBlock) {
        Intrinsics.checkNotNullParameter((Object)newMarkerBlock, (String)"newMarkerBlock");
        this.markersStack.add(newMarkerBlock);
        this.relaxTopConstraints();
    }

    public final void flushMarkers() {
        this.closeChildren(-1, MarkerBlock.ClosingAction.DEFAULT);
    }

    private final boolean processMarkers(LookaheadText.Position pos) {
        int index = this.markersStack.size();
        while (index > 0) {
            MarkerBlock markerBlock;
            MarkerBlock.ProcessingResult processingResult;
            int n = index;
            if ((index = n + -1) >= this.markersStack.size() || Intrinsics.areEqual((Object)(processingResult = (markerBlock = this.markersStack.get(index)).processToken(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())), (Object)MarkerBlock.ProcessingResult.Companion.getPASS())) continue;
            this.applyProcessingResult(index, markerBlock, processingResult);
            if (processingResult.getEventAction() != MarkerBlock.EventAction.CANCEL) continue;
            return true;
        }
        return false;
    }

    private final void applyProcessingResult(int index, MarkerBlock markerBlock, MarkerBlock.ProcessingResult processingResult) {
        this.closeChildren(index, processingResult.getChildrenAction());
        if (markerBlock.acceptAction(processingResult.getSelfAction())) {
            this.markersStack.remove(index);
            this.relaxTopConstraints();
        }
    }

    private final void closeChildren(int index, MarkerBlock.ClosingAction childrenAction) {
        if (childrenAction != MarkerBlock.ClosingAction.NOTHING) {
            for (int latterIndex = this.markersStack.size() - 1; latterIndex > index; --latterIndex) {
                boolean result2 = this.markersStack.get(latterIndex).acceptAction(childrenAction);
                Compat this_$iv = Compat.INSTANCE;
                boolean $i$f$assert = false;
                if (!result2) {
                    String string;
                    boolean bl = false;
                    String string2 = string = "If closing action is not NOTHING, marker should be gone";
                    throw new MarkdownParsingException(string2);
                }
                this.markersStack.remove(latterIndex);
            }
            this.relaxTopConstraints();
        }
    }

    private final void relaxTopConstraints() {
        this.topBlockConstraints = this.markersStack.isEmpty() ? this.startConstraints : ((MarkerBlock)CollectionsKt.last(this.markersStack)).getBlockConstraints();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "", "currentConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "nextConstraints", "markersStack", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Ljava/util/List;)V", "getCurrentConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "lastBlock", "getLastBlock", "()Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "getNextConstraints", "paragraphBlock", "Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "getParagraphBlock", "()Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "equals", "", "other", "hashCode", "", "markdown"})
    public static class StateInfo {
        @NotNull
        private final MarkdownConstraints currentConstraints;
        @NotNull
        private final MarkdownConstraints nextConstraints;
        @NotNull
        private final List<MarkerBlock> markersStack;

        public StateInfo(@NotNull MarkdownConstraints currentConstraints, @NotNull MarkdownConstraints nextConstraints, @NotNull List<? extends MarkerBlock> markersStack) {
            Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
            Intrinsics.checkNotNullParameter((Object)nextConstraints, (String)"nextConstraints");
            Intrinsics.checkNotNullParameter(markersStack, (String)"markersStack");
            this.currentConstraints = currentConstraints;
            this.nextConstraints = nextConstraints;
            this.markersStack = markersStack;
        }

        @NotNull
        public final MarkdownConstraints getCurrentConstraints() {
            return this.currentConstraints;
        }

        @NotNull
        public final MarkdownConstraints getNextConstraints() {
            return this.nextConstraints;
        }

        @Nullable
        public final ParagraphMarkerBlock getParagraphBlock() {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.markersStack;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MarkerBlock block = (MarkerBlock)element$iv;
                    boolean bl = false;
                    if (!(block instanceof ParagraphMarkerBlock)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final MarkerBlock getLastBlock() {
            return (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        }

        public boolean equals(@Nullable Object other) {
            StateInfo stateInfo;
            StateInfo stateInfo2 = stateInfo = other instanceof StateInfo ? (StateInfo)other : null;
            if (stateInfo == null) {
                return false;
            }
            StateInfo otherStateInfo = stateInfo;
            return Intrinsics.areEqual((Object)this.currentConstraints, (Object)otherStateInfo.currentConstraints) && Intrinsics.areEqual((Object)this.nextConstraints, (Object)otherStateInfo.nextConstraints) && Intrinsics.areEqual(this.markersStack, otherStateInfo.markersStack);
        }

        public int hashCode() {
            int result2 = this.currentConstraints.hashCode();
            result2 = result2 * 37 + this.nextConstraints.hashCode();
            result2 = result2 * 37 + ((Object)this.markersStack).hashCode();
            return result2;
        }
    }
}

