/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/java/jdk/JdkAliases;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "computeAliasesForInstalledJdk", "", "", "jdkHome", "computeAliasesForJdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "computeAliasesForJdkVersion", "versionString", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nJdkChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkChunk.kt\ncom/intellij/indexing/shared/java/jdk/JdkAliases\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n10#2:103\n*S KotlinDebug\n*F\n+ 1 JdkChunk.kt\ncom/intellij/indexing/shared/java/jdk/JdkAliases\n*L\n64#1:103\n*E\n"})
public final class JdkAliases {
    @NotNull
    public static final JdkAliases INSTANCE = new JdkAliases();
    @NotNull
    private static final Logger LOG;

    private JdkAliases() {
    }

    @NotNull
    public final List<String> computeAliasesForJdk(@NotNull Sdk sdk) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        try {
            String string2 = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(sdk){
                final /* synthetic */ Sdk $sdk;
                {
                    this.$sdk = $sdk;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    return this.$sdk.getVersionString();
                }
            }));
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            string = string2;
        }
        catch (Throwable e) {
            LOG.warn("Failed to compute SDK version for: " + sdk + ". " + e.getMessage(), e);
            return CollectionsKt.emptyList();
        }
        String versionString2 = string;
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.computeAliasesForInstalledJdk(sdk.getHomePath()), (Iterable)this.computeAliasesForJdkVersion(versionString2)));
    }

    @NotNull
    public final List<String> computeAliasesForJdkVersion(@NotNull String versionString2) {
        Intrinsics.checkNotNullParameter((Object)versionString2, (String)"versionString");
        try {
            JavaVersion javaVersion = JavaVersion.tryParse((String)versionString2);
            if (javaVersion == null) {
                return CollectionsKt.emptyList();
            }
            JavaVersion version = javaVersion;
            Object[] objectArray = new String[2];
            Intrinsics.checkNotNullExpressionValue((Object)version.toFeatureMinorUpdateString(), (String)"version.toFeatureMinorUpdateString()");
            Intrinsics.checkNotNullExpressionValue((Object)version.toFeatureString(), (String)"version.toFeatureString()");
            return CollectionsKt.listOf((Object[])objectArray);
        }
        catch (Throwable e) {
            LOG.warn("Failed to compute aliases for: " + versionString2 + ". " + e.getMessage(), e);
            return CollectionsKt.emptyList();
        }
    }

    private final List<String> computeAliasesForInstalledJdk(String jdkHome) {
        if (jdkHome == null) {
            return CollectionsKt.emptyList();
        }
        try {
            Object object = JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(jdkHome);
            if (object == null || (object = object.getSharedIndexAliases()) == null) {
                return CollectionsKt.emptyList();
            }
            return object;
        }
        catch (Throwable e) {
            LOG.warn("Failed to get installed JDK aliases for: " + jdkHome + ". " + e.getMessage(), e);
            return CollectionsKt.emptyList();
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JdkAliases.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

