/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.FileReader;
import com.intellij.util.io.CountingInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/PlainTextFileReader;", "Lcom/intellij/profiler/FileReader;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "countingStream", "Lcom/intellij/util/io/CountingInputStream;", "fileSize", "", "createReader", "Ljava/io/BufferedReader;", "progressFraction", "withProgressFraction", "", "intellij.profiler.common"})
public final class PlainTextFileReader
extends FileReader {
    @NotNull
    private final CountingInputStream countingStream;
    private final double fileSize;

    public PlainTextFileReader(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.countingStream = new CountingInputStream((InputStream)new FileInputStream(file));
        this.fileSize = file.length();
    }

    @Override
    @NotNull
    protected BufferedReader createReader() {
        InputStream inputStream = (InputStream)this.countingStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }

    @Override
    protected boolean withProgressFraction() {
        return true;
    }

    @Override
    protected double progressFraction() {
        return (double)this.countingStream.getBytesRead() / this.fileSize;
    }
}

