/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.parser.panels;

import com.fasterxml.jackson.core.JsonParseException;
import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.eventtrace.exception.IncompleteDurationEventException;
import com.intellij.profiler.eventtrace.exception.IncorrectTimeSequenceExceptions;
import com.intellij.profiler.eventtrace.exception.TraceEventBuildTreeException;
import com.intellij.profiler.eventtrace.exception.TraceEventFormatException;
import com.intellij.profiler.eventtrace.intervals.ColorizeTimelineInterval;
import com.intellij.profiler.eventtrace.intervals.TraceLineIntervalEvent;
import com.intellij.profiler.eventtrace.parser.events.TraceEventParser;
import com.intellij.profiler.eventtrace.parser.panels.EventTraceTimelineModel;
import com.intellij.profiler.eventtrace.parser.panels.TextDefaultTimelineCellRenderer;
import com.intellij.profiler.eventtrace.parser.panels.TimelineTimeConverter;
import com.intellij.profiler.eventtrace.parser.panels.TraceEventPanel;
import com.intellij.profiler.eventtrace.parser.panels.TraceEventTimeLinePanelKt;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelinePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0019\u0010\u0017\u001a\u00070\t\u00a2\u0006\u0002\b\n2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventTimeLinePanel;", "Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel;", "Lcom/intellij/profiler/eventtrace/parser/panels/EventTraceTimelineModel;", "()V", "getExceptionPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "icon", "Ljavax/swing/Icon;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "getPanel", "Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel$PanelWithStatus;", "model", "filter", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "result", "Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel$ReloadResult;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getTextOfException", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nTraceEventTimeLinePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceEventTimeLinePanel.kt\ncom/intellij/profiler/eventtrace/parser/panels/TraceEventTimeLinePanel\n+ 2 layout.kt\ncom/intellij/ui/layout/LayoutKt\n*L\n1#1,153:1\n24#2,9:154\n*S KotlinDebug\n*F\n+ 1 TraceEventTimeLinePanel.kt\ncom/intellij/profiler/eventtrace/parser/panels/TraceEventTimeLinePanel\n*L\n81#1:154,9\n*E\n"})
public final class TraceEventTimeLinePanel
extends TraceEventPanel<EventTraceTimelineModel> {
    @Override
    @NotNull
    public TraceEventPanel.PanelWithStatus getPanel(@NotNull EventTraceTimelineModel model2, @Nullable Filter filter, @NotNull Project project) {
        LayoutBuilder builder$iv;
        OnePixelSplitter onePixelSplitter;
        TimelinePanel timelinePanel2;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TimelinePanel $this$getPanel_u24lambda_u240 = timelinePanel2 = new TimelinePanel(model2, null, null, 6, null);
        boolean bl = false;
        $this$getPanel_u24lambda_u240.setTimelineRenderer(new TextDefaultTimelineCellRenderer<DefaultMutableTreeNode, TraceLineIntervalEvent>(){

            @NotNull
            public JBColor getBackground(@NotNull TimelineComponent<?, TraceLineIntervalEvent> panel2, @NotNull TimelineModel.TimelineInterval<TraceLineIntervalEvent> node2) {
                JBColor jBColor;
                Intrinsics.checkNotNullParameter(panel2, (String)"panel");
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                if (node2 instanceof ColorizeTimelineInterval && ((ColorizeTimelineInterval)node2).getColor() != null) {
                    JBColor jBColor2 = ((ColorizeTimelineInterval)node2).getColor();
                    jBColor = jBColor2;
                    Intrinsics.checkNotNull((Object)jBColor2);
                } else {
                    jBColor = new JBColor(0xDBDBDB, 0xA3A3A3);
                }
                return jBColor;
            }
        });
        $this$getPanel_u24lambda_u240.getChart().setTimeFormatter(new TimelineTimeConverter($this$getPanel_u24lambda_u240.getRange(), model2.getTimeUnit()));
        $this$getPanel_u24lambda_u240.setRootVisible(model2.getRoot().getChildCount() == 0 && ((CharSequence)model2.getRoot().getUserObject().toString()).length() > 0);
        TimelinePanel timelinePanel3 = timelinePanel2;
        timelinePanel3.setPreferredSize(new Dimension(2400, 800));
        timelinePanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.no.event.selected.hover.and.select.event", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"JBPanelWithEmptyText().w\u2026hover.and.select.event\"))");
        JBPanelWithEmptyText label = jBPanelWithEmptyText;
        JBScrollPane scroll2 = new JBScrollPane((Component)label, 20, 31);
        scroll2.setPreferredSize(new Dimension(600, 800));
        scroll2.putClientProperty(DialogWrapper.DIALOG_CONTENT_PANEL_PROPERTY, (Object)true);
        scroll2.setBorder((Border)new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        OnePixelSplitter $this$getPanel_u24lambda_u241 = onePixelSplitter = new OnePixelSplitter(false, 0.8f, 0.4f, 0.95f);
        boolean bl2 = false;
        $this$getPanel_u24lambda_u241.setFirstComponent((JComponent)((Object)timelinePanel3));
        $this$getPanel_u24lambda_u241.setSecondComponent((JComponent)scroll2);
        OnePixelSplitter onePixelSplitter2 = onePixelSplitter;
        timelinePanel3.getChart().addMouseListener(new TraceEventParser.LineMouseListener(timelinePanel3, onePixelSplitter2, this.getHyperLinkListenerGetter(filter, project), filter));
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$getPanel_u24lambda_u242 = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl3 = false;
        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$getPanel_u24lambda_u242), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(onePixelSplitter2){
            final /* synthetic */ OnePixelSplitter $onePixelSplitter;
            {
                this.$onePixelSplitter = $onePixelSplitter;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)this.$onePixelSplitter), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        UIUtil.applyDeprecatedBackground((JComponent)((JComponent)panel$iv));
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        TraceEventPanel.PanelWithStatus.Status status = TraceEventPanel.PanelWithStatus.Status.NORMAL;
        DialogPanel dialogPanel = panel$iv;
        return new TraceEventPanel.PanelWithStatus(dialogPanel, status);
    }

    private final String getTextOfException(Exception e) {
        String string;
        Exception exception = e;
        if (exception instanceof IncorrectTimeSequenceExceptions) {
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.error.incorrect.time", new Object[0]);
        } else if (exception instanceof IncompleteDurationEventException) {
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.error.incomplete.event", new Object[0]);
        } else if (exception instanceof TraceEventBuildTreeException) {
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.error.tree.on.parsing", new Object[0]);
        } else if (exception instanceof TraceEventFormatException) {
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.error.format.on.parsing", new Object[0]);
        } else if (exception instanceof JsonParseException) {
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.error.on.parsing", new Object[0]);
        } else if (exception instanceof IOException) {
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.error.on.reading", new Object[0]);
        } else {
            TraceEventTimeLinePanelKt.getLogger().error((Throwable)e);
            string = CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.label.get.something.wrong.on.showing", new Object[0]);
        }
        return string;
    }

    private final DialogPanel getExceptionPanel(Icon icon, String text2) {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(text2, icon){
            final /* synthetic */ String $text;
            final /* synthetic */ Icon $icon;
            {
                this.$text = $text;
                this.$icon = $icon;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<com.intellij.ui.dsl.builder.Row, Unit>(this.$text, this.$icon){
                    final /* synthetic */ String $text;
                    final /* synthetic */ Icon $icon;
                    {
                        this.$text = $text;
                        this.$icon = $icon;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull com.intellij.ui.dsl.builder.Row $this$row) {
                        void $this$count$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        com.intellij.ui.dsl.builder.Cell labelText = $this$row.label(this.$text);
                        ((JLabel)labelText.getComponent()).setFont(((JLabel)labelText.getComponent()).getFont().deriveFont((float)(1.3333333333333333 * (double)((JLabel)labelText.getComponent()).getFont().getSize())));
                        FontRenderContext fontRendererContext = new FontRenderContext(new AffineTransform(), true, true);
                        Rectangle2D stringBounds = ((JLabel)labelText.getComponent()).getFont().getStringBounds(this.$text, fontRendererContext);
                        CharSequence charSequence = this.$text;
                        int n = ((CharSequence)this.$text).length() == 0 ? ((JLabel)labelText.getComponent()).getFont().getSize() : (int)stringBounds.getHeight();
                        boolean $i$f$count = false;
                        int count$iv = 0;
                        for (int i = 0; i < $this$count$iv.length(); ++i) {
                            char element$iv;
                            char it = element$iv = $this$count$iv.charAt(i);
                            boolean bl = false;
                            if (!(it == '\n')) continue;
                            ++count$iv;
                        }
                        int n2 = count$iv;
                        int height = n * (n2 + 1);
                        Icon resizedIcon = IconUtil.resizeSquared((Icon)this.$icon, (int)height);
                        labelText.applyToComponent((Function1)new Function1<JLabel, Unit>(resizedIcon){
                            final /* synthetic */ Icon $resizedIcon;
                            {
                                this.$resizedIcon = $resizedIcon;
                                super(1);
                            }

                            public final void invoke(@NotNull JLabel $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.setIcon(this.$resizedIcon);
                            }
                        }).align(Align.CENTER);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    @Override
    @NotNull
    public TraceEventPanel.PanelWithStatus getPanel(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Icon icon = AllIcons.General.BalloonError;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonError");
        return new TraceEventPanel.PanelWithStatus(this.getExceptionPanel(icon, this.getTextOfException(e)), TraceEventPanel.PanelWithStatus.Status.EXCEPTION);
    }

    @Override
    @Nullable
    public TraceEventPanel.PanelWithStatus getPanel(@NotNull TraceEventPanel.ReloadResult<EventTraceTimelineModel> result2, @Nullable Filter filter, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TraceEventPanel.PanelWithStatus panel2 = null;
        if (result2.getModel() != null) {
            panel2 = this.getPanel(result2.getModel(), filter, project);
        }
        if (result2.getException() != null) {
            panel2 = this.getPanel(result2.getException());
        }
        return panel2;
    }
}

