/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.profiler.ui.ProfilerColors;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0004J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/ProfilerColors;", "", "()V", "color", "Ljava/awt/Color;", "name", "", "colorProvider", "Lkotlin/Function0;", "Lcom/intellij/ui/JBColor;", "rgb", "darkRGB", "hcRGB", "", "exact", "propertyName", "intellij.profiler.common"})
public abstract class ProfilerColors {
    @NotNull
    protected final Color color(@NotNull String name, int rgb, int darkRGB, int hcRGB) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.color(name, new Color(rgb), new Color(darkRGB), new Color(hcRGB));
    }

    @NotNull
    protected final Color color(@NotNull String name, @NotNull Color rgb, @NotNull Color darkRGB, @NotNull Color hcRGB) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        Intrinsics.checkNotNullParameter((Object)darkRGB, (String)"darkRGB");
        Intrinsics.checkNotNullParameter((Object)hcRGB, (String)"hcRGB");
        return this.color(name, (Function0<? extends JBColor>)((Function0)new Function0<JBColor>(rgb, hcRGB, darkRGB){
            final /* synthetic */ Color $rgb;
            final /* synthetic */ Color $hcRGB;
            final /* synthetic */ Color $darkRGB;
            {
                this.$rgb = $rgb;
                this.$hcRGB = $hcRGB;
                this.$darkRGB = $darkRGB;
                super(0);
            }

            @NotNull
            public final JBColor invoke() {
                JBColor jBColor = JBColor.lazy(() -> color.1.invoke$lambda$0(this.$rgb, this.$hcRGB, this.$darkRGB));
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy {\n        when {\n  \u2026darkRGB\n        }\n      }");
                return jBColor;
            }

            private static final Color invoke$lambda$0(Color $rgb, Color $hcRGB, Color $darkRGB) {
                Color color2;
                Intrinsics.checkNotNullParameter((Object)$rgb, (String)"$rgb");
                Intrinsics.checkNotNullParameter((Object)$hcRGB, (String)"$hcRGB");
                Intrinsics.checkNotNullParameter((Object)$darkRGB, (String)"$darkRGB");
                if (JBColor.isBright()) {
                    color2 = $rgb;
                } else {
                    UIManager.LookAndFeelInfo lookAndFeelInfo = LafManager.getInstance().getCurrentLookAndFeel();
                    color2 = Intrinsics.areEqual((Object)(lookAndFeelInfo != null ? lookAndFeelInfo.getName() : null), (Object)"High contrast") ? $hcRGB : $darkRGB;
                }
                return color2;
            }
        }));
    }

    private final Color color(String name, Function0<? extends JBColor> colorProvider) {
        Color color2;
        Color color3 = UIManager.getColor(name);
        if (color3 == null) {
            Object object = colorProvider.invoke();
            JBColor it = (JBColor)object;
            boolean bl = false;
            UIManager.put(name, it);
            color2 = (Color)object;
        } else {
            color2 = color3;
        }
        return color2;
    }

    @NotNull
    protected final JBColor exact(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JBColor jBColor = JBColor.namedColor((String)propertyName);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(propertyName)");
        return jBColor;
    }
}

