/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0016\u0010!\u001a\u00020\f*\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0004R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "()V", "associatedObjectKeyMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "Lkotlin/collections/HashMap;", "getAssociatedObjectKey", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "toJsName", "", "temporary", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrNamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrNamer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,86:1\n372#2,7:87\n*S KotlinDebug\n*F\n+ 1 IrNamer.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase\n*L\n82#1:87,7\n*E\n"})
public abstract class IrNamerBase
implements IrNamer {
    @NotNull
    private final HashMap<IrClass, Integer> associatedObjectKeyMap = new HashMap();

    @Override
    @NotNull
    public abstract JsName getNameForMemberFunction(@NotNull IrSimpleFunction var1);

    @Override
    @NotNull
    public abstract JsName getNameForMemberField(@NotNull IrField var1);

    @Override
    @NotNull
    public abstract JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName var1);

    @NotNull
    protected final JsName toJsName(@NotNull String $this$toJsName, boolean temporary) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsName, (String)"<this>");
        return new JsName($this$toJsName, temporary);
    }

    public static /* synthetic */ JsName toJsName$default(IrNamerBase irNamerBase, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toJsName");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return irNamerBase.toJsName(string2, bl);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.getNameForStaticDeclaration((IrDeclarationWithName)function2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return field.isStatic() || field.getParent() instanceof IrScript ? this.getNameForStaticDeclaration((IrDeclarationWithName)field) : this.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        return this.getNameForStaticDeclaration((IrDeclarationWithName)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)constructor)));
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.getNameForStaticDeclaration((IrDeclarationWithName)klass);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        IrDeclarationParent parent2 = klass.getParent();
        if (klass.isCompanion()) {
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            return this.getRefForExternalClass((IrClass)parent2);
        }
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)klass).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        String currentClassName = string2;
        IrDeclarationParent irDeclarationParent = parent2;
        if (irDeclarationParent instanceof IrClass) {
            jsNameRef = new JsNameRef(currentClassName, (JsExpression)this.getRefForExternalClass((IrClass)parent2));
        } else if (irDeclarationParent instanceof IrPackageFragment) {
            JsNameRef jsNameRef2 = this.getNameForStaticDeclaration((IrDeclarationWithName)klass).makeRef();
            Intrinsics.checkNotNull((Object)jsNameRef2);
            jsNameRef = jsNameRef2;
        } else {
            throw new IllegalStateException(("Unsupported external class parent " + parent2).toString());
        }
        return jsNameRef;
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (property.getParent() instanceof IrClass) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)property).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            jsName = IrNamerBase.toJsName$default(this, string2, false, 1, null);
        } else {
            jsName = this.getNameForStaticDeclaration((IrDeclarationWithName)property);
        }
        return jsName;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (AnnotationUtilsKt.isAssociatedObjectAnnotatedAnnotation(irClass)) {
            Object object;
            Map $this$getOrPut$iv = this.associatedObjectKeyMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(irClass);
            if (value$iv == null) {
                boolean bl = false;
                Integer answer$iv = this.associatedObjectKeyMap.size();
                $this$getOrPut$iv.put(irClass, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (Integer)object;
        }
        return null;
    }
}

