/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.server.Maven3ModelConverter;
import org.jetbrains.idea.maven.server.MavenServerEmbeddedBase;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.Maven3ExecutionResult;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.jetbrains.idea.maven.server.utils.Maven3ResolverUtil;

public abstract class Maven3ServerEmbedder
extends MavenServerEmbeddedBase {
    public static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    private static final String MAVEN_VERSION = System.getProperty("idea.maven.embedder.version");
    protected final MavenServerSettings myServerSettings;

    protected Maven3ServerEmbedder(MavenServerSettings settings) {
        this.myServerSettings = settings;
        Maven3ServerEmbedder.initLogging(this.myServerSettings);
    }

    private static void initLogging(MavenServerSettings settings) {
        try {
            Level rootLoggerLevel = Maven3ServerEmbedder.toJavaUtilLoggingLevel(settings.getLoggingLevel());
            Logger.getLogger("").setLevel(rootLoggerLevel);
            if (rootLoggerLevel.intValue() < Level.SEVERE.intValue()) {
                Logger.getLogger("org.apache.maven.wagon.providers.http.httpclient.wire").setLevel(Level.SEVERE);
                Logger.getLogger("org.apache.http.wire").setLevel(Level.SEVERE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level toJavaUtilLoggingLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 3: {
                return Level.SEVERE;
            }
            case 4: {
                return Level.SEVERE;
            }
            case 5: {
                return Level.OFF;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARNING;
            }
        }
        return Level.INFO;
    }

    protected abstract ArtifactRepository getLocalRepository();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        List<Object> buildingResults;
        block13: {
            if (request == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(0);
            }
            if (files == null) {
                Maven3ServerEmbedder.$$$reportNull$$$0(1);
            }
            ProjectBuilder builder = this.getComponent(ProjectBuilder.class);
            ModelInterpolator modelInterpolator = this.getComponent(ModelInterpolator.class);
            String savedLocalRepository = null;
            if (modelInterpolator instanceof CustomMaven3ModelInterpolator2) {
                CustomMaven3ModelInterpolator2 customMaven3ModelInterpolator2 = (CustomMaven3ModelInterpolator2)modelInterpolator;
                savedLocalRepository = customMaven3ModelInterpolator2.getLocalRepository();
                customMaven3ModelInterpolator2.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
            }
            buildingResults = new ArrayList<ProjectBuildingResult>();
            ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
            projectBuildingRequest.setValidationLevel(0);
            projectBuildingRequest.setResolveDependencies(false);
            try {
                if (files.size() == 1) {
                    this.buildSinglePom(builder, buildingResults, projectBuildingRequest, files.iterator().next());
                    break block13;
                }
                try {
                    buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
                }
                catch (ProjectBuildingException e) {
                    for (ProjectBuildingResult result : e.getResults()) {
                        if (result.getProject() != null) {
                            buildingResults.add(result);
                            continue;
                        }
                        this.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                    }
                }
            }
            finally {
                if (modelInterpolator instanceof CustomMaven3ModelInterpolator2 && savedLocalRepository != null) {
                    ((CustomMaven3ModelInterpolator2)modelInterpolator).setLocalRepository(savedLocalRepository);
                }
            }
        }
        List<Object> list = buildingResults;
        if (list == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(2);
        }
        return list;
    }

    private void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            Maven3ResolverUtil.handleProjectBuildingException(buildingResults, e);
        }
    }

    protected Maven3ExecutionResult resolveMvn2CompatResult(MavenProject project, List<Exception> exceptions, List<ResolutionListener> listeners, ArtifactRepository localRepository) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest();
        resolutionRequest.setArtifactDependencies(project.getDependencyArtifacts());
        resolutionRequest.setArtifact(project.getArtifact());
        resolutionRequest.setManagedVersionMap(project.getManagedVersionMap());
        resolutionRequest.setLocalRepository(localRepository);
        resolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        resolutionRequest.setListeners(listeners);
        resolutionRequest.setResolveRoot(false);
        resolutionRequest.setResolveTransitively(true);
        ArtifactResolver resolver = this.getComponent(ArtifactResolver.class);
        ArtifactResolutionResult result = resolver.resolve(resolutionRequest);
        project.setArtifacts(result.getArtifacts());
        return new Maven3ExecutionResult(project, exceptions);
    }

    protected void addMvn2CompatResults(MavenProject project, List<Exception> exceptions, List<ResolutionListener> listeners, ArtifactRepository localRepository, Collection<Maven3ExecutionResult> executionResults) {
        executionResults.add(this.resolveMvn2CompatResult(project, exceptions, listeners, localRepository));
    }

    @Nullable
    public MavenModel readModel(File file, MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        return null;
    }

    @NotNull
    protected abstract List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> var1) throws RemoteException;

    @NotNull
    protected List<ArtifactRepository> map2ArtifactRepositories(List<MavenRemoteRepository> repositories) {
        PlexusContainer container = this.getContainer();
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)Maven3ModelConverter.toNativeRepository(each), (ArtifactRepositoryFactory)factory, (PlexusContainer)container));
            }
            catch (InvalidRepositoryException e) {
                MavenServerGlobals.getLogger().warn((Throwable)e);
            }
        }
        ArrayList<ArtifactRepository> arrayList = result;
        if (arrayList == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public String getMavenVersion() {
        return MAVEN_VERSION;
    }

    public abstract <T> T getComponent(Class<T> var1, String var2);

    public abstract <T> T getComponent(Class<T> var1);

    public void executeWithMavenSession(MavenExecutionRequest request, Runnable runnable) {
        if (VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.2.5") >= 0) {
            this.executeWithSessionScope(request, runnable);
        } else {
            this.executeWithMavenSessionLegacy(request, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithMavenSessionLegacy(MavenExecutionRequest request, Runnable runnable) {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        MavenSession mavenSession = this.createMavenSession(request, maven);
        LegacySupport legacySupport = this.getComponent(LegacySupport.class);
        MavenSession oldSession = legacySupport.getSession();
        legacySupport.setSession(mavenSession);
        this.notifyAfterSessionStart(mavenSession);
        try {
            runnable.run();
        }
        finally {
            legacySupport.setSession(oldSession);
        }
    }

    @NotNull
    private MavenSession createMavenSession(MavenExecutionRequest request, DefaultMaven maven) {
        RepositorySystemSession repositorySession = maven.newRepositorySession(request);
        request.getProjectBuildingRequest().setRepositorySession(repositorySession);
        return new MavenSession(this.getContainer(), repositorySession, request, (MavenExecutionResult)new DefaultMavenExecutionResult());
    }

    private void notifyAfterSessionStart(MavenSession mavenSession) {
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.emptyList())) {
                listener.afterSessionStart(mavenSession);
            }
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithSessionScope(MavenExecutionRequest request, Runnable runnable) {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        SessionScope sessionScope = this.getComponent(SessionScope.class);
        sessionScope.enter();
        try {
            MavenSession mavenSession = this.createMavenSession(request, maven);
            sessionScope.seed(MavenSession.class, (Object)mavenSession);
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession oldSession = legacySupport.getSession();
            legacySupport.setSession(mavenSession);
            this.notifyAfterSessionStart(mavenSession);
            try {
                runnable.run();
            }
            finally {
                legacySupport.setSession(oldSession);
            }
        }
        finally {
            sessionScope.exit();
        }
    }

    @NotNull
    protected abstract PlexusContainer getContainer();

    public abstract MavenExecutionRequest createRequest(File var1, List<String> var2, List<String> var3) throws RemoteException;

    protected static void warn(String message, Throwable e) {
        MavenServerGlobals.getLogger().warn((Throwable)new RuntimeException(message, e));
    }

    public Set<MavenRemoteRepository> resolveRepositories(@NotNull Collection<MavenRemoteRepository> repositories, MavenToken token) throws RemoteException {
        if (repositories == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(4);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return new HashSet<MavenRemoteRepository>(Maven3ModelConverter.convertRemoteRepositories(this.convertRepositories(new ArrayList<MavenRemoteRepository>(repositories))));
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    public Collection<MavenArchetype> getLocalArchetypes(MavenToken token, @NotNull String path) throws RemoteException {
        if (path == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(5);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            ArchetypeDataSource source = this.getComponent(ArchetypeDataSource.class, "catalog");
            Properties properties = new Properties();
            properties.put("file", path);
            ArchetypeCatalog archetypeCatalog = source.getArchetypeCatalog(properties);
            return Maven3ServerEmbedder.getArchetypes(archetypeCatalog);
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            return Collections.emptyList();
        }
    }

    public Collection<MavenArchetype> getRemoteArchetypes(MavenToken token, @NotNull String url) throws RemoteException {
        if (url == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(6);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            ArchetypeDataSource source = this.getComponent(ArchetypeDataSource.class, "remote-catalog");
            Properties properties = new Properties();
            properties.put("repository", url);
            ArchetypeCatalog archetypeCatalog = source.getArchetypeCatalog(properties);
            return Maven3ServerEmbedder.getArchetypes(archetypeCatalog);
        }
        catch (ArchetypeDataSourceException e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    public Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull List<MavenRemoteRepository> repositories, @Nullable String url, MavenToken token) throws RemoteException {
        if (groupId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(7);
        }
        if (artifactId == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(8);
        }
        if (version == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(9);
        }
        if (repositories == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(10);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            MavenExecutionRequest request = this.createRequest(null, null, null);
            List<ArtifactRepository> artifactRepositories = this.map2ArtifactRepositories(repositories);
            for (ArtifactRepository repository : artifactRepositories) {
                request.addRemoteRepository(repository);
            }
            HashMap<String, String> result = new HashMap<String, String>();
            AtomicBoolean unknownArchetypeError = new AtomicBoolean(false);
            this.executeWithMavenSession(request, () -> {
                MavenArtifactRepository artifactRepository = null;
                if (url != null) {
                    artifactRepository = new MavenArtifactRepository();
                    artifactRepository.setId("archetype");
                    artifactRepository.setUrl(url);
                    artifactRepository.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
                }
                List remoteRepositories = request.getRemoteRepositories();
                ArchetypeArtifactManager archetypeArtifactManager = this.getComponent(ArchetypeArtifactManager.class);
                ArchetypeDescriptor descriptor = null;
                try {
                    descriptor = archetypeArtifactManager.getFileSetArchetypeDescriptor(groupId, artifactId, version, (ArtifactRepository)artifactRepository, this.getLocalRepository(), remoteRepositories);
                }
                catch (UnknownArchetype e) {
                    unknownArchetypeError.set(true);
                }
                if (descriptor != null && descriptor.getRequiredProperties() != null) {
                    for (RequiredProperty property : descriptor.getRequiredProperties()) {
                        result.put(property.getKey(), property.getDefaultValue() != null ? property.getDefaultValue() : "");
                    }
                }
            });
            return unknownArchetypeError.get() ? null : result;
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @NotNull
    private static ArrayList<MavenArchetype> getArchetypes(ArchetypeCatalog archetypeCatalog) {
        ArrayList<MavenArchetype> result = new ArrayList<MavenArchetype>(archetypeCatalog.getArchetypes().size());
        for (Archetype each : archetypeCatalog.getArchetypes()) {
            result.add(Maven3ModelConverter.convertArchetype(each));
        }
        ArrayList<MavenArchetype> arrayList = result;
        if (arrayList == null) {
            Maven3ServerEmbedder.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.getContainer().lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven3ServerEmbedder.warn("Failed to lookup lifecycle participants", e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.getContainer().lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven3ServerEmbedder.warn("Failed to lookup lifecycle participants", e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven3ServerEmbedder";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven3ServerEmbedder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "map2ArtifactRepositories";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchetypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalArchetypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteArchetypes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

