/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.JavaTestUtil;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.ExecutionWithDebuggerToolsTestCase;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import junit.framework.AssertionFailedError;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerTestCase
extends ExecutionWithDebuggerToolsTestCase {
    protected static final int DEFAULT_ADDRESS = 3456;
    protected static final String TEST_JDK_NAME = "JDK";
    protected DebuggerSession myDebuggerSession;
    private ExecutionEnvironment myExecutionEnvironment;
    private RunProfileState myRunnableState;
    private final List<ThrowableRunnable<Throwable>> myTearDownRunnables = new ArrayList<ThrowableRunnable<Throwable>>();
    private CompilerManagerImpl myCompilerManager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (this.myDebugProcess != null) {
                this.myDebugProcess.stop(true);
                this.myDebugProcess.waitFor();
                this.myDebugProcess.dispose();
            }
        }));
        this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> EdtTestUtil.runInEdtAndWait(() -> FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles())));
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            new RunAll(this.myTearDownRunnables).run();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myTearDownRunnables.clear();
            super.tearDown();
        }
        if (this.myCompilerManager != null) {
            DebuggerTestCase.assertTrue((boolean)this.myCompilerManager.awaitNettyThreadPoolTermination(1L, TimeUnit.MINUTES));
            this.myCompilerManager = null;
        }
    }

    protected final void atDebuggerTearDown(ThrowableRunnable<Throwable> runnable) {
        this.myTearDownRunnables.add(0, runnable);
    }

    @Override
    protected void initApplication() throws Exception {
        super.initApplication();
        JavaTestUtil.setupInternalJdkAsTestJDK(this.getTestRootDisposable(), TEST_JDK_NAME);
        DebuggerSettings.getInstance().setTransport(0);
        DebuggerSettings.getInstance().SKIP_CONSTRUCTORS = false;
        DebuggerSettings.getInstance().SKIP_GETTERS = false;
        NodeRendererSettings.getInstance().getClassRenderer().SHOW_DECLARED_TYPE = true;
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            DebuggerTestCase.$$$reportNull$$$0(0);
        }
        super.runTestRunnable(testRunnable);
        if (this.getDebugProcess() != null) {
            this.getDebugProcess().getProcessHandler().startNotify();
            this.waitProcess(this.getDebugProcess().getProcessHandler());
            this.waitForCompleted();
            DebuggerTestCase.assertNull((Object)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(this.getDebugProcess().getProcessHandler()));
            this.myDebuggerSession = null;
        }
        this.throwExceptionsIfAny();
        this.checkTestOutput();
    }

    protected void checkTestOutput() throws Exception {
        this.getChecker().checkValid(this.getTestProjectJdk());
    }

    protected void disposeSession(DebuggerSession debuggerSession) {
        UIUtil.invokeAndWaitIfNeeded(() -> ((DebuggerSession)debuggerSession).dispose());
    }

    protected void createLocalProcess(String className) throws ExecutionException {
        this.createLocalProcess(this.createJavaParameters(className));
    }

    protected void createLocalProcess(JavaParameters javaParameters) throws ExecutionException {
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebuggerSession = this.createLocalProcess(0, javaParameters);
        this.myDebugProcess = this.myDebuggerSession.getProcess();
    }

    protected DebuggerSession createLocalSession(final JavaParameters javaParameters) throws ExecutionException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().setTransport(0);
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        RemoteConnection debugParameters = new RemoteConnectionBuilder(debuggerRunnerSettings.LOCAL, debuggerRunnerSettings.getTransport(), debuggerRunnerSettings.getDebugPort()).project(this.myProject).asyncAgent(true).create(javaParameters);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile((RunProfile)new MockConfiguration(this.myProject)).build();
        this.myRunnableState = new JavaCommandLineState(environment){

            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @NotNull
            protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                TargetedCommandLineBuilder targetedCommandLineBuilder = this.getJavaParameters().toCommandLine(request);
                if (targetedCommandLineBuilder == null) {
                    1.$$$reportNull$$$0(1);
                }
                return targetedCommandLineBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTargetedCommandLine";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTargetedCommandLine";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                this.myExecutionEnvironment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)new MockConfiguration(this.myProject)).build();
                DefaultDebugEnvironment debugEnvironment = new DefaultDebugEnvironment(this.myExecutionEnvironment, this.myRunnableState, debugParameters, false);
                this.myDebuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)debugEnvironment);
                XDebuggerManager.getInstance((Project)this.myProject).startSession(this.myExecutionEnvironment, new XDebugProcessStarter(){

                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        if (session == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)DebuggerTestCase.this.myDebuggerSession);
                        if (javaDebugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return javaDebugProcess;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "session";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "start";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "start";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                });
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
        this.myDebugProcess = this.myDebuggerSession.getProcess();
        this.myDebugProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DebuggerTestCase.assertNotNull((Object)this.myDebuggerSession);
        DebuggerTestCase.assertNotNull((Object)this.myDebugProcess);
        return this.myDebuggerSession;
    }

    protected int getTraceMode() {
        return 0;
    }

    protected DebuggerSession createLocalProcess(int transport, final JavaParameters javaParameters) throws ExecutionException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().setTransport(transport);
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.setLocal(true);
        debuggerRunnerSettings.setTransport(transport);
        debuggerRunnerSettings.setDebugPort(transport == 0 ? "0" : String.valueOf(3456));
        this.myExecutionEnvironment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile((RunProfile)new MockConfiguration(this.myProject)).build();
        this.myRunnableState = new JavaCommandLineState(this.myExecutionEnvironment){

            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @NotNull
            protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
                if (request == null) {
                    4.$$$reportNull$$$0(0);
                }
                TargetedCommandLineBuilder targetedCommandLineBuilder = this.getJavaParameters().toCommandLine(request);
                if (targetedCommandLineBuilder == null) {
                    4.$$$reportNull$$$0(1);
                }
                return targetedCommandLineBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTargetedCommandLine";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTargetedCommandLine";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        RemoteConnection debugParameters = new RemoteConnectionBuilder(debuggerRunnerSettings.LOCAL, debuggerRunnerSettings.getTransport(), debuggerRunnerSettings.getDebugPort()).project(this.myProject).checkValidity(true).asyncAgent(true).create(javaParameters);
        DebuggerSession debuggerSession = (DebuggerSession)UIUtil.invokeAndWaitIfNeeded(() -> {
            try {
                ExecutionEnvironment env = this.myExecutionEnvironment;
                env.putUserData((Key)DefaultDebugEnvironment.DEBUGGER_TRACE_MODE, (Object)this.getTraceMode());
                return this.attachVirtualMachine(this.myRunnableState, env, debugParameters, false);
            }
            catch (ExecutionException e) {
                throw new AssertionFailedError(e.getMessage());
            }
        });
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        debuggerSession.getProcess().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    5.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$5";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession createRemoteProcess(int transport, boolean serverMode, JavaParameters javaParameters) throws ExecutionException {
        DebuggerSession debuggerSession;
        RemoteConnection remoteConnection = new RemoteConnectionBuilder(serverMode, transport, null).suspend(true).create(javaParameters);
        GeneralCommandLine commandLine = javaParameters.toCommandLine();
        if (serverMode) {
            debuggerSession = this.attachVM(remoteConnection, false);
            commandLine.createProcess();
        } else {
            commandLine.createProcess();
            debuggerSession = this.attachVM(remoteConnection, true);
        }
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession attachVM(RemoteConnection remoteConnection, boolean pollConnection) {
        RemoteStateState remoteState = new RemoteStateState(this.myProject, remoteConnection);
        DebuggerSession[] debuggerSession = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded(() -> this.lambda$attachVM$5(debuggerSession, (RemoteState)remoteState, remoteConnection, pollConnection));
        debuggerSession[0].getProcess().getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    6.$$$reportNull$$$0(1);
                }
                DebuggerTestCase.this.print(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/DebuggerTestCase$6";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return debuggerSession[0];
    }

    protected void createBreakpoints(String className) {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
            DebuggerTestCase.assertNotNull((String)className, (Object)psiClass);
            return psiClass.getContainingFile();
        });
        this.createBreakpoints(psiFile);
    }

    protected Value evaluate(CodeFragmentKind kind, String code, EvaluationContextImpl evaluationContext) throws EvaluateException {
        WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(this.myProject, (TextWithImports)new TextWithImportsImpl(kind, code));
        watchItemDescriptor.setContext(evaluationContext);
        EvaluateException exception = watchItemDescriptor.getEvaluateException();
        if (exception != null) {
            throw exception;
        }
        return watchItemDescriptor.getValue();
    }

    protected Value evaluate(CodeFragmentKind kind, String code, SuspendContextImpl suspendContext) throws EvaluateException {
        return this.evaluate(kind, code, this.createEvaluationContext(suspendContext));
    }

    protected EvaluationContextImpl createEvaluationContext(SuspendContextImpl suspendContext) {
        try {
            StackFrameProxyImpl proxy = suspendContext.getFrameProxy();
            DebuggerTestCase.assertNotNull((Object)proxy);
            return new EvaluationContextImpl(suspendContext, proxy, (Value)proxy.thisObject());
        }
        catch (EvaluateException e) {
            this.error(e);
            return null;
        }
    }

    private void waitForCompleted() {
        final SynchronizationBasedSemaphore s = new SynchronizationBasedSemaphore();
        s.down();
        final InvokeThread.WorkerThreadRequest request = this.getDebugProcess().getManagerThread().getCurrentRequest();
        Thread thread = new Thread("Joining " + request){

            @Override
            public void run() {
                try {
                    request.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        if (request.isDone()) {
            thread.interrupt();
        }
        this.waitFor(() -> {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.invokeRatherLater(new DebuggerCommandImpl(){

            protected void action() {
                LOG.assertTrue(false);
            }

            protected void commandCancelled() {
                DebuggerTestCase.this.invokeRatherLater(new DebuggerCommandImpl(){

                    protected void action() {
                        LOG.assertTrue(false);
                    }

                    protected void commandCancelled() {
                        s.up();
                    }
                });
            }
        });
        this.waitFor(s::waitFor);
        this.myCompilerManager = (CompilerManagerImpl)CompilerManager.getInstance((Project)this.getProject());
        this.myCompilerManager.waitForExternalJavacToTerminate(1L, TimeUnit.MINUTES);
    }

    private DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext, StackFrameProxyImpl stackFrame) {
        DebuggerSession[] session = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded(() -> {
            session[0] = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getSession((DebugProcess)suspendContext.getDebugProcess());
        });
        DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext((DebuggerSession)session[0], (SuspendContextImpl)suspendContext, (ThreadReferenceProxyImpl)(stackFrame != null ? stackFrame.threadProxy() : null), (StackFrameProxyImpl)stackFrame);
        debuggerContext.initCaches();
        return debuggerContext;
    }

    public DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext) {
        return this.createDebuggerContext(suspendContext, suspendContext.getFrameProxy());
    }

    protected void printLocation(SuspendContextImpl suspendContext) {
        try {
            Location location = suspendContext.getFrameProxy().location();
            String message = "paused at " + location.sourceName() + ":" + location.lineNumber();
            this.println(message, ProcessOutputTypes.SYSTEM);
        }
        catch (Throwable e) {
            this.addException(e);
        }
    }

    protected void createBreakpointInHelloWorld() {
        DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("HelloWorld", GlobalSearchScope.allScope((Project)this.myProject));
            DebuggerTestCase.assertNotNull((Object)psiClass);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiClass.getContainingFile());
            DebuggerTestCase.assertNotNull((Object)breakpointManager.addLineBreakpoint(document, 3));
        }, (ModalityState)ApplicationManager.getApplication().getDefaultModalityState());
    }

    protected void createHelloWorldProcessWithBreakpoint() throws ExecutionException {
        this.createLocalProcess("HelloWorld");
        this.createBreakpointInHelloWorld();
    }

    @Override
    protected DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    public RunProfileState getRunnableState() {
        return this.myRunnableState;
    }

    protected DebuggerSession attachVirtualMachine(RunProfileState state, ExecutionEnvironment environment, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection));
        XDebuggerManager.getInstance((Project)this.myProject).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    9.$$$reportNull$$$0(0);
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)debuggerSession);
                if (javaDebugProcess == null) {
                    9.$$$reportNull$$$0(1);
                }
                return javaDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$9";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        return debuggerSession;
    }

    protected void disableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, false);
    }

    protected void enableRenderer(NodeRenderer renderer) {
        this.setRendererEnabled(renderer, true);
    }

    private void setRendererEnabled(NodeRenderer renderer, boolean state) {
        boolean oldValue = renderer.isEnabled();
        if (oldValue != state) {
            this.atDebuggerTearDown((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> renderer.setEnabled(oldValue)));
            renderer.setEnabled(state);
        }
    }

    protected void doWhenXSessionPausedThenResume(final ThrowableRunnable runnable) {
        final XDebugSession session = this.getDebuggerSession().getXDebugSession();
        DebuggerTestCase.assertNotNull((Object)session);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        DebuggerTestCase.this.addException(e);
                    }
                    finally {
                        SwingUtilities.invokeLater(() -> ((XDebugSession)session).resume());
                    }
                });
            }
        });
    }

    private /* synthetic */ void lambda$attachVM$5(DebuggerSession[] debuggerSession, RemoteState remoteState, RemoteConnection remoteConnection, boolean pollConnection) {
        try {
            ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)new MockConfiguration(this.myProject)).build();
            debuggerSession[0] = this.attachVirtualMachine((RunProfileState)remoteState, environment, remoteConnection, pollConnection);
        }
        catch (ExecutionException e) {
            DebuggerTestCase.fail((String)e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnable", "com/intellij/debugger/DebuggerTestCase", "runTestRunnable"));
    }

    public class MockConfiguration
    implements ModuleRunConfiguration {
        private final Project project;

        public MockConfiguration(Project project2) {
            this.project = project2;
        }

        public Module @NotNull [] getModules() {
            Module[] moduleArray;
            if (DebuggerTestCase.this.myModule == null) {
                moduleArray = Module.EMPTY_ARRAY;
            } else {
                Module[] moduleArray2 = new Module[1];
                moduleArray = moduleArray2;
                moduleArray2[0] = DebuggerTestCase.this.myModule;
            }
            if (moduleArray == null) {
                MockConfiguration.$$$reportNull$$$0(0);
            }
            return moduleArray;
        }

        public Icon getIcon() {
            return null;
        }

        public ConfigurationFactory getFactory() {
            return UnknownConfigurationType.getInstance();
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                MockConfiguration.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            throw new UnsupportedOperationException();
        }

        public Project getProject() {
            return this.project;
        }

        public RunConfiguration clone() {
            return null;
        }

        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
            if (executor == null) {
                MockConfiguration.$$$reportNull$$$0(2);
            }
            if (env == null) {
                MockConfiguration.$$$reportNull$$$0(3);
            }
            return null;
        }

        @NotNull
        public String getName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/DebuggerTestCase$MockConfiguration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/DebuggerTestCase$MockConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

