/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.values;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.values.MockPrimitiveValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Type;

public class MockIntegerValue
extends MockPrimitiveValue
implements IntegerValue {
    private final int myValue;

    public MockIntegerValue(MockVirtualMachine virtualMachine, int value) {
        super(virtualMachine);
        this.myValue = value;
    }

    @Override
    public Object getValue() {
        return this.value();
    }

    @Override
    public int intValue() {
        return this.myValue;
    }

    @Override
    public long longValue() {
        return this.myValue;
    }

    @Override
    public Type type() {
        return MockType.createType(this.myVirtualMachine, Integer.TYPE);
    }

    @Override
    public int value() {
        return this.myValue;
    }

    @Override
    public int compareTo(IntegerValue o) {
        return Integer.compare(this.value(), o.value());
    }
}

