/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.toolwindow.preview;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.problems.vulnerabilities.CallToAction;
import org.jetbrains.security.service.PackageStatus;
import org.jetbrains.security.service.Vulnerable;
import org.jetbrains.security.toolwindow.preview.PackageHtmlRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0003J\u0010\u0010\u000f\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/security/toolwindow/preview/PackageTitlePanel;", "Lcom/intellij/ui/components/JBPanel;", "packageStatus", "Lorg/jetbrains/security/service/PackageStatus;", "(Lorg/jetbrains/security/service/PackageStatus;)V", "call2actionPanel", "Ljavax/swing/JEditorPane;", "copyRightPanel", "packageLabel", "copySafeVersionToClipboard", "", "urlDescription", "", "packageText", "pkgStatus", "setPackageStatus", "titleText", "intellij.packageChecker"})
public final class PackageTitlePanel
extends JBPanel<PackageTitlePanel> {
    @NotNull
    private final JEditorPane packageLabel;
    @NotNull
    private final JEditorPane call2actionPanel;
    @NlsSafe
    @NotNull
    private final JEditorPane copyRightPanel;

    public PackageTitlePanel(@Nullable PackageStatus packageStatus) {
        super((LayoutManager)new GridBagLayout());
        this.packageLabel = ComponentsKt.htmlComponent$default((String)this.packageText(packageStatus), (Font)((Font)JBFont.label()), null, null, (boolean)false, null, (int)60, null);
        this.call2actionPanel = ComponentsKt.htmlComponent$default((String)this.titleText(packageStatus), null, null, null, (boolean)false, arg_0 -> PackageTitlePanel.call2actionPanel$lambda$1(this, arg_0), (int)30, null);
        String string = PackageCheckerBundle.message("checkmarx.copyright.notice", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"checkmarx.copyright.notice\")");
        this.copyRightPanel = ComponentsKt.htmlComponent$default((String)string, null, null, null, (boolean)false, null, (int)62, null);
        GridBag gridBag = new GridBag().setDefaultAnchor(0, 17).setDefaultAnchor(1, 13).setDefaultInsets(16, 20, 0, 0).setDefaultFill(2);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag()\n            .s\u2026agConstraints.HORIZONTAL)");
        GridBag gridBag2 = gridBag;
        this.add(this.packageLabel, gridBag2.nextLine().next().weightx(1.0).anchor(21));
        this.add(this.copyRightPanel, gridBag2.next().coverLine().weightx(0.0).anchor(22));
        this.add(this.call2actionPanel, gridBag2.nextLine().coverLine());
    }

    public final void setPackageStatus(@Nullable PackageStatus packageStatus) {
        ApplicationManager.getApplication().invokeLater(() -> PackageTitlePanel.setPackageStatus$lambda$2(this, packageStatus));
    }

    @NlsSafe
    private final String packageText(PackageStatus pkgStatus2) {
        Object object = pkgStatus2;
        if (object == null || (object = ((PackageStatus)object).getPkg()) == null) {
            String string = PackageCheckerBundle.message("dependency.tree.select.dependency.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dependency.tree\u2026lect.dependency.message\")");
            return string;
        }
        Object pkg = object;
        Object[] objectArray = new Object[2];
        objectArray[0] = ((Package)pkg).getHumanReadableCoordinates();
        String string = pkgStatus2.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pkgStatus.javaClass.simpleName");
        Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string2 = PackageCheckerBundle.message("dependency.tree.package.text.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\n          \"depe\u2026ame.lowercase()\n        )");
        return string2;
    }

    @NlsSafe
    private final String titleText(PackageStatus pkgStatus2) {
        if (pkgStatus2 instanceof Vulnerable) {
            Object object = ((Vulnerable)pkgStatus2).getVulnerablePackage().getCallToAction();
            if (object == null || (object = ((CallToAction)object).getNewVersion()) == null || (object = ((SingleVersion)object).getValue()) == null) {
                return "";
            }
            Object call2action = object;
            Object[] objectArray = new Object[]{call2action, "&nbsp;&nbsp;&nbsp;&nbsp;", "#copyCall2action", call2action, "Copy safe version to clipboard"};
            String string = PackageCheckerBundle.message("dependency.upgrade.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dependency.upgr\u2026, COPY_SAFE_VERSION_TEXT)");
            return string;
        }
        return "";
    }

    private final void copySafeVersionToClipboard(String urlDescription) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(PackageHtmlRenderer.INSTANCE.getCallToAction(urlDescription)));
    }

    private static final void call2actionPanel$lambda$1(PackageTitlePanel this$0, HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String $this$call2actionPanel_u24lambda_u241_u24lambda_u240 = e.getDescription();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$call2actionPanel_u24lambda_u241_u24lambda_u240, (String)"this");
            if (PackageHtmlRenderer.INSTANCE.isCallToActionUrlDescription($this$call2actionPanel_u24lambda_u241_u24lambda_u240)) {
                this$0.copySafeVersionToClipboard($this$call2actionPanel_u24lambda_u241_u24lambda_u240);
                return;
            }
        }
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
    }

    private static final void setPackageStatus$lambda$2(PackageTitlePanel this$0, PackageStatus $packageStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.packageLabel.setText(this$0.packageText($packageStatus));
        this$0.call2actionPanel.setText(this$0.titleText($packageStatus));
        this$0.invalidate();
    }
}

