/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ZipAndQueue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceLoginTicketsListener
implements VirtualFileListener {
    @Nullable
    private static final String ourP4TicketsFile = PerforceLoginTicketsListener.calculateAndNotify();
    private final AtomicReference<String> myLoadedText;
    private final PerforceLoginManager myLoginManager;
    private final ZipAndQueue myZipAndQueue;

    @Nullable
    private static String calculateAndNotify() {
        String value = PerforceLoginTicketsListener.calculatePath();
        if (value == null) {
            Notifications.Bus.notify((Notification)new Notification(PerforceVcs.getKey().getName(), PerforceBundle.message("login.monitor.failure", new Object[0]), PerforceBundle.message("login.monitor.failure.msg", new Object[0]), NotificationType.ERROR));
            return null;
        }
        try {
            value = new File(value).getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            value = value.replace('\\', '/');
        }
        return value;
    }

    @Nullable
    private static String calculatePath() {
        String ticketsFilePath = EnvironmentUtil.getValue((String)"P4TICKETS");
        if (!StringUtil.isEmptyOrSpaces((String)ticketsFilePath)) {
            return ticketsFilePath;
        }
        if (SystemInfo.isWindows) {
            String userProfile = EnvironmentUtil.getValue((String)"USERPROFILE");
            return StringUtil.isEmptyOrSpaces((String)userProfile) ? null : new File(userProfile, "p4tickets.txt").getPath();
        }
        String home = EnvironmentUtil.getValue((String)"HOME");
        return StringUtil.isEmptyOrSpaces((String)home) ? null : new File(home, ".p4tickets").getPath();
    }

    public void pingListening() {
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(ourP4TicketsFile));
    }

    public PerforceLoginTicketsListener(Project project, PerforceLoginManager loginManager, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(0);
        }
        this.myLoginManager = loginManager;
        this.myLoadedText = new AtomicReference();
        this.myZipAndQueue = new ZipAndQueue(project, -1, PerforceBundle.message("login.refresh.auth.state", new Object[0]), parentDisposable, () -> this.myLoginManager.refreshLoginState());
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(1);
        }
        this.processEvent((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(2);
        }
        this.processEvent(event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(3);
        }
        this.processEvent(event);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(4);
        }
        this.processEvent(event);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(5);
        }
        this.processEvent((VirtualFileEvent)event);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            PerforceLoginTicketsListener.$$$reportNull$$$0(6);
        }
        this.processEvent((VirtualFileEvent)event);
    }

    public static boolean shouldRegister() {
        return ourP4TicketsFile != null;
    }

    private void processEvent(VirtualFileEvent event) {
        if (ourP4TicketsFile == null) {
            return;
        }
        String path = event.getFile().getPath();
        if (SystemInfo.isWindows && path.equalsIgnoreCase(ourP4TicketsFile) || path.equals(ourP4TicketsFile)) {
            try {
                File file = new File(ourP4TicketsFile);
                char[] text = file.exists() ? FileUtil.loadFileText((File)file) : ArrayUtilRt.EMPTY_CHAR_ARRAY;
                String asString = String.valueOf(text);
                String was = this.myLoadedText.getAndSet(asString);
                if (!asString.equals(was)) {
                    this.myZipAndQueue.request();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCopied";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

