/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.Objects;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.jetbrains.idea.maven.server.embedder.ArtifactData;
import org.jetbrains.idea.maven.server.embedder.RepositoryDataList;

class ArtifactDescriptorRequestData {
    private final ArtifactData artifactData;
    private final RepositoryDataList repositories;
    private final String context;

    ArtifactDescriptorRequestData(ArtifactData artifactData, RepositoryDataList repositories, String context) {
        this.artifactData = artifactData;
        this.repositories = repositories;
        this.context = context;
    }

    ArtifactDescriptorRequestData(ArtifactDescriptorRequest request) {
        this(new ArtifactData(request.getArtifact()), new RepositoryDataList(request.getRepositories()), request.getRequestContext());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactDescriptorRequestData data = (ArtifactDescriptorRequestData)o;
        if (!Objects.equals(this.artifactData, data.artifactData)) {
            return false;
        }
        if (!Objects.equals(this.repositories, data.repositories)) {
            return false;
        }
        return Objects.equals(this.context, data.context);
    }

    public int hashCode() {
        int result = this.artifactData != null ? this.artifactData.hashCode() : 0;
        result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ArtifactDescriptorRequestData{artifactData='" + this.artifactData + '\'' + '}';
    }
}

