/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ide.util.TreeFileChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class ImageFileFilter
implements TreeFileChooser.PsiFileFilter {
    private final Set<String> myExtensions;
    private GlobalSearchScope myModuleScope;

    public ImageFileFilter(@Nullable Module module) {
        Object[] formatNames = ImageIO.getReaderFormatNames();
        this.myExtensions = ContainerUtil.map2Set((Object[])formatNames, formatName -> StringUtil.toLowerCase((String)formatName));
        if (module != null) {
            this.myModuleScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        }
    }

    public boolean accept(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            String extension = virtualFile.getExtension();
            return extension != null && this.myExtensions.contains(StringUtil.toLowerCase((String)extension)) && (this.myModuleScope == null || this.myModuleScope.contains(virtualFile));
        }
        return false;
    }
}

