/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FormLayoutColumnProperties
implements CustomPropertiesPanel {
    private static final Map<String, @Nls String> UNITS_MAP = new LinkedHashMap<String, String>();
    private JPanel myRootPanel;
    private JRadioButton myDefaultRadioButton;
    private JRadioButton myPreferredRadioButton;
    private JRadioButton myMinimumRadioButton;
    private JRadioButton myConstantRadioButton;
    private JComboBox<String> myConstantSizeUnitsCombo;
    private JCheckBox myMinimumCheckBox;
    private JCheckBox myMaximumCheckBox;
    private JSpinner myMaxSizeSpinner;
    private JComboBox<String> myMinSizeUnitsCombo;
    private JComboBox<String> myMaxSizeUnitsCombo;
    private JSpinner myConstantSizeSpinner;
    private JSpinner myMinSizeSpinner;
    private JCheckBox myGrowCheckBox;
    private JSpinner myGrowSpinner;
    private JRadioButton myLeftRadioButton;
    private JRadioButton myCenterRadioButton;
    private JRadioButton myRightRadioButton;
    private JRadioButton myFillRadioButton;
    private JLabel myTitleLabel;
    private JPanel myAlignmentPanel;
    private JPanel mySizePanel;
    private FormLayout myLayout;
    private int myIndex;
    private boolean myIsRow;
    private final List<ChangeListener> myListeners;
    private boolean myShowing;
    private boolean mySaving;

    public FormLayoutColumnProperties() {
        this.$$$setupUI$$$();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myShowing = false;
        this.mySaving = false;
        String[] unitNames = ArrayUtilRt.toStringArray(UNITS_MAP.keySet());
        this.myConstantSizeUnitsCombo.setModel(new DefaultComboBoxModel<String>(unitNames));
        this.myConstantSizeUnitsCombo.setRenderer((ListCellRenderer<String>)((Object)new UnitListCellRenderer()));
        this.myMinSizeUnitsCombo.setModel(new DefaultComboBoxModel<String>(unitNames));
        this.myMinSizeUnitsCombo.setRenderer((ListCellRenderer<String>)((Object)new UnitListCellRenderer()));
        this.myMaxSizeUnitsCombo.setModel(new DefaultComboBoxModel<String>(unitNames));
        this.myMaxSizeUnitsCombo.setRenderer((ListCellRenderer<String>)((Object)new UnitListCellRenderer()));
        MyRadioListener listener = new MyRadioListener();
        this.myDefaultRadioButton.addActionListener(listener);
        this.myPreferredRadioButton.addActionListener(listener);
        this.myMinimumRadioButton.addActionListener(listener);
        this.myConstantRadioButton.addActionListener(listener);
        this.myMinimumCheckBox.addChangeListener(new MyCheckboxListener(this.myMinimumCheckBox, this.myMinSizeUnitsCombo, this.myMinSizeSpinner));
        this.myMaximumCheckBox.addChangeListener(new MyCheckboxListener(this.myMaximumCheckBox, this.myMaxSizeUnitsCombo, this.myMaxSizeSpinner));
        this.myConstantRadioButton.addChangeListener(new MyCheckboxListener(this.myConstantRadioButton, this.myConstantSizeUnitsCombo, this.myConstantSizeSpinner));
        this.updateOnRadioChange();
        this.myGrowCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FormLayoutColumnProperties.this.myGrowSpinner.setEnabled(FormLayoutColumnProperties.this.myGrowCheckBox.isSelected());
                FormLayoutColumnProperties.this.updateSpec();
            }
        });
        MyChangeListener changeListener = new MyChangeListener();
        this.myGrowSpinner.setModel(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));
        this.myGrowSpinner.addChangeListener(changeListener);
        this.myMinSizeSpinner.addChangeListener(changeListener);
        this.myMaxSizeSpinner.addChangeListener(changeListener);
        this.myConstantSizeSpinner.addChangeListener(changeListener);
        this.myLeftRadioButton.addChangeListener(changeListener);
        this.myCenterRadioButton.addChangeListener(changeListener);
        this.myRightRadioButton.addChangeListener(changeListener);
        this.myFillRadioButton.addChangeListener(changeListener);
        MyItemListener itemListener = new MyItemListener();
        this.myMinSizeUnitsCombo.addItemListener(itemListener);
        this.myMaxSizeUnitsCombo.addItemListener(itemListener);
        this.myConstantSizeUnitsCombo.addItemListener(itemListener);
    }

    @Override
    public JPanel getComponent() {
        return this.myRootPanel;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showProperties(RadContainer container, boolean row, int[] selectedIndices) {
        if (this.mySaving) {
            return;
        }
        if (selectedIndices.length == 1) {
            this.showControls(true);
            this.myShowing = true;
            try {
                this.myLayout = (FormLayout)container.getLayout();
                this.myIndex = selectedIndices[0] + 1;
                this.myIsRow = row;
                this.myTitleLabel.setText(this.myIsRow ? UIDesignerBundle.message("title.row.properties", this.myIndex) : UIDesignerBundle.message("title.column.properties", this.myIndex));
                this.myLeftRadioButton.setText(row ? UIDesignerBundle.message("alignment.top", new Object[0]) : UIDesignerBundle.message("alignment.left", new Object[0]));
                this.myRightRadioButton.setText(row ? UIDesignerBundle.message("alignment.bottom", new Object[0]) : UIDesignerBundle.message("alignment.right", new Object[0]));
                this.mySizePanel.setBorder(IdeBorderFactory.createTitledBorder((String)(this.myIsRow ? UIDesignerBundle.message("title.height", new Object[0]) : UIDesignerBundle.message("title.width", new Object[0]))));
                RowSpec formSpec = row ? this.myLayout.getRowSpec(this.myIndex) : this.myLayout.getColumnSpec(this.myIndex);
                this.showAlignment(formSpec.getDefaultAlignment());
                this.showSize(formSpec.getSize());
                if (formSpec.getResizeWeight() < 0.01) {
                    this.myGrowCheckBox.setSelected(false);
                    this.myGrowSpinner.setValue(1.0);
                }
                this.myGrowCheckBox.setSelected(true);
                this.myGrowSpinner.setValue(formSpec.getResizeWeight());
            }
            finally {
                this.myShowing = false;
            }
        } else {
            this.showControls(false);
            if (selectedIndices.length > 1) {
                this.myTitleLabel.setText(this.myIsRow ? UIDesignerBundle.message("title.multiple.rows.selected", new Object[0]) : UIDesignerBundle.message("title.multiple.columns.selected", new Object[0]));
            } else {
                this.myTitleLabel.setText(this.myIsRow ? UIDesignerBundle.message("title.no.rows.selected", new Object[0]) : UIDesignerBundle.message("title.no.columns.selected", new Object[0]));
            }
        }
    }

    private void showControls(boolean visible) {
        this.mySizePanel.setVisible(visible);
        this.myAlignmentPanel.setVisible(visible);
        this.myGrowCheckBox.setVisible(visible);
        this.myGrowSpinner.setVisible(visible);
    }

    private void showAlignment(FormSpec.DefaultAlignment defaultAlignment) {
        if (defaultAlignment.equals(RowSpec.TOP) || defaultAlignment.equals(ColumnSpec.LEFT)) {
            this.myLeftRadioButton.setSelected(true);
        } else if (defaultAlignment.equals(RowSpec.CENTER)) {
            this.myCenterRadioButton.setSelected(true);
        } else if (defaultAlignment.equals(RowSpec.BOTTOM) || defaultAlignment.equals(ColumnSpec.RIGHT)) {
            this.myRightRadioButton.setSelected(true);
        } else {
            this.myFillRadioButton.setSelected(true);
        }
    }

    private void showSize(Size size) {
        Size minimumSize = null;
        Size maximumSize = null;
        if (size instanceof BoundedSize) {
            BoundedSize boundedSize = (BoundedSize)size;
            minimumSize = boundedSize.getLowerBound();
            maximumSize = boundedSize.getUpperBound();
            size = boundedSize.getBasis();
        }
        if (size instanceof ConstantSize) {
            this.myConstantRadioButton.setSelected(true);
            this.myMinimumCheckBox.setEnabled(false);
            this.myMinimumCheckBox.setSelected(false);
            this.myMaximumCheckBox.setEnabled(false);
            this.myMaximumCheckBox.setSelected(false);
            FormLayoutColumnProperties.showConstantSize((ConstantSize)size, this.myConstantSizeUnitsCombo, this.myConstantSizeSpinner);
        } else {
            String s = size.toString();
            if (s.startsWith("m")) {
                this.myMinimumRadioButton.setSelected(true);
            } else if (s.startsWith("p")) {
                this.myPreferredRadioButton.setSelected(true);
            } else {
                this.myDefaultRadioButton.setSelected(true);
            }
            this.myMinimumCheckBox.setEnabled(true);
            this.myMaximumCheckBox.setEnabled(true);
            if (minimumSize instanceof ConstantSize) {
                this.myMinimumCheckBox.setSelected(true);
                this.myMaximumCheckBox.setEnabled(false);
                FormLayoutColumnProperties.showConstantSize((ConstantSize)minimumSize, this.myMinSizeUnitsCombo, this.myMinSizeSpinner);
            } else {
                this.myMinimumCheckBox.setSelected(false);
            }
            if (maximumSize instanceof ConstantSize) {
                this.myMaximumCheckBox.setSelected(true);
                this.myMinimumCheckBox.setEnabled(false);
                FormLayoutColumnProperties.showConstantSize((ConstantSize)maximumSize, this.myMaxSizeUnitsCombo, this.myMaxSizeSpinner);
            } else {
                this.myMaximumCheckBox.setSelected(false);
            }
        }
    }

    private static void showConstantSize(ConstantSize size, JComboBox unitsCombo, JSpinner spinner) {
        double value = size.getValue();
        ConstantSize.Unit unit = size.getUnit();
        @NlsSafe String item = unit.equals(ConstantSize.DIALOG_UNITS_X) || unit.equals(ConstantSize.DIALOG_UNITS_Y) ? "dlu" : unit.abbreviation();
        unitsCombo.setSelectedItem(item);
        spinner.setModel(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 1.0));
        spinner.setValue(value);
    }

    private void updateOnRadioChange() {
        boolean canSetBounds = !this.myConstantRadioButton.isSelected();
        this.myMinimumCheckBox.setEnabled(canSetBounds);
        this.myMaximumCheckBox.setEnabled(canSetBounds);
        if (this.myMinimumCheckBox.isSelected()) {
            this.myMaximumCheckBox.setEnabled(false);
            this.myMaximumCheckBox.setSelected(false);
        } else if (this.myMaximumCheckBox.isSelected()) {
            this.myMinimumCheckBox.setEnabled(false);
        }
        if (!canSetBounds) {
            this.myMinimumCheckBox.setSelected(false);
            this.myMaximumCheckBox.setSelected(false);
        }
        this.updateSpec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpec() {
        if (this.myLayout == null || this.myShowing) {
            return;
        }
        this.mySaving = true;
        try {
            Size size = this.getSelectedSize();
            SpinnerNumberModel model = (SpinnerNumberModel)this.myGrowSpinner.getModel();
            double resizeWeight = this.myGrowCheckBox.isSelected() ? model.getNumber().doubleValue() : 0.0;
            FormSpec.DefaultAlignment alignment = this.getSelectedAlignment();
            if (this.myIsRow) {
                this.myLayout.setRowSpec(this.myIndex, new RowSpec(alignment, size, resizeWeight));
            } else {
                this.myLayout.setColumnSpec(this.myIndex, new ColumnSpec(alignment, size, resizeWeight));
            }
            for (ChangeListener listener : this.myListeners) {
                listener.stateChanged(new ChangeEvent(this));
            }
        }
        finally {
            this.mySaving = false;
        }
    }

    private Size getSelectedSize() {
        Object size = this.myDefaultRadioButton.isSelected() ? Sizes.DEFAULT : (this.myPreferredRadioButton.isSelected() ? Sizes.PREFERRED : (this.myMinimumRadioButton.isSelected() ? Sizes.MINIMUM : this.getConstantSize(this.myConstantSizeUnitsCombo, this.myConstantSizeSpinner)));
        if (this.myMinimumCheckBox.isSelected() || this.myMaximumCheckBox.isSelected()) {
            ConstantSize minSize = null;
            ConstantSize maxSize = null;
            if (this.myMinimumCheckBox.isSelected()) {
                minSize = this.getConstantSize(this.myMinSizeUnitsCombo, this.myMinSizeSpinner);
            }
            if (this.myMaximumCheckBox.isSelected()) {
                maxSize = this.getConstantSize(this.myMaxSizeUnitsCombo, this.myMaxSizeSpinner);
            }
            size = Sizes.bounded((Size)size, (Size)minSize, maxSize);
        }
        return size;
    }

    private FormSpec.DefaultAlignment getSelectedAlignment() {
        if (this.myLeftRadioButton.isSelected()) {
            return this.myIsRow ? RowSpec.TOP : ColumnSpec.LEFT;
        }
        if (this.myCenterRadioButton.isSelected()) {
            return RowSpec.CENTER;
        }
        if (this.myRightRadioButton.isSelected()) {
            return this.myIsRow ? RowSpec.BOTTOM : ColumnSpec.RIGHT;
        }
        return RowSpec.FILL;
    }

    private ConstantSize getConstantSize(JComboBox unitsCombo, JSpinner spinner) {
        return Sizes.constant((String)(spinner.getValue().toString() + Objects.requireNonNull(unitsCombo.getSelectedItem()).toString()), (boolean)this.myIsRow);
    }

    static {
        UNITS_MAP.put("px", UIDesignerBundle.message("unit.pixels", new Object[0]));
        UNITS_MAP.put("dlu", UIDesignerBundle.message("unit.dialog.units", new Object[0]));
        UNITS_MAP.put("pt", UIDesignerBundle.message("unit.points", new Object[0]));
        UNITS_MAP.put("in", UIDesignerBundle.message("unit.inches", new Object[0]));
        UNITS_MAP.put("cm", UIDesignerBundle.message("unit.centimeters", new Object[0]));
        UNITS_MAP.put("mm", UIDesignerBundle.message("unit.millimeters", new Object[0]));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JSpinner jSpinner2;
        JSpinner jSpinner3;
        JSpinner jSpinner4;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:noGrow", "center:d:noGrow,top:4dlu:noGrow,center:d:noGrow,top:4dlu:noGrow,center:d:noGrow"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), null, 0, 0, null, null));
        this.myTitleLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("row.0.properties"));
        jPanel3.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myAlignmentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:d:grow", "center:d:grow"));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("title.default.alignment"), (int)0, (int)0, null, null));
        this.myLeftRadioButton = jRadioButton8 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton8, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("alignment.left"));
        jPanel2.add((Component)jRadioButton8, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCenterRadioButton = jRadioButton7 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("alignment.center"));
        jPanel2.add((Component)jRadioButton7, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myRightRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("alignment.right"));
        jPanel2.add((Component)jRadioButton6, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myFillRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("alignment.fill"));
        jPanel2.add((Component)jRadioButton5, new CellConstraints(7, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.mySizePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:60px:noGrow,left:4dlu:noGrow,fill:max(d;60px):noGrow", "center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:d:grow"));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("title.size"), (int)0, (int)0, null, null));
        this.myPreferredRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.preferred"));
        jPanel.add((Component)jRadioButton4, new CellConstraints(1, 3, 2, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMinimumRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.minimum"));
        jPanel.add((Component)jRadioButton3, new CellConstraints(1, 5, 2, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myConstantRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.constant"));
        jPanel.add((Component)jRadioButton2, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myConstantSizeSpinner = jSpinner4 = new JSpinner();
        ((Component)jSpinner4).setEnabled(false);
        jPanel.add((Component)jSpinner4, new CellConstraints(3, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMinSizeSpinner = jSpinner3 = new JSpinner();
        ((Component)jSpinner3).setEnabled(false);
        jPanel.add((Component)jSpinner3, new CellConstraints(3, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMaxSizeSpinner = jSpinner2 = new JSpinner();
        ((Component)jSpinner2).setEnabled(false);
        jPanel.add((Component)jSpinner2, new CellConstraints(3, 13, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JComboBox jComboBox = new JComboBox();
        this.myConstantSizeUnitsCombo = jComboBox;
        ((Component)jComboBox).setEnabled(false);
        jPanel.add(jComboBox, new CellConstraints(5, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JComboBox jComboBox2 = new JComboBox();
        this.myMinSizeUnitsCombo = jComboBox2;
        ((Component)jComboBox2).setEnabled(false);
        jPanel.add(jComboBox2, new CellConstraints(5, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JComboBox jComboBox3 = new JComboBox();
        this.myMaxSizeUnitsCombo = jComboBox3;
        ((Component)jComboBox3).setEnabled(false);
        jPanel.add(jComboBox3, new CellConstraints(5, 13, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMinimumCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.minimum.limit"));
        jPanel.add((Component)jCheckBox3, new CellConstraints(1, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMaximumCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.maximum.limit"));
        jPanel.add((Component)jCheckBox2, new CellConstraints(1, 13, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDefaultRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.default"));
        jPanel.add((Component)jRadioButton, new CellConstraints(1, 1, 2, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new CellConstraints(1, 9, 5, 1, CellConstraints.DEFAULT, CellConstraints.CENTER, new Insets(0, 0, 0, 0)));
        this.myGrowCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/UIDesignerBundle", FormLayoutColumnProperties.class).getString("size.grow"));
        jPanel.add((Component)jCheckBox, new CellConstraints(1, 17, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myGrowSpinner = jSpinner = new JSpinner();
        ((Component)jSpinner).setEnabled(false);
        jPanel.add((Component)jSpinner, new CellConstraints(3, 17, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JSeparator jSeparator2 = new JSeparator();
        jPanel.add((Component)jSeparator2, new CellConstraints(1, 15, 5, 1, CellConstraints.DEFAULT, CellConstraints.CENTER, new Insets(0, 0, 0, 0)));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class UnitListCellRenderer
    extends SimpleListCellRenderer<String> {
        private UnitListCellRenderer() {
        }

        public void customize(@NotNull JList<? extends String> list, String value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                UnitListCellRenderer.$$$reportNull$$$0(0);
            }
            this.setText(UNITS_MAP.getOrDefault(value, ""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uiDesigner/radComponents/FormLayoutColumnProperties$UnitListCellRenderer", "customize"));
        }
    }

    private class MyRadioListener
    implements ActionListener {
        private MyRadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormLayoutColumnProperties.this.updateOnRadioChange();
        }
    }

    private class MyCheckboxListener
    implements ChangeListener {
        private boolean myWasSelected;
        private final AbstractButton myButton;
        private final JComboBox myUnitsCombo;
        private final JSpinner mySpinner;

        MyCheckboxListener(AbstractButton button, JComboBox unitsCombo, JSpinner spinner) {
            this.myButton = button;
            this.myUnitsCombo = unitsCombo;
            this.mySpinner = spinner;
            this.myWasSelected = this.myButton.isSelected();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.myWasSelected != this.myButton.isSelected()) {
                this.myWasSelected = this.myButton.isSelected();
                this.myUnitsCombo.setEnabled(this.myButton.isSelected());
                this.mySpinner.setEnabled(this.myButton.isSelected());
                if (this.myButton.isSelected() && this.mySpinner.getValue().equals(0)) {
                    this.mySpinner.setValue(100);
                }
                FormLayoutColumnProperties.this.updateOnRadioChange();
            }
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FormLayoutColumnProperties.this.updateSpec();
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            FormLayoutColumnProperties.this.updateSpec();
        }
    }
}

