/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;

public class GenericMethodDescriptor {
    public final List<String> typeParameters;
    public final List<List<GenericType>> typeParameterBounds;
    public final List<GenericType> parameterTypes;
    public final GenericType returnType;
    public final List<GenericType> exceptionTypes;

    public GenericMethodDescriptor(List<String> typeParameters, List<List<GenericType>> typeParameterBounds, List<GenericType> parameterTypes, GenericType returnType, List<GenericType> exceptionTypes) {
        this.typeParameters = GenericMethodDescriptor.substitute(typeParameters);
        this.typeParameterBounds = GenericMethodDescriptor.substitute(typeParameterBounds);
        this.parameterTypes = GenericMethodDescriptor.substitute(parameterTypes);
        this.returnType = returnType;
        this.exceptionTypes = GenericMethodDescriptor.substitute(exceptionTypes);
    }

    private static <T> List<T> substitute(List<T> list) {
        return list.isEmpty() ? Collections.emptyList() : list;
    }
}

