/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.util.PairConsumer;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitAutoSquashCommitAction;
import git4idea.rebase.GitRebaseCheckinHandlerFactory;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/GitRebaseCheckinHandlerFactory;", "Lcom/intellij/openapi/vcs/checkin/VcsCheckinHandlerFactory;", "()V", "createVcsHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "intellij.vcs.git"})
public final class GitRebaseCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    public GitRebaseCheckinHandlerFactory() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey()");
        super(vcsKey);
    }

    @NotNull
    protected CheckinHandler createVcsHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        return new CheckinHandler(){
            private boolean active;
            private Project project;
            private GitRepository repository;
            private String rebaseFrom;

            public void checkinSuccessful() {
                if (!this.active) {
                    return;
                }
                Project project = this.project;
                if (project == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                    project = null;
                }
                Project project2 = project;
                String string = GitBundle.message("rebase.progress.indicator.title", new Object[0]);
                new Task.Backgroundable(this, project2, string){
                    final /* synthetic */ createVcsHandler.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, $super_call_param$2);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        GitRepository gitRepository = createVcsHandler.1.access$getRepository$p(this.this$0);
                        if (gitRepository == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                            gitRepository = null;
                        }
                        GitVersion gitVersion = gitRepository.getVcs().getVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"repository.vcs.version");
                        String string = createVcsHandler.1.access$getRebaseFrom$p(this.this$0);
                        if (string == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rebaseFrom");
                            string = null;
                        }
                        GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, gitVersion, string, null, false, null, 16, null);
                        Project project = this.getProject();
                        GitRepository gitRepository2 = createVcsHandler.1.access$getRepository$p(this.this$0);
                        if (gitRepository2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                            gitRepository2 = null;
                        }
                        GitRebaseUtils.rebase(project, CollectionsKt.listOf((Object)gitRepository2), params, indicator);
                    }
                }.queue();
            }

            @NotNull
            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, @Nullable PairConsumer<Object, Object> additionalDataConsumer) {
                Intrinsics.checkNotNull((Object)executor, (String)"null cannot be cast to non-null type git4idea.rebase.GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor");
                GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor cfr_ignored_0 = (GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor;
                this.active = true;
                this.project = ((GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor).getProject();
                this.repository = ((GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor).getRepository();
                this.rebaseFrom = ((GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor)executor).getHash();
                return CheckinHandler.ReturnResult.COMMIT;
            }

            public boolean acceptExecutor(@Nullable CommitExecutor executor) {
                return executor instanceof GitAutoSquashCommitAction.GitRebaseAfterCommitExecutor;
            }

            public static final /* synthetic */ GitRepository access$getRepository$p(createVcsHandler.1 $this) {
                return $this.repository;
            }

            public static final /* synthetic */ String access$getRebaseFrom$p(createVcsHandler.1 $this) {
                return $this.rebaseFrom;
            }
        };
    }
}

