/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.helper;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.helper.SPPersisterHelper;
import ca.sqlpower.object.SPObject;
import com.google.common.collect.Multimap;
import java.util.List;

public abstract class AbstractSPPersisterHelper<T extends SPObject>
implements SPPersisterHelper<T> {
    public static String createSPPersistenceExceptionMessage(SPObject spo, String propertyName) {
        return "Cannot persist property \"" + propertyName + "\" on " + spo.getClass() + " with name \"" + spo.getName() + "\" and UUID \"" + spo.getUUID() + "\"";
    }

    public static Object findPropertyAndRemove(String uuid, String propertyName, Multimap<String, PersistedSPOProperty> persistedProperties) {
        for (PersistedSPOProperty property : persistedProperties.get((Object)uuid)) {
            if (!property.getPropertyName().equals(propertyName)) continue;
            Object newValue = property.getNewValue();
            persistedProperties.remove((Object)uuid, (Object)property);
            return newValue;
        }
        return null;
    }

    public static PersistedSPOProperty findProperty(String uuid, String propertyName, Multimap<String, PersistedSPOProperty> persistedProperties) {
        for (PersistedSPOProperty property : persistedProperties.get((Object)uuid)) {
            if (!property.getPropertyName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public static PersistedSPObject findPersistedSPObject(String parentUUID, String childUUID, List<PersistedSPObject> persistedObjects) {
        for (PersistedSPObject pwo : persistedObjects) {
            if (pwo.isLoaded() || !pwo.getParentUUID().equals(parentUUID) || !pwo.getUUID().equals(childUUID)) continue;
            return pwo;
        }
        return null;
    }
}

