/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.event.ProfileChangeEvent;
import ca.sqlpower.architect.profile.event.ProfileChangeListener;
import ca.sqlpower.architect.profile.output.ProfileColumn;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.table.CleanupTableModel;
import ca.sqlpower.util.SQLPowerUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class ProfileTableModel
extends AbstractTableModel
implements CleanupTableModel {
    static final int CPR_PSEUDO_COLUMN_INDEX = -1;
    private static final Logger logger = Logger.getLogger(ProfileTableModel.class);
    private final ProfileManager profileManager;
    private List<ColumnProfileResult> resultList;
    private List<TableProfileResult> tableResultsToScan = new ArrayList<TableProfileResult>();
    private final ProfileChangeListener profileChangeHandler = new ProfileChangeListener(){

        @Override
        public void profilesRemoved(ProfileChangeEvent e) {
            ProfileTableModel.this.refresh();
        }

        @Override
        public void profilesAdded(ProfileChangeEvent e) {
            ProfileTableModel.this.refresh();
        }

        @Override
        public void profileListChanged(ProfileChangeEvent e) {
            ProfileTableModel.this.refresh();
        }
    };

    public ProfileTableModel(ProfileManager profileManager) {
        this.profileManager = profileManager;
        profileManager.addProfileChangeListener(this.profileChangeHandler);
        this.refresh();
    }

    public void cleanup() {
        logger.debug((Object)"Cleaning up...");
        this.profileManager.removeProfileChangeListener(this.profileChangeHandler);
    }

    @Override
    public String getColumnName(int col) {
        return ProfileColumn.values()[col].getName();
    }

    @Override
    public int getRowCount() {
        return this.resultList.size();
    }

    @Override
    public int getColumnCount() {
        return ProfileColumn.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ColumnProfileResult cpr = this.resultList.get(rowIndex);
        if (columnIndex == -1) {
            return cpr;
        }
        return ProfileTableModel.getColumnValueFromProfile(ProfileColumn.values()[columnIndex], cpr);
    }

    private static Object getColumnValueFromProfile(ProfileColumn column, ColumnProfileResult columnProfile) {
        SQLColumn col = (SQLColumn)columnProfile.getProfiledObject();
        int rowCount = columnProfile.getParent().getRowCount();
        switch (column) {
            case DATABASE: {
                return SQLPowerUtils.getAncestor((SPObject)col, SQLDatabase.class);
            }
            case CATALOG: {
                return SQLPowerUtils.getAncestor((SPObject)col, SQLCatalog.class);
            }
            case SCHEMA: {
                return SQLPowerUtils.getAncestor((SPObject)col, SQLSchema.class);
            }
            case TABLE: {
                return SQLPowerUtils.getAncestor((SPObject)col, SQLTable.class);
            }
            case COLUMN: {
                return col;
            }
            case RUNDATE: {
                return columnProfile.getCreateStartTime();
            }
            case RECORD_COUNT: {
                return rowCount;
            }
            case DATA_TYPE: {
                try {
                    DDLGenerator gddl = DDLUtils.createDDLGenerator(col.getParent().getParentDatabase().getDataSource());
                    return gddl.columnType(col);
                }
                catch (Exception e) {
                    return "Unable to obtain DDL information";
                }
            }
            case NULL_COUNT: {
                return columnProfile.getNullCount();
            }
            case PERCENT_NULL: {
                return rowCount == 0 ? null : Double.valueOf((double)columnProfile.getNullCount() / (double)rowCount);
            }
            case UNIQUE_COUNT: {
                return columnProfile.getDistinctValueCount();
            }
            case PERCENT_UNIQUE: {
                return rowCount == 0 ? null : Double.valueOf((double)columnProfile.getDistinctValueCount() / (double)rowCount);
            }
            case MIN_LENGTH: {
                return columnProfile.getMinLength();
            }
            case MAX_LENGTH: {
                return columnProfile.getMaxLength();
            }
            case AVERAGE_LENGTH: {
                return columnProfile.getAvgLength();
            }
            case MIN_VALUE: {
                return columnProfile.getMinValue();
            }
            case MAX_VALUE: {
                return columnProfile.getMaxValue();
            }
            case AVERAGE_VALUE: {
                return columnProfile.getAvgValue();
            }
            case TOP_VALUE: {
                return columnProfile.getValueCount();
            }
        }
        throw new IllegalArgumentException(String.format("ProfileColumn enum value %s not handled", new Object[]{column}));
    }

    public List<ColumnValueCount> getTopNValueAt(int rowIndex) {
        return this.resultList.get(rowIndex).getValueCount();
    }

    public boolean isErrorColumnProfile(int row) {
        ColumnProfileResult columnProfile = this.resultList.get(row);
        return columnProfile.getException() != null;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public void refresh() {
        this.resultList = new ArrayList<ColumnProfileResult>();
        for (TableProfileResult tpr : this.tableResultsToScan) {
            for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                this.resultList.add(cpr);
            }
        }
        Collections.sort(this.resultList);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        ProfileColumn pc = ProfileColumn.values()[columnIndex];
        switch (pc) {
            case DATABASE: {
                return SQLDatabase.class;
            }
            case CATALOG: {
                return SQLCatalog.class;
            }
            case SCHEMA: {
                return SQLSchema.class;
            }
            case TABLE: {
                return SQLTable.class;
            }
            case COLUMN: {
                return SQLColumn.class;
            }
            case RUNDATE: {
                return Long.class;
            }
            case RECORD_COUNT: {
                return Integer.class;
            }
            case DATA_TYPE: {
                return String.class;
            }
            case NULL_COUNT: {
                return Integer.class;
            }
            case PERCENT_NULL: {
                return BigDecimal.class;
            }
            case UNIQUE_COUNT: {
                return Integer.class;
            }
            case PERCENT_UNIQUE: {
                return BigDecimal.class;
            }
            case MIN_LENGTH: {
                return Integer.class;
            }
            case MAX_LENGTH: {
                return Integer.class;
            }
            case AVERAGE_LENGTH: {
                return BigDecimal.class;
            }
            case MIN_VALUE: {
                return Object.class;
            }
            case MAX_VALUE: {
                return Object.class;
            }
            case AVERAGE_VALUE: {
                return Object.class;
            }
            case TOP_VALUE: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException(String.format("ProfileColumn value %s unknown", new Object[]{pc}));
    }

    public List<ColumnProfileResult> getResultList() {
        return this.resultList;
    }

    public void addTableResultToScan(TableProfileResult tpr) {
        this.tableResultsToScan.add(tpr);
    }

    public List<TableProfileResult> getTableResultsToScan() {
        return this.tableResultsToScan;
    }

    public void clearScanList() {
        this.tableResultsToScan.clear();
    }

    public void removeTableResultToScan(TableProfileResult result) {
        this.tableResultsToScan.remove(result);
    }
}

