module Test_Mailscanner =

let conf = "# Main configuration file for the MailScanner E-Mail Virus Scanner
%org-name% = BARUWA
%org-long-name% = BARUWA MAILFW
%web-site% = www.baruwa.com
%etc-dir% = /etc/MailScanner
%reports-base% = /etc/MailScanner/reports
%report-dir% = /etc/MailScanner/reports/en
%rules-dir% = /etc/MailScanner/rules
%mcp-dir% = /etc/MailScanner/mcp
%spool-dir% = /var/spool/MailScanner
%signature-dir% = /etc/MailScanner/baruwa/signatures
%brules-dir% = /etc/MailScanner/baruwa/rules
Max Children = 5
Run As User = exim
Run As Group = exim
Queue Scan Interval = 6
Incoming Queue Dir = /var/spool/exim.in/input
Outgoing Queue Dir = /var/spool/exim/input
Incoming Work Dir = %spool-dir%/incoming
Quarantine Dir = %spool-dir%/quarantine
PID file = /var/run/MailScanner/MailScanner.pid
Restart Every = 7200
MTA = exim
Sendmail = /usr/sbin/exim -C /etc/exim/exim_out.conf
Sendmail2 = /usr/sbin/exim -C /etc/exim/exim_out.conf
Incoming Work User = exim
Incoming Work Group = clam
Incoming Work Permissions = 0640
Quarantine User = exim
Quarantine Group = baruwa
Quarantine Permissions = 0660
Max Unscanned Bytes Per Scan = 100m
Max Unsafe Bytes Per Scan = 50m
Max Unscanned Messages Per Scan = 30
Max Unsafe Messages Per Scan = 30
Max Normal Queue Size = 800
Scan Messages = %rules-dir%/scan.messages.rules
Reject Message = no
Maximum Processing Attempts = 6
Processing Attempts Database = %spool-dir%/incoming/Processing.db
Maximum Attachments Per Message = 200
Expand TNEF = yes
Use TNEF Contents = replace
Deliver Unparsable TNEF = no
TNEF Expander = /usr/bin/tnef --maxsize=100000000
TNEF Timeout = 120
File Command = /usr/sbin/file-wrapper
File Timeout = 20
Gunzip Command = /bin/gunzip
Gunzip Timeout = 50
Unrar Command = /usr/bin/unrar
Unrar Timeout = 50
Find UU-Encoded Files = no
Maximum Message Size = %brules-dir%/message.size.rules
Maximum Attachment Size = -1
Minimum Attachment Size = -1
Maximum Archive Depth = 4
Find Archives By Content = yes
Unpack Microsoft Documents = yes
Zip Attachments = no
Attachments Zip Filename = MessageAttachments.zip
Attachments Min Total Size To Zip = 100k
Attachment Extensions Not To Zip = .zip .rar .gz .tgz .jpg .jpeg .mpg .mpe .mpeg .mp3 .rpm .htm .html .eml
Add Text Of Doc = no
Antiword = /usr/bin/antiword -f
Antiword Timeout = 50
Unzip Maximum Files Per Archive = 0
Unzip Maximum File Size = 50k
Unzip Filenames = *.txt *.ini *.log *.csv
Unzip MimeType = text/plain
Virus Scanning = %brules-dir%/virus.checks.rules
Virus Scanners = auto
Virus Scanner Timeout = 300
Deliver Disinfected Files = no
Silent Viruses = HTML-IFrame All-Viruses
Still Deliver Silent Viruses = no
Non-Forging Viruses = Joke/ OF97/ WM97/ W97M/ eicar
Spam-Virus Header = X-%org-name%-BaruwaFW-SpamVirus-Report:
Virus Names Which Are Spam = Sanesecurity.Spam*UNOFFICIAL HTML/* *Phish* *Suspected-phishing_safebrowsing*
Block Encrypted Messages = no
Block Unencrypted Messages = no
Allow Password-Protected Archives = yes
Check Filenames In Password-Protected Archives = yes
Allowed Sophos Error Messages =
Sophos IDE Dir = /opt/sophos-av/lib/sav
Sophos Lib Dir = /opt/sophos-av/lib
Monitors For Sophos Updates = /opt/sophos-av/lib/sav/*.ide
Monitors for ClamAV Updates = /var/lib/clamav/*.cvd
ClamAVmodule Maximum Recursion Level = 8
ClamAVmodule Maximum Files = 1000
ClamAVmodule Maximum File Size = 10000000
ClamAVmodule Maximum Compression Ratio = 250
Clamd Port = 3310
Clamd Socket = /var/run/clamav/clamd.sock
Clamd Lock File =
Clamd Use Threads = no
ClamAV Full Message Scan = yes
Fpscand Port = 10200
Dangerous Content Scanning = %rules-dir%/content.scanning.rules
Allow Partial Messages = no
Allow External Message Bodies = no
Find Phishing Fraud = yes
Also Find Numeric Phishing = yes
Use Stricter Phishing Net = yes
Highlight Phishing Fraud = yes
Phishing Safe Sites File = %etc-dir%/phishing.safe.sites.conf
Phishing Bad Sites File = %etc-dir%/phishing.bad.sites.conf
Country Sub-Domains List = %etc-dir%/country.domains.conf
Allow IFrame Tags = disarm
Allow Form Tags = disarm
Allow Script Tags = disarm
Allow WebBugs = disarm
Ignored Web Bug Filenames = spacer pixel.gif pixel.png gap
Known Web Bug Servers = msgtag.com
Web Bug Replacement = https://datafeeds.baruwa.com/1x1spacer.gif
Allow Object Codebase Tags = disarm
Convert Dangerous HTML To Text = no
Convert HTML To Text = no
Archives Are = zip rar ole
Allow Filenames =
Deny Filenames =
Filename Rules = %rules-dir%/filename.rules
Allow Filetypes =
Allow File MIME Types =
Deny Filetypes =
Deny File MIME Types =
Filetype Rules = %rules-dir%/filetype.rules
Archives: Allow Filenames =
Archives: Deny Filenames =
Archives: Filename Rules = %etc-dir%/archives.filename.rules.conf
Archives: Allow Filetypes =
Archives: Allow File MIME Types =
Archives: Deny Filetypes =
Archives: Deny File MIME Types =
Archives: Filetype Rules = %etc-dir%/archives.filetype.rules.conf
Default Rename Pattern = __FILENAME__.disarmed
Quarantine Infections = yes
Quarantine Silent Viruses = no
Quarantine Modified Body = no
Quarantine Whole Message = yes
Quarantine Whole Messages As Queue Files = no
Keep Spam And MCP Archive Clean = yes
Language Strings = %brules-dir%/languages.rules
Rejection Report = %brules-dir%/rejectionreport.rules
Deleted Bad Content Message Report = %brules-dir%/deletedcontentmessage.rules
Deleted Bad Filename Message Report = %brules-dir%/deletedfilenamemessage.rules
Deleted Virus Message Report = %brules-dir%/deletedvirusmessage.rules
Deleted Size Message Report = %brules-dir%/deletedsizemessage.rules
Stored Bad Content Message Report = %brules-dir%/storedcontentmessage.rules
Stored Bad Filename Message Report = %brules-dir%/storedfilenamemessage.rules
Stored Virus Message Report = %brules-dir%/storedvirusmessage.rules
Stored Size Message Report = %brules-dir%/storedsizemessage.rules
Disinfected Report = %brules-dir%/disinfectedreport.rules
Inline HTML Signature = %brules-dir%/html.sigs.rules
Inline Text Signature = %brules-dir%/text.sigs.rules
Signature Image Filename = %brules-dir%/sig.imgs.names.rules
Signature Image <img> Filename = %brules-dir%/sig.imgs.rules
Inline HTML Warning = %brules-dir%/inlinewarninghtml.rules
Inline Text Warning = %brules-dir%/inlinewarningtxt.rules
Sender Content Report = %brules-dir%/sendercontentreport.rules
Sender Error Report = %brules-dir%/sendererrorreport.rules
Sender Bad Filename Report = %brules-dir%/senderfilenamereport.rules
Sender Virus Report = %brules-dir%/sendervirusreport.rules
Sender Size Report = %brules-dir%/sendersizereport.rules
Hide Incoming Work Dir = yes
Include Scanner Name In Reports = yes
Mail Header = X-%org-name%-BaruwaFW:
Spam Header = X-%org-name%-BaruwaFW-SpamCheck:
Spam Score Header = X-%org-name%-BaruwaFW-SpamScore:
Information Header = X-%org-name%-BaruwaFW-Information:
Add Envelope From Header = yes
Add Envelope To Header = no
Envelope From Header = X-BARUWA-BaruwaFW-From:
Envelope To Header = X-%org-name%-BaruwaFW-To:
ID Header = X-%org-name%-BaruwaFW-ID:
IP Protocol Version Header =
Spam Score Character = s
SpamScore Number Instead Of Stars = no
Minimum Stars If On Spam List = 0
Clean Header Value = Found to be clean
Infected Header Value = Found to be infected
Disinfected Header Value = Disinfected
Information Header Value = Please contact %org-long-name% for more information
Detailed Spam Report = yes
Include Scores In SpamAssassin Report = yes
Always Include SpamAssassin Report = no
Multiple Headers = add
Place New Headers At Top Of Message = yes
Hostname = the %org-name% ($HOSTNAME) Baruwa
Sign Messages Already Processed = no
Sign Clean Messages = %brules-dir%/sign.clean.msgs.rules
Attach Image To Signature = yes
Attach Image To HTML Message Only = yes
Allow Multiple HTML Signatures = no
Dont Sign HTML If Headers Exist =
Mark Infected Messages = yes
Mark Unscanned Messages = no
Unscanned Header Value = Not scanned: please contact %org-long-name% for details
Remove These Headers = X-Mozilla-Status: X-Mozilla-Status2:
Deliver Cleaned Messages = yes
Notify Senders = no
Notify Senders Of Viruses = no
Notify Senders Of Blocked Filenames Or Filetypes = no
Notify Senders Of Blocked Size Attachments = no
Notify Senders Of Other Blocked Content = no
Never Notify Senders Of Precedence = list bulk
Scanned Modify Subject = no
Scanned Subject Text = {Scanned}
Virus Modify Subject = no
Virus Subject Text = {Virus?}
Filename Modify Subject = no
Filename Subject Text = {Filename?}
Content Modify Subject = no
Content Subject Text = {Dangerous Content?}
Size Modify Subject = no
Size Subject Text = {Size}
Disarmed Modify Subject = no
Disarmed Subject Text = {Disarmed}
Phishing Modify Subject = yes
Phishing Subject Text = {Suspected Phishing?}
Spam Modify Subject = no
Spam Subject Text = {Spam?}
High Scoring Spam Modify Subject = no
High Scoring Spam Subject Text = {Spam?}
Warning Is Attachment = yes
Attachment Warning Filename = %org-name%-Attachment-Warning.txt
Attachment Encoding Charset = ISO-8859-1
Archive Mail =
Missing Mail Archive Is = file
Send Notices = no
Notices Include Full Headers = yes
Hide Incoming Work Dir in Notices = yes
Notice Signature = -- \\n%org-name%\\nEmail Security\\n%website%
Notices From = Baruwa
Notices To = postmaster
Local Postmaster = postmaster
Spam List Definitions = %etc-dir%/spam.lists.conf
Virus Scanner Definitions = %etc-dir%/virus.scanners.conf
Spam Checks = %brules-dir%/spam.checks.rules
Spam List =
Spam Domain List =
Spam Lists To Be Spam = 1
Spam Lists To Reach High Score = 3
Spam List Timeout = 10
Max Spam List Timeouts = 7
Spam List Timeouts History = 10
Is Definitely Not Spam = %brules-dir%/approved.senders.rules
Is Definitely Spam = %brules-dir%/banned.senders.rules
Definite Spam Is High Scoring = yes
Ignore Spam Whitelist If Recipients Exceed = 20
Max Spam Check Size = 4000k
Use Watermarking = no
Add Watermark = yes
Check Watermarks With No Sender = yes
Treat Invalid Watermarks With No Sender as Spam = nothing
Check Watermarks To Skip Spam Checks = yes
Watermark Secret = %org-name%-BaruwaFW-Secret
Watermark Lifetime = 604800
Watermark Header = X-%org-name%-BaruwaFW-Watermark:
Use SpamAssassin = yes
Max SpamAssassin Size = 800k
Required SpamAssassin Score = %brules-dir%/spam.score.rules
High SpamAssassin Score = %brules-dir%/highspam.score.rules
SpamAssassin Auto Whitelist = yes
SpamAssassin Timeout = 75
Max SpamAssassin Timeouts = 10
SpamAssassin Timeouts History = 30
Check SpamAssassin If On Spam List = yes
Include Binary Attachments In SpamAssassin = no
Spam Score = yes
Cache SpamAssassin Results = yes
SpamAssassin Cache Database File = %spool-dir%/incoming/SpamAssassin.cache.db
Rebuild Bayes Every = 0
Wait During Bayes Rebuild = no
Use Custom Spam Scanner = no
Max Custom Spam Scanner Size = 20k
Custom Spam Scanner Timeout = 20
Max Custom Spam Scanner Timeouts = 10
Custom Spam Scanner Timeout History = 20
Spam Actions = %brules-dir%/spam.actions.rules
High Scoring Spam Actions = %brules-dir%/highspam.actions.rules
Non Spam Actions = %rules-dir%/nonspam.actions.rules
SpamAssassin Rule Actions =
Sender Spam Report = %brules-dir%/senderspamreport.rules
Sender Spam List Report = %brules-dir%/senderspamrblreport.rules
Sender SpamAssassin Report = %brules-dir%/senderspamsareport.rules
Inline Spam Warning = %brules-dir%/inlinespamwarning.rules
Recipient Spam Report = %brules-dir%/recipientspamreport.rules
Enable Spam Bounce = %rules-dir%/bounce.rules
Bounce Spam As Attachment = no
Syslog Facility = mail
Log Speed = no
Log Spam = no
Log Non Spam = no
Log Delivery And Non-Delivery = no
Log Permitted Filenames = no
Log Permitted Filetypes = no
Log Permitted File MIME Types = no
Log Silent Viruses = no
Log Dangerous HTML Tags = no
Log SpamAssassin Rule Actions = no
SpamAssassin Temporary Dir = /var/spool/MailScanner/incoming/SpamAssassin-Temp
SpamAssassin User State Dir =
SpamAssassin Install Prefix =
SpamAssassin Site Rules Dir = /etc/mail/spamassassin
SpamAssassin Local Rules Dir =
SpamAssassin Local State Dir =
SpamAssassin Default Rules Dir =
DB DSN = DBI:Pg:database=baruwa
DB Username = baruwa
DB Password = password
SQL Serial Number = SELECT MAX(value) AS confserialnumber FROM configurations WHERE internal='confserialnumber'
SQL Quick Peek = SELECT dbvalue(value) AS value FROM quickpeek WHERE external = ? AND (hostname = ? OR hostname='default') LIMIT 1
SQL Config = SELECT internal, dbvalue(value) AS value, hostname FROM quickpeek WHERE hostname=? OR hostname='default'
SQL Ruleset = SELECT row_number, ruleset AS rule FROM msrulesets WHERE name=?
SQL SpamAssassin Config =
SQL Debug = no
Sphinx Host = 127.0.0.1
Sphinx Port = 9306
MCP Checks = no
First Check = spam
MCP Required SpamAssassin Score = 1
MCP High SpamAssassin Score = 10
MCP Error Score = 1
MCP Header = X-%org-name%-BaruwaFW-MCPCheck:
Non MCP Actions = deliver
MCP Actions = deliver
High Scoring MCP Actions = deliver
Bounce MCP As Attachment = no
MCP Modify Subject = start
MCP Subject Text = {MCP?}
High Scoring MCP Modify Subject = start
High Scoring MCP Subject Text = {MCP?}
Is Definitely MCP = no
Is Definitely Not MCP = no
Definite MCP Is High Scoring = no
Always Include MCP Report = no
Detailed MCP Report = yes
Include Scores In MCP Report = no
Log MCP = no
MCP Max SpamAssassin Timeouts = 20
MCP Max SpamAssassin Size = 100k
MCP SpamAssassin Timeout = 10
MCP SpamAssassin Prefs File = %mcp-dir%/mcp.spam.assassin.prefs.conf
MCP SpamAssassin User State Dir =
MCP SpamAssassin Local Rules Dir = %mcp-dir%
MCP SpamAssassin Default Rules Dir = %mcp-dir%
MCP SpamAssassin Install Prefix = %mcp-dir%
Recipient MCP Report = %report-dir%/recipient.mcp.report.txt
Sender MCP Report = %report-dir%/sender.mcp.report.txt
Use Default Rules With Multiple Recipients = no
Read IP Address From Received Header = no
Spam Score Number Format = %d.1f
MailScanner Version Number = 4.85.5
SpamAssassin Cache Timings = 1800,300,10800,172800,600
Debug = no
Debug SpamAssassin = no
Run In Foreground = no
Always Looked Up Last = &BaruwaLog
Always Looked Up Last After Batch = no
Deliver In Background = yes
Delivery Method = batch
Split Exim Spool = no
Lockfile Dir = %spool-dir%/incoming/Locks
Custom Functions Dir = /usr/share/baruwa/CustomFunctions
Lock Type =
Syslog Socket Type =
Automatic Syntax Check = yes
Minimum Code Status = supported
include /etc/MailScanner/conf.d/*.conf
"

test Mailscanner.lns get conf =
    { "#comment" = "Main configuration file for the MailScanner E-Mail Virus Scanner"}
    { "%org-name%" = "BARUWA" }
    { "%org-long-name%" = "BARUWA MAILFW" }
    { "%web-site%" = "www.baruwa.com" }
    { "%etc-dir%" = "/etc/MailScanner" }
    { "%reports-base%" = "/etc/MailScanner/reports" }
    { "%report-dir%" = "/etc/MailScanner/reports/en" }
    { "%rules-dir%" = "/etc/MailScanner/rules" }
    { "%mcp-dir%" = "/etc/MailScanner/mcp" }
    { "%spool-dir%" = "/var/spool/MailScanner" }
    { "%signature-dir%" = "/etc/MailScanner/baruwa/signatures" }
    { "%brules-dir%" = "/etc/MailScanner/baruwa/rules" }
    { "Max Children" = "5" }
    { "Run As User" = "exim" }
    { "Run As Group" = "exim" }
    { "Queue Scan Interval" = "6" }
    { "Incoming Queue Dir" = "/var/spool/exim.in/input" }
    { "Outgoing Queue Dir" = "/var/spool/exim/input" }
    { "Incoming Work Dir" = "%spool-dir%/incoming" }
    { "Quarantine Dir" = "%spool-dir%/quarantine" }
    { "PID file" = "/var/run/MailScanner/MailScanner.pid" }
    { "Restart Every" = "7200" }
    { "MTA" = "exim" }
    { "Sendmail" = "/usr/sbin/exim -C /etc/exim/exim_out.conf" }
    { "Sendmail2" = "/usr/sbin/exim -C /etc/exim/exim_out.conf" }
    { "Incoming Work User" = "exim" }
    { "Incoming Work Group" = "clam" }
    { "Incoming Work Permissions" = "0640" }
    { "Quarantine User" = "exim" }
    { "Quarantine Group" = "baruwa" }
    { "Quarantine Permissions" = "0660" }
    { "Max Unscanned Bytes Per Scan" = "100m" }
    { "Max Unsafe Bytes Per Scan" = "50m" }
    { "Max Unscanned Messages Per Scan" = "30" }
    { "Max Unsafe Messages Per Scan" = "30" }
    { "Max Normal Queue Size" = "800" }
    { "Scan Messages" = "%rules-dir%/scan.messages.rules" }
    { "Reject Message" = "no" }
    { "Maximum Processing Attempts" = "6" }
    { "Processing Attempts Database" = "%spool-dir%/incoming/Processing.db" }
    { "Maximum Attachments Per Message" = "200" }
    { "Expand TNEF" = "yes" }
    { "Use TNEF Contents" = "replace" }
    { "Deliver Unparsable TNEF" = "no" }
    { "TNEF Expander" = "/usr/bin/tnef --maxsize=100000000" }
    { "TNEF Timeout" = "120" }
    { "File Command" = "/usr/sbin/file-wrapper" }
    { "File Timeout" = "20" }
    { "Gunzip Command" = "/bin/gunzip" }
    { "Gunzip Timeout" = "50" }
    { "Unrar Command" = "/usr/bin/unrar" }
    { "Unrar Timeout" = "50" }
    { "Find UU-Encoded Files" = "no" }
    { "Maximum Message Size" = "%brules-dir%/message.size.rules" }
    { "Maximum Attachment Size" = "-1" }
    { "Minimum Attachment Size" = "-1" }
    { "Maximum Archive Depth" = "4" }
    { "Find Archives By Content" = "yes" }
    { "Unpack Microsoft Documents" = "yes" }
    { "Zip Attachments" = "no" }
    { "Attachments Zip Filename" = "MessageAttachments.zip" }
    { "Attachments Min Total Size To Zip" = "100k" }
    { "Attachment Extensions Not To Zip" = ".zip .rar .gz .tgz .jpg .jpeg .mpg .mpe .mpeg .mp3 .rpm .htm .html .eml" }
    { "Add Text Of Doc" = "no" }
    { "Antiword" = "/usr/bin/antiword -f" }
    { "Antiword Timeout" = "50" }
    { "Unzip Maximum Files Per Archive" = "0" }
    { "Unzip Maximum File Size" = "50k" }
    { "Unzip Filenames" = "*.txt *.ini *.log *.csv" }
    { "Unzip MimeType" = "text/plain" }
    { "Virus Scanning" = "%brules-dir%/virus.checks.rules" }
    { "Virus Scanners" = "auto" }
    { "Virus Scanner Timeout" = "300" }
    { "Deliver Disinfected Files" = "no" }
    { "Silent Viruses" = "HTML-IFrame All-Viruses" }
    { "Still Deliver Silent Viruses" = "no" }
    { "Non-Forging Viruses" = "Joke/ OF97/ WM97/ W97M/ eicar" }
    { "Spam-Virus Header" = "X-%org-name%-BaruwaFW-SpamVirus-Report:" }
    { "Virus Names Which Are Spam" = "Sanesecurity.Spam*UNOFFICIAL HTML/* *Phish* *Suspected-phishing_safebrowsing*" }
    { "Block Encrypted Messages" = "no" }
    { "Block Unencrypted Messages" = "no" }
    { "Allow Password-Protected Archives" = "yes" }
    { "Check Filenames In Password-Protected Archives" = "yes" }
    { "Allowed Sophos Error Messages" }
    { "Sophos IDE Dir" = "/opt/sophos-av/lib/sav" }
    { "Sophos Lib Dir" = "/opt/sophos-av/lib" }
    { "Monitors For Sophos Updates" = "/opt/sophos-av/lib/sav/*.ide" }
    { "Monitors for ClamAV Updates" = "/var/lib/clamav/*.cvd" }
    { "ClamAVmodule Maximum Recursion Level" = "8" }
    { "ClamAVmodule Maximum Files" = "1000" }
    { "ClamAVmodule Maximum File Size" = "10000000" }
    { "ClamAVmodule Maximum Compression Ratio" = "250" }
    { "Clamd Port" = "3310" }
    { "Clamd Socket" = "/var/run/clamav/clamd.sock" }
    { "Clamd Lock File" }
    { "Clamd Use Threads" = "no" }
    { "ClamAV Full Message Scan" = "yes" }
    { "Fpscand Port" = "10200" }
    { "Dangerous Content Scanning" = "%rules-dir%/content.scanning.rules" }
    { "Allow Partial Messages" = "no" }
    { "Allow External Message Bodies" = "no" }
    { "Find Phishing Fraud" = "yes" }
    { "Also Find Numeric Phishing" = "yes" }
    { "Use Stricter Phishing Net" = "yes" }
    { "Highlight Phishing Fraud" = "yes" }
    { "Phishing Safe Sites File" = "%etc-dir%/phishing.safe.sites.conf" }
    { "Phishing Bad Sites File" = "%etc-dir%/phishing.bad.sites.conf" }
    { "Country Sub-Domains List" = "%etc-dir%/country.domains.conf" }
    { "Allow IFrame Tags" = "disarm" }
    { "Allow Form Tags" = "disarm" }
    { "Allow Script Tags" = "disarm" }
    { "Allow WebBugs" = "disarm" }
    { "Ignored Web Bug Filenames" = "spacer pixel.gif pixel.png gap" }
    { "Known Web Bug Servers" = "msgtag.com" }
    { "Web Bug Replacement" = "https://datafeeds.baruwa.com/1x1spacer.gif" }
    { "Allow Object Codebase Tags" = "disarm" }
    { "Convert Dangerous HTML To Text" = "no" }
    { "Convert HTML To Text" = "no" }
    { "Archives Are" = "zip rar ole" }
    { "Allow Filenames" }
    { "Deny Filenames" }
    { "Filename Rules" = "%rules-dir%/filename.rules" }
    { "Allow Filetypes" }
    { "Allow File MIME Types" }
    { "Deny Filetypes" }
    { "Deny File MIME Types" }
    { "Filetype Rules" = "%rules-dir%/filetype.rules" }
    { "Archives: Allow Filenames" }
    { "Archives: Deny Filenames" }
    { "Archives: Filename Rules" = "%etc-dir%/archives.filename.rules.conf" }
    { "Archives: Allow Filetypes" }
    { "Archives: Allow File MIME Types" }
    { "Archives: Deny Filetypes" }
    { "Archives: Deny File MIME Types" }
    { "Archives: Filetype Rules" = "%etc-dir%/archives.filetype.rules.conf" }
    { "Default Rename Pattern" = "__FILENAME__.disarmed" }
    { "Quarantine Infections" = "yes" }
    { "Quarantine Silent Viruses" = "no" }
    { "Quarantine Modified Body" = "no" }
    { "Quarantine Whole Message" = "yes" }
    { "Quarantine Whole Messages As Queue Files" = "no" }
    { "Keep Spam And MCP Archive Clean" = "yes" }
    { "Language Strings" = "%brules-dir%/languages.rules" }
    { "Rejection Report" = "%brules-dir%/rejectionreport.rules" }
    { "Deleted Bad Content Message Report" = "%brules-dir%/deletedcontentmessage.rules" }
    { "Deleted Bad Filename Message Report" = "%brules-dir%/deletedfilenamemessage.rules" }
    { "Deleted Virus Message Report" = "%brules-dir%/deletedvirusmessage.rules" }
    { "Deleted Size Message Report" = "%brules-dir%/deletedsizemessage.rules" }
    { "Stored Bad Content Message Report" = "%brules-dir%/storedcontentmessage.rules" }
    { "Stored Bad Filename Message Report" = "%brules-dir%/storedfilenamemessage.rules" }
    { "Stored Virus Message Report" = "%brules-dir%/storedvirusmessage.rules" }
    { "Stored Size Message Report" = "%brules-dir%/storedsizemessage.rules" }
    { "Disinfected Report" = "%brules-dir%/disinfectedreport.rules" }
    { "Inline HTML Signature" = "%brules-dir%/html.sigs.rules" }
    { "Inline Text Signature" = "%brules-dir%/text.sigs.rules" }
    { "Signature Image Filename" = "%brules-dir%/sig.imgs.names.rules" }
    { "Signature Image <img> Filename" = "%brules-dir%/sig.imgs.rules" }
    { "Inline HTML Warning" = "%brules-dir%/inlinewarninghtml.rules" }
    { "Inline Text Warning" = "%brules-dir%/inlinewarningtxt.rules" }
    { "Sender Content Report" = "%brules-dir%/sendercontentreport.rules" }
    { "Sender Error Report" = "%brules-dir%/sendererrorreport.rules" }
    { "Sender Bad Filename Report" = "%brules-dir%/senderfilenamereport.rules" }
    { "Sender Virus Report" = "%brules-dir%/sendervirusreport.rules" }
    { "Sender Size Report" = "%brules-dir%/sendersizereport.rules" }
    { "Hide Incoming Work Dir" = "yes" }
    { "Include Scanner Name In Reports" = "yes" }
    { "Mail Header" = "X-%org-name%-BaruwaFW:" }
    { "Spam Header" = "X-%org-name%-BaruwaFW-SpamCheck:" }
    { "Spam Score Header" = "X-%org-name%-BaruwaFW-SpamScore:" }
    { "Information Header" = "X-%org-name%-BaruwaFW-Information:" }
    { "Add Envelope From Header" = "yes" }
    { "Add Envelope To Header" = "no" }
    { "Envelope From Header" = "X-BARUWA-BaruwaFW-From:" }
    { "Envelope To Header" = "X-%org-name%-BaruwaFW-To:" }
    { "ID Header" = "X-%org-name%-BaruwaFW-ID:" }
    { "IP Protocol Version Header" }
    { "Spam Score Character" = "s" }
    { "SpamScore Number Instead Of Stars" = "no" }
    { "Minimum Stars If On Spam List" = "0" }
    { "Clean Header Value" = "Found to be clean" }
    { "Infected Header Value" = "Found to be infected" }
    { "Disinfected Header Value" = "Disinfected" }
    { "Information Header Value" = "Please contact %org-long-name% for more information" }
    { "Detailed Spam Report" = "yes" }
    { "Include Scores In SpamAssassin Report" = "yes" }
    { "Always Include SpamAssassin Report" = "no" }
    { "Multiple Headers" = "add" }
    { "Place New Headers At Top Of Message" = "yes" }
    { "Hostname" = "the %org-name% ($HOSTNAME) Baruwa" }
    { "Sign Messages Already Processed" = "no" }
    { "Sign Clean Messages" = "%brules-dir%/sign.clean.msgs.rules" }
    { "Attach Image To Signature" = "yes" }
    { "Attach Image To HTML Message Only" = "yes" }
    { "Allow Multiple HTML Signatures" = "no" }
    { "Dont Sign HTML If Headers Exist" }
    { "Mark Infected Messages" = "yes" }
    { "Mark Unscanned Messages" = "no" }
    { "Unscanned Header Value" = "Not scanned: please contact %org-long-name% for details" }
    { "Remove These Headers" = "X-Mozilla-Status: X-Mozilla-Status2:" }
    { "Deliver Cleaned Messages" = "yes" }
    { "Notify Senders" = "no" }
    { "Notify Senders Of Viruses" = "no" }
    { "Notify Senders Of Blocked Filenames Or Filetypes" = "no" }
    { "Notify Senders Of Blocked Size Attachments" = "no" }
    { "Notify Senders Of Other Blocked Content" = "no" }
    { "Never Notify Senders Of Precedence" = "list bulk" }
    { "Scanned Modify Subject" = "no" }
    { "Scanned Subject Text" = "{Scanned}" }
    { "Virus Modify Subject" = "no" }
    { "Virus Subject Text" = "{Virus?}" }
    { "Filename Modify Subject" = "no" }
    { "Filename Subject Text" = "{Filename?}" }
    { "Content Modify Subject" = "no" }
    { "Content Subject Text" = "{Dangerous Content?}" }
    { "Size Modify Subject" = "no" }
    { "Size Subject Text" = "{Size}" }
    { "Disarmed Modify Subject" = "no" }
    { "Disarmed Subject Text" = "{Disarmed}" }
    { "Phishing Modify Subject" = "yes" }
    { "Phishing Subject Text" = "{Suspected Phishing?}" }
    { "Spam Modify Subject" = "no" }
    { "Spam Subject Text" = "{Spam?}" }
    { "High Scoring Spam Modify Subject" = "no" }
    { "High Scoring Spam Subject Text" = "{Spam?}" }
    { "Warning Is Attachment" = "yes" }
    { "Attachment Warning Filename" = "%org-name%-Attachment-Warning.txt" }
    { "Attachment Encoding Charset" = "ISO-8859-1" }
    { "Archive Mail" }
    { "Missing Mail Archive Is" = "file" }
    { "Send Notices" = "no" }
    { "Notices Include Full Headers" = "yes" }
    { "Hide Incoming Work Dir in Notices" = "yes" }
    { "Notice Signature" = "-- \\n%org-name%\\nEmail Security\\n%website%" }
    { "Notices From" = "Baruwa" }
    { "Notices To" = "postmaster" }
    { "Local Postmaster" = "postmaster" }
    { "Spam List Definitions" = "%etc-dir%/spam.lists.conf" }
    { "Virus Scanner Definitions" = "%etc-dir%/virus.scanners.conf" }
    { "Spam Checks" = "%brules-dir%/spam.checks.rules" }
    { "Spam List" }
    { "Spam Domain List" }
    { "Spam Lists To Be Spam" = "1" }
    { "Spam Lists To Reach High Score" = "3" }
    { "Spam List Timeout" = "10" }
    { "Max Spam List Timeouts" = "7" }
    { "Spam List Timeouts History" = "10" }
    { "Is Definitely Not Spam" = "%brules-dir%/approved.senders.rules" }
    { "Is Definitely Spam" = "%brules-dir%/banned.senders.rules" }
    { "Definite Spam Is High Scoring" = "yes" }
    { "Ignore Spam Whitelist If Recipients Exceed" = "20" }
    { "Max Spam Check Size" = "4000k" }
    { "Use Watermarking" = "no" }
    { "Add Watermark" = "yes" }
    { "Check Watermarks With No Sender" = "yes" }
    { "Treat Invalid Watermarks With No Sender as Spam" = "nothing" }
    { "Check Watermarks To Skip Spam Checks" = "yes" }
    { "Watermark Secret" = "%org-name%-BaruwaFW-Secret" }
    { "Watermark Lifetime" = "604800" }
    { "Watermark Header" = "X-%org-name%-BaruwaFW-Watermark:" }
    { "Use SpamAssassin" = "yes" }
    { "Max SpamAssassin Size" = "800k" }
    { "Required SpamAssassin Score" = "%brules-dir%/spam.score.rules" }
    { "High SpamAssassin Score" = "%brules-dir%/highspam.score.rules" }
    { "SpamAssassin Auto Whitelist" = "yes" }
    { "SpamAssassin Timeout" = "75" }
    { "Max SpamAssassin Timeouts" = "10" }
    { "SpamAssassin Timeouts History" = "30" }
    { "Check SpamAssassin If On Spam List" = "yes" }
    { "Include Binary Attachments In SpamAssassin" = "no" }
    { "Spam Score" = "yes" }
    { "Cache SpamAssassin Results" = "yes" }
    { "SpamAssassin Cache Database File" = "%spool-dir%/incoming/SpamAssassin.cache.db" }
    { "Rebuild Bayes Every" = "0" }
    { "Wait During Bayes Rebuild" = "no" }
    { "Use Custom Spam Scanner" = "no" }
    { "Max Custom Spam Scanner Size" = "20k" }
    { "Custom Spam Scanner Timeout" = "20" }
    { "Max Custom Spam Scanner Timeouts" = "10" }
    { "Custom Spam Scanner Timeout History" = "20" }
    { "Spam Actions" = "%brules-dir%/spam.actions.rules" }
    { "High Scoring Spam Actions" = "%brules-dir%/highspam.actions.rules" }
    { "Non Spam Actions" = "%rules-dir%/nonspam.actions.rules" }
    { "SpamAssassin Rule Actions" }
    { "Sender Spam Report" = "%brules-dir%/senderspamreport.rules" }
    { "Sender Spam List Report" = "%brules-dir%/senderspamrblreport.rules" }
    { "Sender SpamAssassin Report" = "%brules-dir%/senderspamsareport.rules" }
    { "Inline Spam Warning" = "%brules-dir%/inlinespamwarning.rules" }
    { "Recipient Spam Report" = "%brules-dir%/recipientspamreport.rules" }
    { "Enable Spam Bounce" = "%rules-dir%/bounce.rules" }
    { "Bounce Spam As Attachment" = "no" }
    { "Syslog Facility" = "mail" }
    { "Log Speed" = "no" }
    { "Log Spam" = "no" }
    { "Log Non Spam" = "no" }
    { "Log Delivery And Non-Delivery" = "no" }
    { "Log Permitted Filenames" = "no" }
    { "Log Permitted Filetypes" = "no" }
    { "Log Permitted File MIME Types" = "no" }
    { "Log Silent Viruses" = "no" }
    { "Log Dangerous HTML Tags" = "no" }
    { "Log SpamAssassin Rule Actions" = "no" }
    { "SpamAssassin Temporary Dir" = "/var/spool/MailScanner/incoming/SpamAssassin-Temp" }
    { "SpamAssassin User State Dir" }
    { "SpamAssassin Install Prefix" }
    { "SpamAssassin Site Rules Dir" = "/etc/mail/spamassassin" }
    { "SpamAssassin Local Rules Dir" }
    { "SpamAssassin Local State Dir" }
    { "SpamAssassin Default Rules Dir" }
    { "DB DSN" = "DBI:Pg:database=baruwa" }
    { "DB Username" = "baruwa" }
    { "DB Password" = "password" }
    { "SQL Serial Number" = "SELECT MAX(value) AS confserialnumber FROM configurations WHERE internal='confserialnumber'" }
    { "SQL Quick Peek" = "SELECT dbvalue(value) AS value FROM quickpeek WHERE external = ? AND (hostname = ? OR hostname='default') LIMIT 1" }
    { "SQL Config" = "SELECT internal, dbvalue(value) AS value, hostname FROM quickpeek WHERE hostname=? OR hostname='default'" }
    { "SQL Ruleset" = "SELECT row_number, ruleset AS rule FROM msrulesets WHERE name=?" }
    { "SQL SpamAssassin Config" }
    { "SQL Debug" = "no" }
    { "Sphinx Host" = "127.0.0.1" }
    { "Sphinx Port" = "9306" }
    { "MCP Checks" = "no" }
    { "First Check" = "spam" }
    { "MCP Required SpamAssassin Score" = "1" }
    { "MCP High SpamAssassin Score" = "10" }
    { "MCP Error Score" = "1" }
    { "MCP Header" = "X-%org-name%-BaruwaFW-MCPCheck:" }
    { "Non MCP Actions" = "deliver" }
    { "MCP Actions" = "deliver" }
    { "High Scoring MCP Actions" = "deliver" }
    { "Bounce MCP As Attachment" = "no" }
    { "MCP Modify Subject" = "start" }
    { "MCP Subject Text" = "{MCP?}" }
    { "High Scoring MCP Modify Subject" = "start" }
    { "High Scoring MCP Subject Text" = "{MCP?}" }
    { "Is Definitely MCP" = "no" }
    { "Is Definitely Not MCP" = "no" }
    { "Definite MCP Is High Scoring" = "no" }
    { "Always Include MCP Report" = "no" }
    { "Detailed MCP Report" = "yes" }
    { "Include Scores In MCP Report" = "no" }
    { "Log MCP" = "no" }
    { "MCP Max SpamAssassin Timeouts" = "20" }
    { "MCP Max SpamAssassin Size" = "100k" }
    { "MCP SpamAssassin Timeout" = "10" }
    { "MCP SpamAssassin Prefs File" = "%mcp-dir%/mcp.spam.assassin.prefs.conf" }
    { "MCP SpamAssassin User State Dir" }
    { "MCP SpamAssassin Local Rules Dir" = "%mcp-dir%" }
    { "MCP SpamAssassin Default Rules Dir" = "%mcp-dir%" }
    { "MCP SpamAssassin Install Prefix" = "%mcp-dir%" }
    { "Recipient MCP Report" = "%report-dir%/recipient.mcp.report.txt" }
    { "Sender MCP Report" = "%report-dir%/sender.mcp.report.txt" }
    { "Use Default Rules With Multiple Recipients" = "no" }
    { "Read IP Address From Received Header" = "no" }
    { "Spam Score Number Format" = "%d.1f" }
    { "MailScanner Version Number" = "4.85.5" }
    { "SpamAssassin Cache Timings" = "1800,300,10800,172800,600" }
    { "Debug" = "no" }
    { "Debug SpamAssassin" = "no" }
    { "Run In Foreground" = "no" }
    { "Always Looked Up Last" = "&BaruwaLog" }
    { "Always Looked Up Last After Batch" = "no" }
    { "Deliver In Background" = "yes" }
    { "Delivery Method" = "batch" }
    { "Split Exim Spool" = "no" }
    { "Lockfile Dir" = "%spool-dir%/incoming/Locks" }
    { "Custom Functions Dir" = "/usr/share/baruwa/CustomFunctions" }
    { "Lock Type" }
    { "Syslog Socket Type" }
    { "Automatic Syntax Check" = "yes" }
    { "Minimum Code Status" = "supported" }
    { "include" = "/etc/MailScanner/conf.d/*.conf"}