/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.cipher;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.Typed;
import org.sonatype.plexus.components.cipher.PBECipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

@Singleton
@Named(value="default")
@Typed(value={PlexusCipher.class})
public class DefaultPlexusCipher
implements PlexusCipher {
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final PBECipher _cipher = new PBECipher();

    @Override
    public String encrypt(String str2, String passPhrase) throws PlexusCipherException {
        if (str2 == null || str2.length() < 1) {
            return str2;
        }
        return this._cipher.encrypt64(str2, passPhrase);
    }

    @Override
    public String encryptAndDecorate(String str2, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str2, passPhrase));
    }

    @Override
    public String decrypt(String str2, String passPhrase) throws PlexusCipherException {
        if (str2 == null || str2.length() < 1) {
            return str2;
        }
        return this._cipher.decrypt64(str2, passPhrase);
    }

    @Override
    public String decryptDecorated(String str2, String passPhrase) throws PlexusCipherException {
        if (str2 == null || str2.length() < 1) {
            return str2;
        }
        if (this.isEncryptedString(str2)) {
            return this.decrypt(this.unDecorate(str2), passPhrase);
        }
        return this.decrypt(str2, passPhrase);
    }

    @Override
    public boolean isEncryptedString(String str2) {
        if (str2 == null || str2.length() < 1) {
            return false;
        }
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str2);
        return matcher.matches() || matcher.find();
    }

    @Override
    public String unDecorate(String str2) throws PlexusCipherException {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str2);
        if (matcher.matches() || matcher.find()) {
            return matcher.group(1);
        }
        throw new PlexusCipherException("default.plexus.cipher.badEncryptedPassword");
    }

    @Override
    public String decorate(String str2) {
        return '{' + (str2 == null ? "" : str2) + '}';
    }

    public static String[] getServiceTypes() {
        Provider[] providers;
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Object> keys2 = provider.keySet();
            for (Object o : keys2) {
                String key2 = (String)o;
                if ((key2 = key2.split(" ")[0]).startsWith("Alg.Alias.")) {
                    key2 = key2.substring(10);
                }
                int ix = key2.indexOf(46);
                result.add(key2.substring(0, ix));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        Provider[] providers;
        HashSet<String> result = new HashSet<String>();
        for (Provider provider : providers = Security.getProviders()) {
            Set<Object> keys2 = provider.keySet();
            for (Object o : keys2) {
                String key2 = (String)o;
                if ((key2 = key2.split(" ")[0]).startsWith(serviceType + ".")) {
                    result.add(key2.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key2.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result.add(key2.substring(serviceType.length() + 11));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        String[] serviceTypes = DefaultPlexusCipher.getServiceTypes();
        if (serviceTypes != null) {
            for (String serviceType : serviceTypes) {
                String[] serviceProviders = DefaultPlexusCipher.getCryptoImpls(serviceType);
                if (serviceProviders != null) {
                    System.out.println(serviceType + ": provider list");
                    for (String provider : serviceProviders) {
                        System.out.println("        " + provider);
                    }
                    continue;
                }
                System.out.println(serviceType + ": does not have any providers in this environment");
            }
        }
    }
}

