/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.model.state.State;

@CommandDefinition(name="edit", description="Load an installation or a provisioning xml file in order to create a provisioning state")
public class StateEditCommand
extends PmSessionCommand {
    @Argument(required=false, description="Installation directory or provisionng file")
    protected File dir;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        State state;
        try {
            state = new State(invoc.getPmSession(), this.getInstallationHome(invoc.getConfiguration().getAeshContext()));
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.readContentFailed(), ex);
        }
        invoc.getPmSession().setState(state);
        invoc.setPrompt(invoc.getPmSession().buildPrompt(state.getPath()));
        invoc.println("Entering provisioning edit mode.Use 'add-dependency' command to add feature packs. Call 'leave-state' to leave this state.");
    }

    protected Path getInstallationHome(AeshContext context) {
        return this.dir == null ? PmSession.getWorkDir(context) : this.dir.toPath();
    }
}

